/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.mapSourceAndTarget.internal.tasks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.equations.Equation;
import org.cytoscape.equations.EquationCompiler;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.util.ListMultipleSelection;

public class MapTask
extends AbstractTask {
    private final CyServiceRegistrar registrar;
    private final CyApplicationManager applicationManager;
    private final CyNetwork currentNetwork;
    private final EquationCompiler compiler;
    public static final String TARGET_EQ = "=%sTABLECELL(TARGETID($SUID), \"%s\")";
    public static final String SOURCE_EQ = "=%sTABLECELL(SOURCEID($SUID), \"%s\")";
    @Tunable(description="Node columns to map")
    public ListMultipleSelection<String> nodeColumns;

    public MapTask(CyServiceRegistrar registrar) {
        this.registrar = registrar;
        this.applicationManager = (CyApplicationManager)registrar.getService(CyApplicationManager.class);
        this.compiler = (EquationCompiler)registrar.getService(EquationCompiler.class);
        this.currentNetwork = this.applicationManager.getCurrentNetwork();
        if (this.currentNetwork == null) {
            return;
        }
        ArrayList<String> names = new ArrayList<String>(this.getNonListColumnNames(this.currentNetwork.getDefaultNodeTable()));
        Collections.sort(names);
        this.nodeColumns = new ListMultipleSelection(names);
    }

    public void run(TaskMonitor monitor) {
        if (this.currentNetwork == null) {
            monitor.showMessage(TaskMonitor.Level.ERROR, "No network");
            return;
        }
        List columns = this.nodeColumns.getSelectedValues();
        if (columns == null || columns.isEmpty()) {
            monitor.showMessage(TaskMonitor.Level.ERROR, "No columns selected");
            return;
        }
        CyTable edgeTable = this.currentNetwork.getDefaultEdgeTable();
        CyTable nodeTable = this.currentNetwork.getDefaultNodeTable();
        for (String column : columns) {
            this.createColumn(edgeTable, nodeTable.getColumn(column).getType(), "node::Source_", column, SOURCE_EQ);
            this.createColumn(edgeTable, nodeTable.getColumn(column).getType(), "node::Target_", column, TARGET_EQ);
        }
    }

    public List<String> getNonListColumnNames(CyTable nodeTable) {
        ArrayList<String> names = new ArrayList<String>();
        for (CyColumn column : nodeTable.getColumns()) {
            if (List.class.isAssignableFrom(column.getType())) continue;
            names.add(column.getName());
        }
        return names;
    }

    public void createColumn(CyTable targetTable, Class<?> clazz, String prefix, String column, String equationPattern) {
        HashMap<String, Class<Long>> variableNameToTypeMap = new HashMap<String, Class<Long>>();
        variableNameToTypeMap.put("SUID", Long.class);
        variableNameToTypeMap.put(column, clazz == Integer.class ? Long.class : clazz);
        targetTable.createColumn(prefix + column, clazz, false);
        String formula = String.format(equationPattern, clazz.getSimpleName().toUpperCase(), column);
        if (this.compiler.compile(formula, variableNameToTypeMap)) {
            Equation eq = this.compiler.getEquation();
            for (CyRow row : targetTable.getAllRows()) {
                row.set(prefix + column, (Object)eq);
            }
        } else {
            Equation eq = this.compiler.getErrorEquation(formula, clazz, this.compiler.getLastErrorMsg());
            for (CyRow row : targetTable.getAllRows()) {
                row.set(prefix + column, (Object)eq);
            }
        }
    }
}

