/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.mapSourceAndTarget.internal.model;

import java.util.Collection;
import java.util.Properties;
import org.cytoscape.mapSourceAndTarget.internal.tasks.MapTask;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.events.NetworkAddedEvent;
import org.cytoscape.model.events.NetworkAddedListener;
import org.cytoscape.property.AbstractConfigDirPropsReader;
import org.cytoscape.property.CyProperty;
import org.cytoscape.service.util.CyServiceRegistrar;

public class MapSandTManager
implements NetworkAddedListener {
    final CyServiceRegistrar registrar;
    final Properties configProperties;
    String defaultColumn;

    public MapSandTManager(CyServiceRegistrar registrar) {
        this.registrar = registrar;
        this.configProperties = this.getPropertyService();
        if (!this.configProperties.containsKey("autoMap")) {
            this.configProperties.setProperty("autoMap", "FALSE");
        }
    }

    public void handleEvent(NetworkAddedEvent e) {
        if (!this.getBoolean(this.configProperties, "autoMap")) {
            return;
        }
        this.defaultColumn = this.configProperties.getProperty("defaultColumn", "name");
        CyNetwork net = e.getNetwork();
        Collection columns = net.getDefaultEdgeTable().getColumns("node");
        if (columns != null && columns.size() > 0) {
            return;
        }
        MapTask task = new MapTask(this.registrar);
        CyTable edgeTable = net.getDefaultEdgeTable();
        CyTable nodeTable = net.getDefaultNodeTable();
        task.createColumn(edgeTable, nodeTable.getColumn(this.defaultColumn).getType(), "node::Source_", this.defaultColumn, "=%sTABLECELL(SOURCEID($SUID), \"%s\")");
        task.createColumn(edgeTable, nodeTable.getColumn(this.defaultColumn).getType(), "node::Target_", this.defaultColumn, "=%sTABLECELL(TARGETID($SUID), \"%s\")");
    }

    private boolean getBoolean(Properties p, String prop) {
        String v = p.getProperty(prop, "FALSE");
        return Boolean.valueOf(v);
    }

    private Properties getPropertyService() {
        CyPropertyReader service = new CyPropertyReader();
        Properties serviceProps = new Properties();
        serviceProps.setProperty("cyPropertyName", service.getName());
        this.registrar.registerAllServices((Object)service, serviceProps);
        return (Properties)service.getProperties();
    }

    private class CyPropertyReader
    extends AbstractConfigDirPropsReader {
        public CyPropertyReader() {
            super("mapSourceAndTarget", "mapSourceAndTarget.props", CyProperty.SavePolicy.CONFIG_DIR);
        }
    }
}

