/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal.view.util;

import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.image.FilteredImageSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JToolTip;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.cytoscape.application.swing.AbstractCyAction;
import org.cytoscape.application.swing.CyAction;
import org.cytoscape.application.swing.ToolBarComponent;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.CyToolTip;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.util.swing.TextIcon;

public class CyToolBar
extends JToolBar {
    private static int BUTTON_BORDER_SIZE = 2;
    private static int DEF_ICON_WIDTH = 32;
    private static int DEF_ICON_HEIGHT = 32;
    protected final int iconWidth;
    protected final int iconHeight;
    protected final List<ToolBarItem> orderedItems = new ArrayList<ToolBarItem>();
    protected final Map<ToolBarComponent, ToolBarItem> toolBarComponentMap = new HashMap<ToolBarComponent, ToolBarItem>();
    protected final Map<CyAction, ToolBarItem> actionMap = new HashMap<CyAction, ToolBarItem>();
    protected JButton overflowButton;
    protected final JPopupMenu overflowPopup;
    protected final JToolBar overflowToolBar;
    private long lastTimeOverflowPopupClosed;
    private boolean isAdjusting;
    private AWTEventListener awtEventListener;
    private ComponentAdapter componentAdapter;
    protected final CyServiceRegistrar serviceRegistrar;

    public CyToolBar(String name, int orientation, CyServiceRegistrar serviceRegistrar) {
        this(name, orientation, DEF_ICON_WIDTH, DEF_ICON_HEIGHT, serviceRegistrar);
    }

    public CyToolBar(String name, int orientation, int iconWidth, int iconHeight, CyServiceRegistrar serviceRegistrar) {
        super(name);
        this.iconWidth = iconWidth;
        this.iconHeight = iconHeight;
        this.serviceRegistrar = serviceRegistrar;
        this.setFloatable(false);
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, UIManager.getColor("Separator.foreground")), BorderFactory.createEmptyBorder(0, 10, 0, 10)));
        this.overflowPopup = new JPopupMenu();
        this.overflowPopup.setBorderPainted(false);
        this.overflowPopup.setBorder(BorderFactory.createEmptyBorder());
        this.overflowPopup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
                CyToolBar.this.lastTimeOverflowPopupClosed = System.currentTimeMillis();
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent evt) {
            }
        });
        this.setupOverflowButton();
        this.overflowToolBar = new JToolBar("overflowToolBar", this.getOrientation() == 0 ? 1 : 0);
        this.overflowToolBar.setFloatable(false);
        this.overflowToolBar.setBorder(BorderFactory.createLineBorder(UIManager.getColor("Separator.foreground"), 1));
    }

    public int getIconWidth() {
        return this.iconWidth;
    }

    public int getIconHeight() {
        return this.iconHeight;
    }

    @Override
    public void addSeparator() {
        Component previous;
        int n = this.getComponentCount();
        if (n > 1 && (previous = this.getComponent(n - 1)) instanceof JSeparator) {
            previous.setVisible(false);
        }
        super.addSeparator();
    }

    @Override
    public void removeAll() {
        super.removeAll();
        this.overflowToolBar.removeAll();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.addComponentListener(this.getComponentListener());
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this.componentAdapter != null) {
            this.removeComponentListener(this.componentAdapter);
        }
        if (this.awtEventListener != null) {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this.awtEventListener);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Component[] comps = this.getAllComponents();
        Insets insets = this.getInsets();
        int width = null == insets ? 0 : insets.left + insets.right;
        int height = null == insets ? 0 : insets.top + insets.bottom;
        for (int i = 0; i < comps.length; ++i) {
            Component c = comps[i];
            if (!c.isVisible()) continue;
            width += this.getOrientation() == 0 ? c.getPreferredSize().width : c.getPreferredSize().height;
            height = Math.max(height, this.getOrientation() == 0 ? c.getPreferredSize().height + (insets == null ? 0 : insets.top + insets.bottom) : c.getPreferredSize().width + (insets == null ? 0 : insets.left + insets.right));
        }
        if (this.overflowToolBar.getComponentCount() > 0) {
            width += this.getOrientation() == 0 ? this.overflowButton.getPreferredSize().width : this.overflowButton.getPreferredSize().height;
        }
        Dimension dim = this.getOrientation() == 0 ? new Dimension(width, height) : new Dimension(height, width);
        return dim;
    }

    @Override
    public void setOrientation(int o) {
        super.setOrientation(o);
        if (this.serviceRegistrar != null) {
            this.setupOverflowButton();
        }
    }

    @Override
    public void validate() {
        if (!this.isAdjusting) {
            LinkedList<Component> visibleComps = new LinkedList<Component>();
            int totalVisible = this.computeVisibleComponents(visibleComps);
            if (totalVisible == -1) {
                this.handleOverflowRemoval();
            } else {
                this.handleOverflowAddittion(visibleComps);
            }
        }
        super.validate();
    }

    public AbstractButton addAction(CyAction action) {
        if (this.actionMap.containsKey(action)) {
            return null;
        }
        boolean sepBefore = false;
        boolean sepAfter = false;
        if (action instanceof AbstractCyAction) {
            sepBefore = ((AbstractCyAction)action).insertToolbarSeparatorBefore();
            sepAfter = ((AbstractCyAction)action).insertToolbarSeparatorAfter();
        }
        float gravity = action.getToolbarGravity();
        AbstractButton button = CyToolBar.createToolBarButton(action, this.iconWidth, this.iconHeight);
        ToolBarItem item = new ToolBarItem(button, gravity, sepBefore, sepAfter);
        this.actionMap.put(action, item);
        int index = this.indexOf(gravity);
        this.orderedItems.add(index, item);
        this.update();
        return button;
    }

    public boolean removeAction(CyAction action) {
        ToolBarItem item = this.actionMap.remove(action);
        if (item == null) {
            return false;
        }
        this.orderedItems.remove(item);
        this.update();
        return true;
    }

    public void addToolBarComponent(ToolBarComponent tbc, Map<?, ?> props) {
        if (this.toolBarComponentMap.containsKey(tbc)) {
            return;
        }
        boolean sepBefore = "true".equals(props.get("insertSeparatorBefore"));
        boolean sepAfter = "true".equals(props.get("insertSeparatorAfter"));
        int index = this.indexOf(tbc.getToolBarGravity());
        ToolBarItem item = new ToolBarItem(tbc, sepBefore, sepAfter);
        this.toolBarComponentMap.put(tbc, item);
        this.orderedItems.add(index, item);
        this.update();
    }

    public boolean removeToolBarComponent(ToolBarComponent tbc) {
        ToolBarItem item = this.toolBarComponentMap.remove(tbc);
        if (item == null) {
            return false;
        }
        this.orderedItems.remove(item);
        this.update();
        return true;
    }

    public Component getComponent(CyAction action) {
        ToolBarItem item = this.actionMap.get(action);
        return item != null ? item.getComponent() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showAll() {
        this.isAdjusting = true;
        try {
            for (ToolBarItem item : this.orderedItems) {
                Component c = item.getComponent();
                if (c == null) continue;
                c.setVisible(true);
            }
        }
        finally {
            this.isAdjusting = false;
            this.validate();
        }
        this.updateSeparators(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hideAll() {
        this.isAdjusting = true;
        try {
            for (ToolBarItem item : this.orderedItems) {
                Component c = item.getComponent();
                if (c == null || !this.isOverflowAllowed(c)) continue;
                c.setVisible(false);
            }
        }
        finally {
            this.isAdjusting = false;
            this.validate();
        }
        this.updateSeparators(this);
    }

    public void addSeparator(float gravity) {
        int index = this.indexOf(gravity);
        this.orderedItems.add(index, new SeparatorToolBarItem(gravity));
    }

    public void addSpacer(float gravity) {
        int index = this.indexOf(gravity);
        this.orderedItems.add(index, new SpacerToolBarItem(gravity));
    }

    public Collection<CyAction> getAllToolBarActions() {
        return new LinkedHashSet<CyAction>(this.actionMap.keySet());
    }

    public Collection<ToolBarComponent> getAllToolBarComponents() {
        return new LinkedHashSet<ToolBarComponent>(this.toolBarComponentMap.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void update() {
        this.isAdjusting = true;
        try {
            this.removeAll();
            for (ToolBarItem item : this.orderedItems) {
                Component c = item.getComponent();
                if (c != null) {
                    this.add(this, c, item.isSeparatorBefore(), item.isSeparatorAfter());
                    continue;
                }
                if (item instanceof SeparatorToolBarItem) {
                    this.addSeparator();
                    continue;
                }
                if (!(item instanceof SpacerToolBarItem)) continue;
                this.addSpacer();
            }
            this.updateSeparators(this);
        }
        finally {
            this.isAdjusting = false;
            this.validate();
        }
    }

    protected void add(JToolBar toolBar, Component c, boolean sepBefore, boolean sepAfter) {
        if (sepBefore) {
            toolBar.addSeparator();
        }
        toolBar.add(c);
        if (sepAfter) {
            toolBar.addSeparator();
        }
    }

    private void addSpacer() {
        this.add(this.getOrientation() == 0 ? Box.createHorizontalGlue() : Box.createVerticalGlue());
    }

    protected int indexOf(float newGravity) {
        for (int i = 0; i < this.orderedItems.size(); ++i) {
            ToolBarItem item = this.orderedItems.get(i);
            float gravity = item.getGravity();
            if (!(gravity >= 0.0f) || !(newGravity < gravity)) continue;
            return i;
        }
        return this.orderedItems.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateSeparators(JToolBar toolBar) {
        if (toolBar == this) {
            this.isAdjusting = true;
        }
        boolean lastIsSep = true;
        boolean changed = false;
        try {
            for (Component c : toolBar.getComponents()) {
                if (c instanceof JSeparator) {
                    boolean oldVisible = c.isVisible();
                    c.setVisible(!lastIsSep);
                    if (oldVisible != c.isVisible()) {
                        changed = true;
                    }
                }
                if (!c.isVisible()) continue;
                lastIsSep = c instanceof JSeparator;
            }
        }
        finally {
            if (toolBar == this) {
                this.isAdjusting = false;
                if (changed) {
                    toolBar.validate();
                }
            }
        }
    }

    private ComponentListener getComponentListener() {
        if (this.componentAdapter == null) {
            this.componentAdapter = new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent evt) {
                    CyToolBar.this.maybeAddOverflow();
                    if (CyToolBar.this.overflowPopup != null && CyToolBar.this.overflowPopup.isShowing()) {
                        CyToolBar.this.overflowPopup.setVisible(false);
                    }
                }
            };
        }
        return this.componentAdapter;
    }

    private void setupOverflowButton() {
        if (this.overflowPopup != null && this.overflowPopup.isShowing()) {
            this.overflowPopup.setVisible(false);
        }
        IconManager iconManager = (IconManager)this.serviceRegistrar.getService(IconManager.class);
        String iconText = this.getOrientation() == 0 ? "\uf103" : "\uf101";
        TextIcon icon = new TextIcon(iconText, iconManager.getIconFont(16.0f), 24, 24);
        this.overflowButton = new JButton((Icon)icon);
        this.overflowButton.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
        this.overflowButton.setFocusable(false);
        this.overflowButton.setFocusPainted(false);
        this.overflowButton.setContentAreaFilled(false);
        this.overflowButton.addActionListener(evt -> {
            if (System.currentTimeMillis() - this.lastTimeOverflowPopupClosed > 250L) {
                this.displayOverflow();
            }
        });
    }

    private void displayOverflow() {
        if (!this.overflowButton.isShowing()) {
            return;
        }
        if (this.overflowPopup.isVisible()) {
            int x = this.getOrientation() == 0 ? this.overflowButton.getLocationOnScreen().x : this.overflowButton.getLocationOnScreen().x + this.overflowButton.getWidth();
            int y = this.getOrientation() == 0 ? this.overflowButton.getLocationOnScreen().y + this.overflowButton.getHeight() : this.overflowButton.getLocationOnScreen().y;
            this.overflowPopup.setLocation(x, y);
        } else {
            int x = this.getOrientation() == 0 ? 0 : this.overflowButton.getWidth();
            int y = this.getOrientation() == 0 ? this.overflowButton.getHeight() : 0;
            this.overflowPopup.show(this.overflowButton, x, y);
        }
    }

    private void maybeAddOverflow() {
        this.validate();
        this.repaint();
    }

    private int computeVisibleComponents(LinkedList<Component> visibleComps) {
        this.updateSeparators(this);
        if (this.isShowing()) {
            int w = this.getOrientation() == 0 ? this.overflowButton.getIcon().getIconWidth() + 4 : this.getWidth() - this.getInsets().left - this.getInsets().right;
            int h = this.getOrientation() == 0 ? this.getHeight() - this.getInsets().top - this.getInsets().bottom : this.overflowButton.getIcon().getIconHeight() + 4;
            this.overflowButton.setMaximumSize(new Dimension(w, h));
            this.overflowButton.setMinimumSize(new Dimension(w, h));
            this.overflowButton.setPreferredSize(new Dimension(w, h));
        }
        Component[] comps = this.getAllComponents();
        int sizeSoFar = 0;
        int maxSize = this.getOrientation() == 0 ? this.getWidth() : this.getHeight();
        int overflowButtonSize = this.getOrientation() == 0 ? this.overflowButton.getPreferredSize().width : this.overflowButton.getPreferredSize().height;
        int totalShowing = 0;
        int totalVisible = 0;
        Insets insets = this.getInsets();
        if (insets != null) {
            sizeSoFar = this.getOrientation() == 0 ? insets.left + insets.right : insets.top + insets.bottom;
        }
        for (Component c : comps) {
            int size;
            if (!c.isVisible()) continue;
            Dimension compSize = c.getPreferredSize();
            int n = size = this.getOrientation() == 0 ? compSize.width : compSize.height;
            if (!this.isOverflowAllowed(c) || totalShowing == totalVisible && sizeSoFar + size <= maxSize) {
                visibleComps.add(c);
                ++totalVisible;
                sizeSoFar += size;
            }
            ++totalShowing;
        }
        if (totalVisible < totalShowing) {
            Iterator<Component> iter = visibleComps.descendingIterator();
            while (iter.hasNext() && totalVisible > 0 && sizeSoFar + overflowButtonSize > maxSize) {
                Component c = iter.next();
                if (!this.isOverflowAllowed(c)) continue;
                Dimension compSize = c.getPreferredSize();
                int size = this.getOrientation() == 0 ? compSize.width : compSize.height;
                sizeSoFar -= size;
                iter.remove();
                --totalVisible;
            }
        }
        if (totalVisible == totalShowing) {
            totalVisible = -1;
        }
        return totalVisible;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleOverflowAddittion(List<Component> visibleComps) {
        this.isAdjusting = true;
        try {
            this.removeAll();
            this.overflowToolBar.setOrientation(this.getOrientation() == 0 ? 1 : 0);
            this.overflowPopup.removeAll();
            for (ToolBarItem item : this.orderedItems) {
                if (item instanceof SpacerToolBarItem) continue;
                if (item instanceof SeparatorToolBarItem) {
                    this.addSeparator();
                    continue;
                }
                Component c = item.getComponent();
                if (c == null) continue;
                if (!c.isVisible() || visibleComps.contains(c)) {
                    this.add(this, c, item.isSeparatorBefore(), item.isSeparatorAfter());
                    continue;
                }
                this.add(this.overflowToolBar, c, item.isSeparatorBefore(), item.isSeparatorAfter());
            }
            this.overflowPopup.add(this.overflowToolBar);
            this.add(this.overflowButton);
            this.validate();
            this.updateSeparators(this.overflowToolBar);
        }
        finally {
            this.isAdjusting = false;
        }
    }

    private void handleOverflowRemoval() {
        Component[] comps = this.overflowToolBar.getComponents();
        if (comps.length > 0) {
            this.remove(this.overflowButton);
            this.overflowToolBar.removeAll();
            this.overflowPopup.removeAll();
            this.update();
        }
    }

    private Component[] getAllComponents() {
        Component[] toolbarComps;
        Component[] overflowComps = this.overflowToolBar.getComponents();
        if (overflowComps.length == 0) {
            toolbarComps = this.getComponents();
        } else if (this.getComponentCount() > 0) {
            toolbarComps = new Component[this.getComponents().length - 1];
            System.arraycopy(this.getComponents(), 0, toolbarComps, 0, toolbarComps.length);
        } else {
            toolbarComps = new Component[]{};
        }
        Component[] comps = new Component[toolbarComps.length + overflowComps.length];
        System.arraycopy(toolbarComps, 0, comps, 0, toolbarComps.length);
        System.arraycopy(overflowComps, 0, comps, toolbarComps.length, overflowComps.length);
        return comps;
    }

    private boolean isOverflowAllowed(Component comp) {
        return comp instanceof AbstractButton || comp instanceof JSeparator;
    }

    public static AbstractButton createToolBarButton(final CyAction action, int iconWidth, int iconHeight) {
        AbstractButton button;
        action.updateEnableState();
        if (action.useToggleButton()) {
            final BasicStroke selectedStroke = new BasicStroke(1.0f);
            button = new JToggleButton((Action)action){

                @Override
                public JToolTip createToolTip() {
                    return CyToolBar.createToolTip(this, action);
                }

                @Override
                public void paint(Graphics g) {
                    if (this.isSelected()) {
                        Graphics2D g2 = (Graphics2D)g.create();
                        g2.setColor(UIManager.getColor("CyToggleButton[Selected].background"));
                        g2.fillRect(BUTTON_BORDER_SIZE, BUTTON_BORDER_SIZE, this.getWidth() - 2 * BUTTON_BORDER_SIZE, this.getHeight() - 2 * BUTTON_BORDER_SIZE);
                        g2.setStroke(selectedStroke);
                        g2.setColor(UIManager.getColor("CyToggleButton[Selected].borderColor"));
                        g2.drawRect(BUTTON_BORDER_SIZE, BUTTON_BORDER_SIZE, this.getWidth() - 2 * BUTTON_BORDER_SIZE, this.getHeight() - 2 * BUTTON_BORDER_SIZE);
                        g2.dispose();
                    }
                    super.paint(g);
                }
            };
        } else {
            button = new JButton((Action)action){

                @Override
                public JToolTip createToolTip() {
                    return CyToolBar.createToolTip(this, action);
                }
            };
        }
        button.setText(action.getName());
        button.setBorder(BorderFactory.createEmptyBorder(BUTTON_BORDER_SIZE, BUTTON_BORDER_SIZE, BUTTON_BORDER_SIZE, BUTTON_BORDER_SIZE));
        button.setRolloverEnabled(LookAndFeelUtil.isWinLAF());
        button.setFocusable(false);
        button.setFocusPainted(false);
        button.setContentAreaFilled(false);
        button.setHideActionText(true);
        Dimension dim = new Dimension(iconWidth + 2 * BUTTON_BORDER_SIZE, iconHeight + 2 * BUTTON_BORDER_SIZE);
        button.setMinimumSize(dim);
        button.setPreferredSize(dim);
        button.setMaximumSize(dim);
        button.setSize(dim);
        Object iconObj = action.getValue("SwingLargeIconKey");
        if (iconObj instanceof Icon) {
            Icon icon = (Icon)iconObj;
            if (icon.getIconWidth() > iconWidth || icon.getIconHeight() > iconHeight) {
                icon = IconManager.resizeIcon((Icon)icon, (int)Math.min(iconWidth, iconHeight));
                button.setIcon(icon);
            }
            if (icon instanceof ImageIcon) {
                Image img = ((ImageIcon)icon).getImage();
                GrayFilter filter = new GrayFilter(true, 71);
                FilteredImageSource prod = new FilteredImageSource(img.getSource(), filter);
                Image grayImage = Toolkit.getDefaultToolkit().createImage(prod);
                button.setDisabledIcon(new ImageIcon(grayImage));
            }
        }
        return button;
    }

    private static JToolTip createToolTip(JComponent comp, CyAction action) {
        return new CyToolTip(comp, (String)action.getValue("ShortDescription"), (String)action.getValue("LongDescription"), (Icon)(action.getToolTipImage() == null ? null : new ImageIcon(action.getToolTipImage())));
    }

    protected static class ToolBarItem {
        private final ToolBarComponent toolBarComponent;
        private final Component component;
        private final boolean separatorBefore;
        private final boolean separatorAfter;
        private float gravity = -1.0f;

        public ToolBarItem(Component comp, float gravity, boolean separatorBefore, boolean separatorAfter) {
            this.toolBarComponent = null;
            this.component = comp;
            this.gravity = gravity;
            this.separatorBefore = separatorBefore;
            this.separatorAfter = separatorAfter;
        }

        public ToolBarItem(ToolBarComponent toolBarComponent, boolean separatorBefore, boolean separatorAfter) {
            this.toolBarComponent = toolBarComponent;
            this.component = null;
            this.separatorBefore = separatorBefore;
            this.separatorAfter = separatorAfter;
        }

        public ToolBarComponent getToolBarComponent() {
            return this.toolBarComponent;
        }

        public Component getComponent() {
            return this.toolBarComponent != null ? this.toolBarComponent.getComponent() : this.component;
        }

        public float getGravity() {
            return this.toolBarComponent != null ? this.toolBarComponent.getToolBarGravity() : this.gravity;
        }

        public boolean isSeparatorBefore() {
            return this.separatorBefore;
        }

        public boolean isSeparatorAfter() {
            return this.separatorAfter;
        }
    }

    protected static final class SeparatorToolBarItem
    extends ToolBarItem {
        public SeparatorToolBarItem(float gravity) {
            super(null, gravity, false, false);
        }
    }

    protected static final class SpacerToolBarItem
    extends ToolBarItem {
        public SpacerToolBarItem(float gravity) {
            super(null, gravity, false, false);
        }
    }
}

