/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal.view.help;

import com.kitfox.svg.SVGDiagram;
import com.kitfox.svg.SVGUniverse;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.BufferedInputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URL;
import java.util.Scanner;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import org.cytoscape.application.CyVersion;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.util.swing.OpenBrowser;

public class AboutDialog
extends JDialog {
    private final CyServiceRegistrar serviceRegistrar;

    public AboutDialog(CyServiceRegistrar serviceRegistrar) {
        super((Window)((CySwingApplication)serviceRegistrar.getService(CySwingApplication.class)).getJFrame(), "About Cytoscape", Dialog.ModalityType.APPLICATION_MODAL);
        this.serviceRegistrar = serviceRegistrar;
        this.init();
    }

    public void init() {
        this.setResizable(false);
        AboutPanel panel = new AboutPanel();
        JButton closeButton = new JButton(new AbstractAction("Close"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AboutDialog.this.dispose();
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(panel, -2, -1, -2).addComponent(closeButton, GroupLayout.Alignment.TRAILING));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(panel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(closeButton).addContainerGap());
        LookAndFeelUtil.setDefaultOkCancelKeyStrokes((JRootPane)this.getRootPane(), (Action)closeButton.getAction(), (Action)closeButton.getAction());
        this.getRootPane().setDefaultButton(closeButton);
    }

    private class AboutPanel
    extends JPanel {
        private static final String CYTOSCAPE_DEVELOPERS_URL = "https://cytoscape.org/development_team.html";
        private static final String CYTOSCAPE_URL = "https://cytoscape.org/";
        private static final String LEFT = "left";
        private static final String CENTER = "center";
        private JLabel aboutLabel;
        private JTextPane aboutPane;
        private JTextPane infoPane;

        public AboutPanel() {
            JScrollPane scrollPane1 = new JScrollPane(this.getAboutPane());
            scrollPane1.setBorder(BorderFactory.createEmptyBorder());
            JScrollPane scrollPane2 = new JScrollPane(this.getInfoPane());
            scrollPane2.setBorder(BorderFactory.createMatteBorder(1, 0, 1, 0, UIManager.getColor("Separator.foreground")));
            int w = this.getAboutLabel().getPreferredSize().width;
            GroupLayout layout = new GroupLayout(this);
            this.setLayout(layout);
            layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.getAboutLabel()).addComponent(scrollPane1, w, w, w).addComponent(scrollPane2, w, w, w));
            layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.getAboutLabel()).addGap(20).addComponent(scrollPane1, 90, 90, 90).addGap(20).addComponent(scrollPane2, 60, 60, 60).addGap(5));
        }

        private JLabel getAboutLabel() {
            if (this.aboutLabel == null) {
                try (Scanner scan = new Scanner(new BufferedInputStream(this.getClass().getResourceAsStream("/images/about.svg")));){
                    StringBuilder sb = new StringBuilder();
                    while (scan.hasNextLine()) {
                        sb.append(scan.nextLine());
                        sb.append("\n");
                    }
                    SVGUniverse universe = new SVGUniverse();
                    StringReader is = new StringReader(sb.toString());
                    URI uri = universe.loadSVG((Reader)is, "about");
                    final SVGDiagram diagram = universe.getDiagram(uri);
                    diagram.setIgnoringClipHeuristic(true);
                    Icon icon = new Icon(){

                        @Override
                        public void paintIcon(Component c, Graphics g, int x, int y) {
                            Graphics2D g2 = (Graphics2D)g.create();
                            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                            g2.translate(x, y);
                            try {
                                diagram.render(g2);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            g2.dispose();
                        }

                        @Override
                        public int getIconWidth() {
                            return (int)diagram.getWidth();
                        }

                        @Override
                        public int getIconHeight() {
                            return (int)diagram.getHeight();
                        }
                    };
                    this.aboutLabel = new JLabel(icon);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return this.aboutLabel;
        }

        private JTextPane getAboutPane() {
            if (this.aboutPane == null) {
                this.aboutPane = this.createTextPane(String.format("Cytoscape is an open source software platform for visualizing complex networks and integrating these with any type of attribute data.<br><br>For more information about Cytoscape please visit <a href='%s'>cytoscape.org</a>.<br><br> Information on our supporters and development team is available <a href='%s'>here</a>", CYTOSCAPE_URL, CYTOSCAPE_DEVELOPERS_URL), LEFT);
                this.aboutPane.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
            }
            return this.aboutPane;
        }

        private JTextPane getInfoPane() {
            if (this.infoPane == null) {
                this.infoPane = this.createTextPane(String.format("<b>Version:</b> %s<br> <b>Java:</b> %s<br><b>Java Home:</b> %s<br><b>OS:</b> %s", this.getProductVersion(), this.getJavaValue(), this.getJavaHomeValue(), this.getOperatingSystemValue()), LEFT);
                this.infoPane.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
                this.infoPane.setBackground(UIManager.getColor("Table.background"));
                this.infoPane.setForeground(UIManager.getColor("Label.disabledForeground"));
            }
            return this.infoPane;
        }

        private JTextPane createTextPane(String text, String textAlign) {
            JTextPane pane = new JTextPane();
            pane.setBackground(this.getBackground());
            pane.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
            pane.setEditable(false);
            pane.setContentType("text/html");
            pane.setText("<div style='font-family: Helvetica, Arial, sans-serif; font-size: " + LookAndFeelUtil.getSmallFontSize() + "; text-align: " + textAlign + ";'>" + text + "</div>");
            pane.setCaretPosition(0);
            pane.addHyperlinkListener(evt -> {
                if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    this.openURL(evt.getURL());
                }
            });
            return pane;
        }

        private void openURL(URL url) {
            if (url != null) {
                ((OpenBrowser)AboutDialog.this.serviceRegistrar.getService(OpenBrowser.class)).openURL(url.toExternalForm());
            }
        }

        public String getProductVersion() {
            return ((CyVersion)AboutDialog.this.serviceRegistrar.getService(CyVersion.class)).getVersion();
        }

        public String getJavaValue() {
            return System.getProperty("java.version", "unknown") + " by " + System.getProperty("java.vendor", "unknown");
        }

        public String getJavaHomeValue() {
            return System.getProperty("java.home", "unknown");
        }

        public String getOperatingSystemValue() {
            return System.getProperty("os.name", "unknown") + " " + System.getProperty("os.version", "") + " - " + System.getProperty("os.arch", "");
        }
    }
}

