/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal.view;

import java.awt.Dimension;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import org.cytoscape.internal.view.AbstractNetworkPanel;
import org.cytoscape.internal.view.AbstractNetworkPanelModel;
import org.cytoscape.internal.view.SubNetworkPanelModel;
import org.cytoscape.internal.view.util.ViewUtil;
import org.cytoscape.model.subnetwork.CySubNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.util.swing.LookAndFeelUtil;

public class SubNetworkPanel
extends AbstractNetworkPanel<CySubNetwork> {
    private static int INDENT_WIDTH = 20;
    private JLabel currentLabel;
    private JLabel indentLabel;
    private JLabel viewCountLabel;
    private JLabel viewIconLabel;
    private JLabel nodeCountLabel;
    private JLabel edgeCountLabel;
    private int depth;
    private boolean showIndentation;

    public SubNetworkPanel(SubNetworkPanelModel model, boolean showIndentation, CyServiceRegistrar serviceRegistrar) {
        super(model, serviceRegistrar);
        if (showIndentation != this.showIndentation) {
            this.setShowIndentation(showIndentation);
        }
    }

    @Override
    public void setModel(AbstractNetworkPanelModel<CySubNetwork> model) {
        if (model != null) {
            model.addPropertyChangeListener("viewCount", evt -> this.updateViewInfo());
            model.addPropertyChangeListener("current", evt -> this.updateCurrentLabel());
        }
        super.setModel(model);
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int newValue) {
        if (newValue != this.depth) {
            int oldValue = this.depth;
            this.depth = newValue;
            this.updateIndentation();
            this.firePropertyChange("depth", oldValue, newValue);
        }
    }

    public boolean isDescendantOf(CySubNetwork parentNet) {
        CySubNetwork net = (CySubNetwork)this.getModel().getNetwork();
        while (net != null) {
            if (!parentNet.equals(net = ViewUtil.getParent(net, this.serviceRegistrar))) continue;
            return true;
        }
        return false;
    }

    public void setShowIndentation(boolean newValue) {
        if (newValue != this.showIndentation) {
            boolean oldValue = this.showIndentation;
            this.showIndentation = newValue;
            this.updateIndentation();
            this.firePropertyChange("showIndentation", oldValue, newValue);
        }
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension size = this.getPreferredSize();
        size.width = Short.MAX_VALUE;
        return size;
    }

    @Override
    public void update() {
        super.update();
        this.updateCurrentLabel();
        this.updateViewInfo();
        this.updateIndentation();
        this.updateCountLabels();
        this.repaint();
    }

    private void updateViewInfo() {
        int viewCount = this.getModel().getViewCount();
        String viewCountText = " ";
        if (viewCount > 9) {
            viewCountText = "\u208a";
        } else if (viewCount > 1) {
            viewCountText = Character.toString((char)(8320 + viewCount));
        }
        this.getViewCountLabel().setText(viewCountText);
        this.updateViewIconLabel();
        this.repaint();
    }

    private void updateViewIconLabel() {
        int viewCount = this.getModel().getViewCount();
        this.getViewIconLabel().setText(viewCount == 0 ? "\uf1e0" : "\uf1e1");
        this.getViewIconLabel().setForeground(UIManager.getColor(viewCount == 0 ? "Label.disabledForeground" : "Label.foreground"));
        this.getViewIconLabel().setToolTipText((Serializable)(viewCount > 0 ? Integer.valueOf(viewCount) : "No") + " view" + (viewCount == 1 ? "" : "s"));
    }

    protected void updateCurrentLabel() {
        this.getCurrentLabel().setText(this.getModel().isCurrent() ? "\uf111" : " ");
        this.getCurrentLabel().setToolTipText(this.getModel().isCurrent() ? "Current Network" : null);
    }

    protected void updateIndentation() {
        int indent = this.showIndentation ? this.depth * INDENT_WIDTH : 0;
        Dimension d = new Dimension(indent, this.getIndentLabel().getPreferredSize().height);
        this.getIndentLabel().setPreferredSize(d);
        this.getIndentLabel().setMinimumSize(d);
        this.getIndentLabel().setMaximumSize(d);
        this.getIndentLabel().setSize(d);
        this.revalidate();
    }

    protected void updateCountLabels() {
        this.getNodeCountLabel().setText("" + this.getModel().getNodeCount());
        this.getEdgeCountLabel().setText("" + this.getModel().getEdgeCount());
    }

    @Override
    protected void init() {
        this.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateContainerGaps(false);
        layout.setAutoCreateGaps(false);
        int CURR_LABEL_W = this.getCurrentLabel().getWidth();
        layout.setHorizontalGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.getCurrentLabel(), CURR_LABEL_W, CURR_LABEL_W, CURR_LABEL_W).addComponent(this.getIndentLabel(), -2, -1, -2).addGap(32 - CURR_LABEL_W - this.getViewCountLabel().getPreferredSize().width).addComponent(this.getViewCountLabel(), -2, -1, -2).addComponent(this.getViewIconLabel(), -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.getNameLabel()).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGap(0, 0, Short.MAX_VALUE).addComponent(this.getNodeCountLabel(), -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.getEdgeCountLabel(), -2, -1, -2).addContainerGap());
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, true).addComponent(this.getCurrentLabel(), -2, -1, -2).addComponent(this.getIndentLabel(), -2, -1, -2).addComponent(this.getViewCountLabel(), -2, -1, -2).addComponent(this.getViewIconLabel(), -2, -1, -2).addComponent(this.getNameLabel(), -2, -1, -2).addComponent(this.getNodeCountLabel(), -2, -1, -2).addComponent(this.getEdgeCountLabel(), -2, -1, -2));
    }

    protected JLabel getCurrentLabel() {
        if (this.currentLabel == null) {
            this.currentLabel = new JLabel("\uf111");
            this.currentLabel.setFont(((IconManager)this.serviceRegistrar.getService(IconManager.class)).getIconFont(10.0f));
            this.currentLabel.setMinimumSize(this.currentLabel.getPreferredSize());
            this.currentLabel.setMaximumSize(this.currentLabel.getPreferredSize());
            this.currentLabel.setSize(this.currentLabel.getPreferredSize());
            this.currentLabel.setForeground(UIManager.getColor("Focus.color"));
        }
        return this.currentLabel;
    }

    protected JLabel getIndentLabel() {
        if (this.indentLabel == null) {
            this.indentLabel = new JLabel(" ");
        }
        return this.indentLabel;
    }

    protected JLabel getViewCountLabel() {
        if (this.viewCountLabel == null) {
            this.viewCountLabel = new JLabel("\u2089");
            this.viewCountLabel.setFont(this.viewCountLabel.getFont().deriveFont(16.0f));
            this.viewCountLabel.setHorizontalAlignment(4);
            Dimension d = new Dimension(this.viewCountLabel.getPreferredSize().width, this.getViewIconLabel().getPreferredSize().height);
            this.viewCountLabel.setMinimumSize(d);
            this.viewCountLabel.setPreferredSize(d);
            this.viewCountLabel.setMaximumSize(d);
            this.viewCountLabel.setSize(d);
        }
        return this.viewCountLabel;
    }

    protected JLabel getViewIconLabel() {
        if (this.viewIconLabel == null) {
            IconManager iconManager = (IconManager)this.serviceRegistrar.getService(IconManager.class);
            this.viewIconLabel = new JLabel("\uf1e1");
            this.viewIconLabel.setFont(iconManager.getIconFont(16.0f));
        }
        return this.viewIconLabel;
    }

    protected JLabel getNodeCountLabel() {
        if (this.nodeCountLabel == null) {
            this.nodeCountLabel = new JLabel();
            this.nodeCountLabel.setToolTipText("Nodes");
            this.nodeCountLabel.setFont(this.nodeCountLabel.getFont().deriveFont(LookAndFeelUtil.getSmallFontSize()));
            this.nodeCountLabel.setHorizontalAlignment(4);
            this.nodeCountLabel.setForeground(UIManager.getColor("Label.infoForeground"));
        }
        return this.nodeCountLabel;
    }

    protected JLabel getEdgeCountLabel() {
        if (this.edgeCountLabel == null) {
            this.edgeCountLabel = new JLabel();
            this.edgeCountLabel.setToolTipText("Edges");
            this.edgeCountLabel.setFont(this.edgeCountLabel.getFont().deriveFont(LookAndFeelUtil.getSmallFontSize()));
            this.edgeCountLabel.setHorizontalAlignment(4);
            this.edgeCountLabel.setForeground(UIManager.getColor("Label.infoForeground"));
        }
        return this.edgeCountLabel;
    }
}

