/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal.view;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.cytoscape.application.CyApplicationConfiguration;
import org.cytoscape.internal.view.CytoPanelUtil;
import org.cytoscape.internal.view.util.SVGIcon;
import org.cytoscape.io.util.RecentlyOpenedTracker;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.CyTableManager;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.read.OpenSessionTaskFactory;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.util.swing.OpenBrowser;
import org.cytoscape.work.FinishStatus;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskObserver;
import org.cytoscape.work.swing.DialogTaskManager;
import org.jdesktop.swingx.color.ColorUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StarterPanel
extends JPanel {
    public static String NAME = "__STARTER_PANEL__";
    public static final String PY4CYTOSCAPE_URL = "https://py4cytoscape.readthedocs.io/en/latest/";
    public static final String RCY3_URL = "https://bioconductor.org/packages/release/bioc/html/RCy3.html";
    public static final String TUTORIAL_URL = "https://tutorials.cytoscape.org";
    public static final String NEWS_URL = "https://www.ncbi.nlm.nih.gov/pmc/?term=(cytoscape+AND+network)&report=imagesdocsum&dispmax=100";
    private final Color BG_COLOR = UIManager.getColor("Table.background");
    private final Color CONTRAST_COLOR = UIManager.getColor("Panel.background");
    private static final int PANEL_PAD = 4;
    private static final String SAMPLE_DATA_DIR = "sampleData/sessions";
    private static final String SESSION_EXT = ".cys";
    private static final int MAX_FILES = 100;
    private static final String MISSING_IMAGE = "/images/logo-light-96.png";
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private JPanel contentPane;
    private SessionListPanel recentSessionsPanel;
    private SessionListPanel sampleSessionsPanel;
    private JPanel titlePanel;
    private JPanel linksPanel;
    private JButton closeButton;
    private JLabel py4cytoscapeLabel = this.createLinkLabel("py4cytoscape", "/images/python-logo.svg", "https://py4cytoscape.readthedocs.io/en/latest/");
    private JLabel rcy3Label = this.createLinkLabel("RCy3", "/images/r-logo.svg", "https://bioconductor.org/packages/release/bioc/html/RCy3.html");
    private JLabel tutorialsLabel = this.createLinkLabel("Tutorials", null, "https://tutorials.cytoscape.org");
    private JLabel newsLabel = this.createLinkLabel("Published Figures", null, "https://www.ncbi.nlm.nih.gov/pmc/?term=(cytoscape+AND+network)&report=imagesdocsum&dispmax=100");
    private final Icon missingImageIcon;
    private boolean sessionMayBeLoading;
    private boolean sessionLoading;
    private final CyServiceRegistrar serviceRegistrar;

    public StarterPanel(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
        this.missingImageIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource(MISSING_IMAGE)));
        this.setName(NAME);
        this.init();
    }

    public void setSessionLoading(boolean b) {
        this.sessionLoading = b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            int w = 8 + Math.max(this.getRecentSessionsPanel().getPreferredSize().width, this.getSampleSessionsPanel().getPreferredSize().width);
            int h = 8 + this.getTitlePanel().getPreferredSize().height + this.getRecentSessionsPanel().getPreferredSize().height + this.getSampleSessionsPanel().getPreferredSize().height + this.getLinksPanel().getPreferredSize().height;
            return new Dimension(w, h);
        }
    }

    public void update() {
        List<FileInfo> recentFiles = this.getRecentFiles();
        this.getRecentSessionsPanel().update(recentFiles);
        this.getRecentSessionsPanel().setVisible(!recentFiles.isEmpty());
        this.getSampleSessionsPanel().update(this.getSampleFiles());
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getTitlePanel(), "North");
        this.add((Component)this.getContentPane(), "Center");
        this.add((Component)this.getLinksPanel(), "South");
    }

    public JPanel getContentPane() {
        if (this.contentPane == null) {
            this.contentPane = new JPanel();
            GroupLayout layout = new GroupLayout(this.contentPane);
            this.contentPane.setLayout(layout);
            layout.setAutoCreateContainerGaps(false);
            layout.setAutoCreateGaps(false);
            layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, true).addComponent(this.getRecentSessionsPanel(), -1, -1, Short.MAX_VALUE).addComponent(this.getSampleSessionsPanel(), -1, -1, Short.MAX_VALUE));
            layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.getRecentSessionsPanel(), -1, -1, Short.MAX_VALUE).addComponent(this.getSampleSessionsPanel(), -1, -1, Short.MAX_VALUE));
        }
        return this.contentPane;
    }

    private JPanel getTitlePanel() {
        if (this.titlePanel == null) {
            this.titlePanel = new JPanel();
            this.titlePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, UIManager.getColor("Separator.foreground")), BorderFactory.createEmptyBorder(3, 4, 3, 4)));
            JLabel titleLabel = new JLabel("Welcome to Cytoscape");
            titleLabel.setHorizontalAlignment(0);
            LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{titleLabel});
            GroupLayout layout = new GroupLayout(this.titlePanel);
            this.titlePanel.setLayout(layout);
            layout.setAutoCreateContainerGaps(false);
            layout.setAutoCreateGaps(true);
            layout.setHorizontalGroup(layout.createSequentialGroup().addGap(this.getCloseButton().getPreferredSize().width).addComponent(titleLabel, -1, -1, Short.MAX_VALUE).addComponent(this.getCloseButton(), -2, -1, -2));
            layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, true).addComponent(titleLabel, -2, -1, -2).addComponent(this.getCloseButton(), -2, -1, -2));
        }
        return this.titlePanel;
    }

    private SessionListPanel getRecentSessionsPanel() {
        if (this.recentSessionsPanel == null) {
            this.recentSessionsPanel = new SessionListPanel("Recent Sessions:");
            this.recentSessionsPanel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, this.BG_COLOR));
        }
        return this.recentSessionsPanel;
    }

    private SessionListPanel getSampleSessionsPanel() {
        if (this.sampleSessionsPanel == null) {
            this.sampleSessionsPanel = new SessionListPanel("Sample Sessions:");
            this.sampleSessionsPanel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, this.CONTRAST_COLOR));
        }
        return this.sampleSessionsPanel;
    }

    private JPanel getLinksPanel() {
        if (this.linksPanel == null) {
            this.linksPanel = new JPanel(){

                @Override
                protected void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    Graphics2D g2d = (Graphics2D)g;
                    g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                    int w = this.getWidth();
                    int h = this.getHeight();
                    Color color1 = StarterPanel.this.CONTRAST_COLOR;
                    Color color2 = StarterPanel.this.BG_COLOR;
                    GradientPaint gp = new GradientPaint(0.0f, 0.0f, color1, 0.0f, h * 4, color2);
                    g2d.setPaint(gp);
                    g2d.fillRect(0, 0, w, h);
                }
            };
            this.linksPanel.setOpaque(false);
            LookAndFeelUtil.equalizeSize((JComponent[])new JComponent[]{this.py4cytoscapeLabel, this.rcy3Label, this.tutorialsLabel, this.newsLabel});
            GroupLayout layout = new GroupLayout(this.linksPanel);
            this.linksPanel.setLayout(layout);
            layout.setAutoCreateContainerGaps(true);
            layout.setAutoCreateGaps(true);
            layout.setHorizontalGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.py4cytoscapeLabel, -2, -1, -2).addGap(10).addComponent(this.rcy3Label, -2, -1, -2).addGap(40).addComponent(this.tutorialsLabel, -2, -1, -2).addGap(10).addComponent(this.newsLabel, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE));
            layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, true).addComponent(this.py4cytoscapeLabel, -2, -1, -2).addComponent(this.rcy3Label, -2, -1, -2).addComponent(this.tutorialsLabel, -2, -1, -2).addComponent(this.newsLabel, -2, -1, -2));
        }
        return this.linksPanel;
    }

    JButton getCloseButton() {
        if (this.closeButton == null) {
            this.closeButton = new JButton("\uf00d");
            this.closeButton.setToolTipText("Hide Starter Panel");
            CytoPanelUtil.styleButton(this.closeButton);
            this.closeButton.setFont(((IconManager)this.serviceRegistrar.getService(IconManager.class)).getIconFont(13.0f));
        }
        return this.closeButton;
    }

    private JLabel createLinkLabel(final String text, String svgPath, final String url) {
        int hpad = 5;
        LeftSVGIcon icon = svgPath != null ? new LeftSVGIcon(this.getClass().getResourceAsStream(svgPath), 24, 24, hpad) : null;
        int vpad = icon == null ? 5 : 1;
        int bw = 1;
        final JLabel label = new JLabel(text, 0);
        label.setOpaque(true);
        label.setBackground(this.BG_COLOR);
        label.setForeground(UIManager.getColor("CyColor.complement(+1)"));
        label.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(this.BG_COLOR, bw), BorderFactory.createEmptyBorder(vpad, hpad, vpad, hpad)));
        if (icon != null) {
            int iconTextGap = 5;
            FontMetrics fm = label.getFontMetrics(label.getFont());
            int w = fm.stringWidth(text) + 2 * (icon.getIconWidth() + iconTextGap + hpad + bw);
            int h = icon.getIconHeight() + 2 * (vpad + bw);
            label.setPreferredSize(new Dimension(w, h));
            label.setHorizontalTextPosition(0);
            label.setIcon(icon);
        }
        label.setCursor(new Cursor(12));
        label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ((OpenBrowser)StarterPanel.this.serviceRegistrar.getService(OpenBrowser.class)).openURL(url);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                label.setText("<html><u>" + text + "</u></html>");
            }

            @Override
            public void mouseExited(MouseEvent e) {
                label.setText(text);
            }
        });
        return label;
    }

    private List<FileInfo> getRecentFiles() {
        ArrayList<FileInfo> files = new ArrayList<FileInfo>();
        RecentlyOpenedTracker fileTracker = (RecentlyOpenedTracker)this.serviceRegistrar.getService(RecentlyOpenedTracker.class);
        List recentFiles = fileTracker.getRecentlyOpenedURLs();
        int fileCount = Math.min(recentFiles.size(), 100);
        for (int i = 0; i < fileCount; ++i) {
            URL url = (URL)recentFiles.get(i);
            File file = null;
            try {
                URI uri = url.toURI();
                file = new File(uri);
            }
            catch (Exception e) {
                logger.error("Invalid file URL.", (Throwable)e);
                continue;
            }
            if (file.exists() && file.canRead()) {
                FileInfo fi = new FileInfo(file, file.getName(), file.getAbsolutePath());
                files.add(fi);
                continue;
            }
            fileCount = Math.min(recentFiles.size(), fileCount + 1);
        }
        return files;
    }

    private List<FileInfo> getSampleFiles() {
        File[] files;
        ArrayList<FileInfo> list = new ArrayList<FileInfo>();
        File dir = this.getExampleDir();
        if (dir != null && dir.exists() && dir.canRead() && (files = dir.listFiles()) != null) {
            for (File f : files) {
                if (!f.canRead() || !f.getName().toLowerCase().endsWith(SESSION_EXT)) continue;
                String toolTip = "<html>This (<b>" + f.getName() + "</b>) and other example files can be found in:<br />" + dir.getAbsolutePath() + "</html>";
                FileInfo fi = new FileInfo(f, f.getName().replace(SESSION_EXT, ""), toolTip);
                list.add(fi);
            }
        }
        return list;
    }

    private final File getExampleDir() {
        CyApplicationConfiguration applicationCfg = (CyApplicationConfiguration)this.serviceRegistrar.getService(CyApplicationConfiguration.class);
        if (applicationCfg != null) {
            return new File(applicationCfg.getInstallationDirectoryLocation() + "/sampleData/sessions/");
        }
        logger.error("application configuration is null, cannot find the installation directory");
        return null;
    }

    private void maybeOpenSession(File file) {
        this.sessionMayBeLoading = true;
        if (file.exists()) {
            this.maybeOpenSession(file, this.getTopLevelAncestor());
        } else {
            JOptionPane.showMessageDialog(this.getTopLevelAncestor(), "Session file not found:\n" + file.getAbsolutePath(), "File not Found", 2);
            RecentlyOpenedTracker fileTracker = (RecentlyOpenedTracker)this.serviceRegistrar.getService(RecentlyOpenedTracker.class);
            try {
                fileTracker.remove(file.toURI().toURL());
            }
            catch (Exception e) {
                logger.error("Error removing session file from RecentlyOpenedTracker.", (Throwable)e);
            }
            this.sessionMayBeLoading = false;
        }
    }

    private void maybeOpenSession(File file, Component owner) {
        if (file.exists() && file.canRead()) {
            CyNetworkManager netManager = (CyNetworkManager)this.serviceRegistrar.getService(CyNetworkManager.class);
            CyTableManager tableManager = (CyTableManager)this.serviceRegistrar.getService(CyTableManager.class);
            if (netManager.getNetworkSet().isEmpty() && tableManager.getAllTables(false).isEmpty()) {
                this.openSession(file);
            } else {
                this.openSessionWithWarning(file, owner);
            }
        } else {
            this.sessionMayBeLoading = false;
        }
    }

    private void openSessionWithWarning(File file, Component owner) {
        if (JOptionPane.showConfirmDialog(owner, "Current session (all networks and tables) will be lost.\nDo you want to continue?", "Open Session", 2) == 0) {
            this.openSession(file);
        } else {
            this.sessionMayBeLoading = false;
        }
    }

    private void openSession(File file) {
        OpenSessionTaskFactory taskFactory = (OpenSessionTaskFactory)this.serviceRegistrar.getService(OpenSessionTaskFactory.class);
        DialogTaskManager taskManager = (DialogTaskManager)this.serviceRegistrar.getService(DialogTaskManager.class);
        TaskObserver observer = new TaskObserver(){

            public void taskFinished(ObservableTask task) {
            }

            public void allFinished(FinishStatus finishStatus) {
                StarterPanel.this.sessionMayBeLoading = false;
            }
        };
        taskManager.execute(taskFactory.createTaskIterator(file), observer);
    }

    private class SessionListPanel
    extends JPanel {
        private JScrollPane scrollPane;
        private JLabel titleLabel;
        private ScrollableListPanel listPanel;
        private final String title;

        SessionListPanel(String title) {
            this.title = title;
            this.setOpaque(false);
            this.setLayout(new BorderLayout());
            this.add((Component)this.getTitleLabel(), "North");
            this.add((Component)this.getScrollPane(), "Center");
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            int w = this.getWidth();
            int h = this.getTitleLabel().getHeight();
            Color color1 = UIManager.getColor("Panel.background");
            Color color2 = StarterPanel.this.BG_COLOR;
            GradientPaint gp = new GradientPaint(0.0f, 0.0f, color2, 0.0f, h, color1);
            g2d.setPaint(gp);
            g2d.fillRect(0, 0, w, h);
        }

        void update(List<FileInfo> files) {
            ScrollableListPanel panel = this.getListPanel();
            panel.removeAll();
            for (FileInfo fi : files) {
                SessionPanel sessionPanel = new SessionPanel(fi);
                panel.add(sessionPanel);
            }
        }

        List<SessionPanel> getAllPanels() {
            ScrollableListPanel lp = this.getListPanel();
            int total = lp.getComponentCount();
            ArrayList<SessionPanel> list = new ArrayList<SessionPanel>(total);
            for (int i = 0; i < total; ++i) {
                list.add((SessionPanel)lp.getComponent(i));
            }
            return list;
        }

        JLabel getTitleLabel() {
            if (this.titleLabel == null) {
                this.titleLabel = new JLabel(this.title);
                this.titleLabel.setBorder(BorderFactory.createEmptyBorder(4, 10, 4, 10));
                LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{this.titleLabel});
            }
            return this.titleLabel;
        }

        JScrollPane getScrollPane() {
            if (this.scrollPane == null) {
                this.scrollPane = new JScrollPane(this.getListPanel());
                this.scrollPane.setVerticalScrollBarPolicy(20);
                this.scrollPane.setHorizontalScrollBarPolicy(31);
                this.scrollPane.setBackground(this.getListPanel().getBackground());
                this.scrollPane.getViewport().setBackground(this.getListPanel().getBackground());
                this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
                SessionPanel tmpSessionPanel = new SessionPanel(new FileInfo(new File("_tmp"), "TEMP", null));
                ScrollableListPanel tmpListPanel = new ScrollableListPanel();
                tmpListPanel.add(tmpSessionPanel);
                JScrollPane tmpScrollPane = new JScrollPane(tmpListPanel);
                int w = tmpListPanel.getPreferredSize().width + 2;
                tmpScrollPane.setHorizontalScrollBarPolicy(32);
                int h = tmpListPanel.getPreferredSize().height + tmpScrollPane.getHorizontalScrollBar().getHeight();
                this.scrollPane.setMinimumSize(new Dimension(w, h));
            }
            return this.scrollPane;
        }

        private ScrollableListPanel getListPanel() {
            if (this.listPanel == null) {
                this.listPanel = new ScrollableListPanel();
                this.listPanel.setBackground(StarterPanel.this.BG_COLOR);
            }
            return this.listPanel;
        }

        private class ScrollableListPanel
        extends JPanel
        implements Scrollable {
            public ScrollableListPanel() {
                this.setLayout(new ModifiedFlowLayout());
            }

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                return this.getPreferredSize();
            }

            @Override
            public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
                return 10;
            }

            @Override
            public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
                return (orientation == 1 ? visibleRect.height : visibleRect.width) - 10;
            }

            @Override
            public boolean getScrollableTracksViewportWidth() {
                return true;
            }

            @Override
            public boolean getScrollableTracksViewportHeight() {
                return false;
            }
        }
    }

    private class LeftSVGIcon
    extends SVGIcon {
        private int padding;

        public LeftSVGIcon(InputStream is, int width, int height, int padding) {
            super(is, width, height);
            this.padding = padding;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2d = (Graphics2D)g.create();
            Insets insets = StarterPanel.this.getInsets();
            int tx = (c.getWidth() - this.getIconWidth()) / 2 - insets.left - this.padding;
            g2d.translate(-tx, 0);
            super.paintIcon(c, g2d, x, y);
            g2d.dispose();
        }
    }

    private final class FileInfo {
        private final String THUMBNAIL_FILE = "/session_thumbnail.png";
        private final File file;
        private final String name;
        private final String help;
        private Icon icon;

        FileInfo(File file, String name, String help) {
            this.file = file;
            this.help = help;
            this.name = name;
        }

        final File getFile() {
            return this.file;
        }

        final String getName() {
            return this.name;
        }

        final String getHelp() {
            return this.help;
        }

        Icon getIcon() {
            if (this.icon == null) {
                Image thumbnail = this.loadThumbnail();
                this.icon = thumbnail != null ? new ImageIcon(thumbnail) : StarterPanel.this.missingImageIcon;
            }
            return this.icon;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Image loadThumbnail() {
            BufferedImage img = null;
            if (this.file != null && this.file.canRead()) {
                ZipFile zipFile = null;
                try {
                    zipFile = new ZipFile(this.file);
                    Enumeration<? extends ZipEntry> entries = zipFile.entries();
                    while (entries.hasMoreElements()) {
                        ZipEntry entry = entries.nextElement();
                        if (!entry.getName().endsWith("/session_thumbnail.png")) continue;
                        InputStream stream = zipFile.getInputStream(entry);
                        img = ImageIO.read(stream);
                        stream.close();
                        break;
                    }
                }
                catch (Exception e) {
                    logger.error("Cannot load session thumbnail from " + this.file.getName(), (Throwable)e);
                }
                finally {
                    if (zipFile != null) {
                        try {
                            zipFile.close();
                        }
                        catch (Exception ex) {
                            logger.error("Unable to close file " + this.file.getName(), (Throwable)ex);
                        }
                    }
                }
            }
            return img;
        }

        public int hashCode() {
            int prime = 17;
            int result = 7;
            result = prime * result + this.getOuterType().hashCode();
            result = prime * result + (this.file == null ? 0 : this.file.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FileInfo other = (FileInfo)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            return !(this.file == null ? other.file != null : !this.file.equals(other.file));
        }

        private StarterPanel getOuterType() {
            return StarterPanel.this;
        }
    }

    public class ModifiedFlowLayout
    extends FlowLayout {
        public ModifiedFlowLayout() {
        }

        public ModifiedFlowLayout(int align) {
            super(align);
        }

        public ModifiedFlowLayout(int align, int hgap, int vgap) {
            super(align, hgap, vgap);
        }

        @Override
        public Dimension minimumLayoutSize(Container target) {
            return this.computeMinSize(target);
        }

        @Override
        public Dimension preferredLayoutSize(Container target) {
            return this.computeSize(target);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Dimension computeSize(Container target) {
            Object object = target.getTreeLock();
            synchronized (object) {
                Insets insets;
                int hgap = this.getHgap();
                int vgap = this.getVgap();
                int w = target.getWidth();
                if (w == 0) {
                    w = Integer.MAX_VALUE;
                }
                if ((insets = target.getInsets()) == null) {
                    insets = new Insets(0, 0, 0, 0);
                }
                int reqdWidth = 0;
                int maxwidth = w - (insets.left + insets.right + hgap * 2);
                int n = target.getComponentCount();
                int x = 0;
                int y = insets.top + vgap;
                int rowHeight = 0;
                for (int i = 0; i < n; ++i) {
                    Component c = target.getComponent(i);
                    if (!c.isVisible()) continue;
                    Dimension d = c.getPreferredSize();
                    if (x == 0 || x + d.width <= maxwidth) {
                        if (x > 0) {
                            x += hgap;
                        }
                        x += d.width;
                        rowHeight = Math.max(rowHeight, d.height);
                    } else {
                        x = d.width;
                        y += vgap + rowHeight;
                        rowHeight = d.height;
                    }
                    reqdWidth = Math.max(reqdWidth, x);
                }
                y += rowHeight;
                return new Dimension(reqdWidth + insets.left + insets.right, y += insets.bottom);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Dimension computeMinSize(Container target) {
            Object object = target.getTreeLock();
            synchronized (object) {
                int minx = Integer.MAX_VALUE;
                int miny = Integer.MIN_VALUE;
                boolean found_one = false;
                int n = target.getComponentCount();
                for (int i = 0; i < n; ++i) {
                    Component c = target.getComponent(i);
                    if (!c.isVisible()) continue;
                    found_one = true;
                    Dimension d = c.getPreferredSize();
                    minx = Math.min(minx, d.width);
                    miny = Math.min(miny, d.height);
                }
                if (found_one) {
                    return new Dimension(minx, miny);
                }
                return new Dimension(0, 0);
            }
        }
    }

    private class SessionPanel
    extends JPanel {
        static final int BORDER_WIDTH = 1;
        static final int PAD = 5;
        static final int NAME_WIDTH = 128;
        final Color PANEL_COLOR;
        final Color BORDER_COLOR;
        final Color FOCUS_BORDER_COLOR;
        final Color FOCUS_OVERLAY_COLOR;
        private JLabel thumbnailLabel;
        private JLabel nameLabel;
        protected SessionPanel overItem;
        private final FileInfo fileInfo;

        SessionPanel(FileInfo fileInfo) {
            this.fileInfo = fileInfo;
            this.PANEL_COLOR = ColorUtil.setAlpha((Color)StarterPanel.this.CONTRAST_COLOR, (int)100);
            this.BORDER_COLOR = UIManager.getColor("Separator.foreground");
            this.FOCUS_BORDER_COLOR = UIManager.getColor("Focus.color");
            this.FOCUS_OVERLAY_COLOR = ColorUtil.setAlpha((Color)UIManager.getColor("Table.selectionBackground"), (int)55);
            this.init();
        }

        private void init() {
            this.setOpaque(false);
            this.setFocusable(true);
            int bw = 6;
            this.setBorder(BorderFactory.createEmptyBorder(bw, bw, bw, bw));
            GroupLayout layout = new GroupLayout(this);
            this.setLayout(layout);
            layout.setAutoCreateContainerGaps(false);
            layout.setAutoCreateGaps(true);
            layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, true).addComponent(this.getThumbnailLabel(), -2, -1, -2).addComponent(this.getNameLabel(), -1, -1, Short.MAX_VALUE));
            layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.getThumbnailLabel(), -1, -1, Short.MAX_VALUE).addComponent(this.getNameLabel(), -2, -1, -2));
            MouseAdapter mouseListener = new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (!StarterPanel.this.sessionMayBeLoading && !StarterPanel.this.sessionLoading && e.getClickCount() == 1 && SwingUtilities.isLeftMouseButton(e)) {
                        StarterPanel.this.maybeOpenSession(SessionPanel.this.fileInfo.getFile());
                    }
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    SessionPanel.this.requestFocusInWindow();
                    SessionPanel.this.overItem = SessionPanel.this;
                    SessionPanel.this.repaint();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    SessionPanel.this.overItem = null;
                    SessionPanel.this.repaint();
                }
            };
            this.addMouseListener(mouseListener);
            this.getThumbnailLabel().addMouseListener(mouseListener);
            this.getNameLabel().addMouseListener(mouseListener);
        }

        private JLabel getThumbnailLabel() {
            if (this.thumbnailLabel == null) {
                this.thumbnailLabel = new JLabel(this.fileInfo.getIcon());
                this.thumbnailLabel.setOpaque(true);
                this.thumbnailLabel.setBackground(StarterPanel.this.BG_COLOR);
                this.thumbnailLabel.setHorizontalAlignment(0);
                this.thumbnailLabel.setHorizontalTextPosition(0);
                this.thumbnailLabel.setToolTipText(this.fileInfo.getHelp());
                this.thumbnailLabel.setBorder(BorderFactory.createLineBorder(this.BORDER_COLOR));
            }
            return this.thumbnailLabel;
        }

        private JLabel getNameLabel() {
            if (this.nameLabel == null) {
                this.nameLabel = new JLabel(this.fileInfo.getName());
                LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{this.nameLabel});
                if (this.fileInfo.getFile() != null) {
                    this.nameLabel.setToolTipText(this.fileInfo.getFile().getPath());
                }
                this.nameLabel.setHorizontalAlignment(0);
                Dimension d = new Dimension(128, this.nameLabel.getPreferredSize().height);
                this.nameLabel.setMinimumSize(d);
                this.nameLabel.setPreferredSize(d);
                this.nameLabel.setSize(d);
            }
            return this.nameLabel;
        }

        @Override
        public void paint(Graphics g) {
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            int w = this.getWidth();
            int h = this.getHeight();
            int arc = 10;
            g2d.setColor(this.PANEL_COLOR);
            g2d.fillRoundRect(1, 1, w - 2, h - 2, arc, arc);
            super.paint(g);
            if (this.overItem == this) {
                g2d.setColor(this.FOCUS_OVERLAY_COLOR);
                g2d.fillRect(1, 1, w - 2, h - 2);
                g2d.setColor(this.FOCUS_BORDER_COLOR);
                g2d.setStroke(new BasicStroke(1.0f));
                g2d.drawRoundRect(1, 1, w - 2, h - 2, arc, arc);
            }
            g2d.dispose();
        }
    }
}

