/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal.view;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.cytoscape.internal.view.AbstractNetworkPanel;
import org.cytoscape.internal.view.ExpandCollapseButton;
import org.cytoscape.internal.view.RootNetworkPanelModel;
import org.cytoscape.internal.view.SubNetworkPanel;
import org.cytoscape.internal.view.SubNetworkPanelModel;
import org.cytoscape.internal.view.util.ViewUtil;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.cytoscape.model.subnetwork.CySubNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.LookAndFeelUtil;

public class RootNetworkPanel
extends AbstractNetworkPanel<CyRootNetwork> {
    private ExpandCollapseButton expandCollapseBtn;
    private JLabel networkCountLabel;
    private JPanel headerPanel;
    private JPanel subNetListPanel;
    private List<CySubNetwork> subNetworks;
    private LinkedHashMap<CySubNetwork, SubNetworkPanel> items;
    private boolean showIndentation;
    private ViewUtil.NetworksSortMode sortMode = ViewUtil.NetworksSortMode.CREATION;

    public RootNetworkPanel(RootNetworkPanelModel model, boolean showIndentation, CyServiceRegistrar serviceRegistrar) {
        super(model, serviceRegistrar);
        this.showIndentation = showIndentation;
    }

    public SubNetworkPanel addItem(CySubNetwork network) {
        if (!this.getItems().containsKey(network)) {
            SubNetworkPanelModel model = new SubNetworkPanelModel(network, this.serviceRegistrar);
            SubNetworkPanel subNetPanel = new SubNetworkPanel(model, this.showIndentation, this.serviceRegistrar);
            subNetPanel.setAlignmentX(0.0f);
            CySubNetwork parentNet = ViewUtil.getParent(network, this.serviceRegistrar);
            if (parentNet == null) {
                this.getSubNetListPanel().add(subNetPanel);
                this.getItems().put(network, subNetPanel);
                this.getSubNetworks().add(network);
            } else {
                LinkedHashMap<CySubNetwork, SubNetworkPanel> newItems = new LinkedHashMap<CySubNetwork, SubNetworkPanel>();
                boolean newItemAdded = false;
                boolean parentItemFound = false;
                for (Map.Entry<CySubNetwork, SubNetworkPanel> entry : this.getItems().entrySet()) {
                    if (!newItemAdded) {
                        if (!parentItemFound && entry.getKey().equals(parentNet)) {
                            parentItemFound = true;
                        } else if (parentItemFound && !entry.getValue().isDescendantOf(parentNet)) {
                            newItems.put(network, subNetPanel);
                            newItemAdded = true;
                        }
                    }
                    newItems.put(entry.getKey(), entry.getValue());
                }
                if (!newItemAdded) {
                    this.getSubNetListPanel().add(subNetPanel);
                    this.getItems().put(network, subNetPanel);
                    this.getSubNetworks().add(network);
                } else {
                    this.getSubNetListPanel().removeAll();
                    this.getItems().clear();
                    this.getSubNetworks().clear();
                    for (Map.Entry<Object, SubNetworkPanel> entry : newItems.entrySet()) {
                        CySubNetwork net = (CySubNetwork)entry.getKey();
                        SubNetworkPanel snp = entry.getValue();
                        this.getSubNetListPanel().add(snp);
                        this.getItems().put(net, snp);
                        this.getSubNetworks().add(net);
                    }
                }
            }
            this.updateRootPanel();
        }
        return this.getItems().get(network);
    }

    public SubNetworkPanel removeItem(CySubNetwork network) {
        SubNetworkPanel subNetPanel = (SubNetworkPanel)this.getItems().remove(network);
        if (subNetPanel != null) {
            this.getSubNetListPanel().remove(subNetPanel);
            this.updateRootPanel();
            this.updateIndentation();
        }
        return subNetPanel;
    }

    public SubNetworkPanel getItem(CySubNetwork network) {
        return this.getItems().get(network);
    }

    public List<SubNetworkPanel> getAllItems() {
        return new ArrayList<SubNetworkPanel>(this.getItems().values());
    }

    public boolean isEmpty() {
        return this.getItems().isEmpty();
    }

    public void expand() {
        if (!this.isExpanded()) {
            this.getSubNetListPanel().setVisible(true);
            this.firePropertyChange("expanded", false, true);
        }
    }

    public void collapse() {
        if (this.isExpanded()) {
            this.getSubNetListPanel().setVisible(false);
            this.firePropertyChange("expanded", true, false);
        }
    }

    public boolean isExpanded() {
        return this.getSubNetListPanel().isVisible();
    }

    public void setShowIndentation(boolean newValue) {
        if (newValue != this.showIndentation) {
            this.showIndentation = newValue;
            this.updateIndentation();
        }
    }

    public void sortNetworks(ViewUtil.NetworksSortMode mode) {
        this.sortMode = mode;
        if (this.isEmpty()) {
            return;
        }
        HashMap<CySubNetwork, SubNetworkPanel> map = new HashMap<CySubNetwork, SubNetworkPanel>(this.items);
        ArrayList<CySubNetwork> sortedSubNets = new ArrayList<CySubNetwork>(this.items.keySet());
        if (mode == ViewUtil.NetworksSortMode.NAME) {
            ViewUtil.sortNetworksByName(sortedSubNets);
        } else {
            ViewUtil.sortNetworksByCreationPos(sortedSubNets, this.getCreationPositions());
        }
        this.getSubNetListPanel().removeAll();
        this.getItems().clear();
        for (CySubNetwork subNet : sortedSubNets) {
            SubNetworkPanel subNetPanel = map.get(subNet);
            this.getSubNetListPanel().add(subNetPanel);
            this.getItems().put(subNet, subNetPanel);
            subNetPanel.update();
        }
        this.updateIndentation();
    }

    @Override
    public void update() {
        this.updateRootPanel();
        this.updateItemsDepth();
        this.updateIndentation();
    }

    protected void updateRootPanel() {
        super.update();
        int netCount = this.getItems().values().size();
        this.getNetworkCountLabel().setText("" + netCount);
        this.getNetworkCountLabel().setToolTipText("This collection has " + netCount + " network" + (netCount == 1 ? "" : "s"));
    }

    protected void updateItemsDepth() {
        for (SubNetworkPanel snp : this.getItems().values()) {
            int depth = this.getDepth((CySubNetwork)snp.getModel().getNetwork());
            snp.setDepth(depth);
        }
    }

    protected void updateIndentation() {
        for (SubNetworkPanel snp : this.getItems().values()) {
            snp.setShowIndentation(this.showIndentation && this.sortMode == ViewUtil.NetworksSortMode.CREATION);
        }
    }

    @Override
    protected void updateSelection() {
        Color c = UIManager.getColor(this.isSelected() ? "Table.selectionBackground" : "Table.background");
        this.getHeaderPanel().setBackground(c);
    }

    @Override
    protected void init() {
        this.setBackground(UIManager.getColor("Table.background"));
        this.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, UIManager.getColor("Separator.foreground")));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateContainerGaps(false);
        layout.setAutoCreateGaps(false);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addComponent(this.getHeaderPanel(), -1, -1, Short.MAX_VALUE).addComponent(this.getSubNetListPanel(), -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.getHeaderPanel(), -2, -1, -2).addComponent(this.getSubNetListPanel(), -2, -1, -2));
    }

    private ExpandCollapseButton getExpandCollapseBtn() {
        if (this.expandCollapseBtn == null) {
            this.expandCollapseBtn = new ExpandCollapseButton(this.isExpanded(), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    if (RootNetworkPanel.this.isExpanded()) {
                        RootNetworkPanel.this.collapse();
                    } else {
                        RootNetworkPanel.this.expand();
                    }
                }
            });
        }
        return this.expandCollapseBtn;
    }

    protected JLabel getNetworkCountLabel() {
        if (this.networkCountLabel == null) {
            this.networkCountLabel = new JLabel();
            this.networkCountLabel.setFont(this.networkCountLabel.getFont().deriveFont(LookAndFeelUtil.getSmallFontSize()));
            this.networkCountLabel.setHorizontalAlignment(4);
            this.networkCountLabel.setForeground(UIManager.getColor("Label.infoForeground"));
        }
        return this.networkCountLabel;
    }

    protected JPanel getHeaderPanel() {
        if (this.headerPanel == null) {
            this.headerPanel = new JPanel();
            this.headerPanel.setBackground(UIManager.getColor("Table.background"));
            GroupLayout layout = new GroupLayout(this.headerPanel);
            this.headerPanel.setLayout(layout);
            layout.setAutoCreateContainerGaps(false);
            layout.setAutoCreateGaps(false);
            layout.setHorizontalGroup(layout.createSequentialGroup().addComponent(this.getExpandCollapseBtn(), -2, -1, -2).addComponent(this.getNameLabel()).addGap(0, 10, Short.MAX_VALUE).addComponent(this.getNetworkCountLabel(), -1, -1, Short.MAX_VALUE).addContainerGap());
            layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, true).addComponent(this.getExpandCollapseBtn(), -2, -1, -2).addComponent(this.getNameLabel(), -2, -1, -2).addComponent(this.getNetworkCountLabel(), -2, -1, -2));
        }
        return this.headerPanel;
    }

    private JPanel getSubNetListPanel() {
        if (this.subNetListPanel == null) {
            this.subNetListPanel = new JPanel();
            this.subNetListPanel.setBackground(UIManager.getColor("Table.background"));
            this.subNetListPanel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, UIManager.getColor("TableHeader.background")));
            this.subNetListPanel.setVisible(false);
            this.subNetListPanel.setLayout(new BoxLayout(this.subNetListPanel, 1));
            this.subNetListPanel.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentShown(ComponentEvent ce) {
                    if (!RootNetworkPanel.this.getExpandCollapseBtn().isSelected()) {
                        RootNetworkPanel.this.getExpandCollapseBtn().setSelected(true);
                    }
                }

                @Override
                public void componentHidden(ComponentEvent ce) {
                    if (RootNetworkPanel.this.getExpandCollapseBtn().isSelected()) {
                        RootNetworkPanel.this.getExpandCollapseBtn().setSelected(false);
                    }
                }
            });
        }
        return this.subNetListPanel;
    }

    private LinkedHashMap<CySubNetwork, SubNetworkPanel> getItems() {
        return this.items != null ? this.items : (this.items = new LinkedHashMap());
    }

    protected List<CySubNetwork> getSubNetworks() {
        return this.subNetworks != null ? this.subNetworks : (this.subNetworks = new LinkedList<CySubNetwork>());
    }

    private Map<Long, Integer> getCreationPositions() {
        LinkedHashMap<Long, Integer> map = new LinkedHashMap<Long, Integer>();
        int count = 0;
        for (CySubNetwork net : this.getSubNetworks()) {
            map.put(net.getSUID(), count++);
        }
        return map;
    }

    private int getDepth(CySubNetwork net) {
        int depth = -1;
        CySubNetwork parent = net;
        do {
            parent = ViewUtil.getParent(parent, this.serviceRegistrar);
            ++depth;
        } while (parent != null);
        return depth;
    }
}

