/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.GroupLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.text.JTextComponent;
import org.cytoscape.internal.util.Util;
import org.cytoscape.internal.view.GridViewToggleModel;
import org.cytoscape.internal.view.GridViewTogglePanel;
import org.cytoscape.internal.view.util.ViewUtil;
import org.cytoscape.model.CyDisposable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.presentation.RenderingEngine;
import org.cytoscape.view.presentation.RenderingEngineFactory;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;

public class NetworkViewGrid
extends JPanel {
    public static final String NAME = "__NETWORK_VIEW_GRID__";
    public static int MIN_THUMBNAIL_SIZE = 100;
    public static int MAX_THUMBNAIL_SIZE = 500;
    private GridPanel gridPanel;
    private JScrollPane gridScrollPane;
    private JPanel toolBar;
    private JLabel infoLabel;
    private JLabel viewSelectionLabel;
    private JButton detachSelectedViewsButton;
    private JButton reattachAllViewsButton;
    private JButton destroySelectedViewsButton;
    private JSlider thumbnailSlider;
    private final GridViewTogglePanel gridViewTogglePanel;
    private Map<CyNetworkView, RenderingEngines> enginesMap;
    private final TreeMap<CyNetworkView, ThumbnailPanel> thumbnailPanels;
    private CyNetworkView currentNetworkView;
    private final Set<CyNetworkView> selectedNetworkViews;
    private final Set<CyNetworkView> detachedViews;
    private int thumbnailSize;
    private int maxThumbnailSize;
    private boolean dirty = true;
    private boolean fireSelectedNetworkViewsEvent = true;
    private DefaultListSelectionModel selectionModel;
    private ComponentAdapter componentAdapter;
    private int cols;
    private final CyServiceRegistrar serviceRegistrar;

    public NetworkViewGrid(GridViewToggleModel gridViewToggleModel, Comparator<CyNetworkView> viewComparator, CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
        this.enginesMap = new HashMap<CyNetworkView, RenderingEngines>();
        this.thumbnailPanels = new TreeMap(viewComparator);
        this.selectedNetworkViews = new HashSet<CyNetworkView>();
        this.detachedViews = new HashSet<CyNetworkView>();
        this.gridViewTogglePanel = new GridViewTogglePanel(gridViewToggleModel, serviceRegistrar);
        this.selectionModel = new DefaultListSelectionModel();
        this.selectionModel.addListSelectionListener(evt -> {
            if (!evt.getValueIsAdjusting()) {
                List<CyNetworkView> oldValue = this.getSelectedNetworkViews();
                List<ThumbnailPanel> allItems = this.getAllItems();
                boolean changed = false;
                int first = evt.getFirstIndex();
                int last = evt.getLastIndex();
                for (int i = first; i <= last && i < allItems.size(); ++i) {
                    ThumbnailPanel p = allItems.get(i);
                    boolean selected = this.selectionModel.isSelectedIndex(i);
                    if (p.isSelected() == selected) continue;
                    p.setSelected(selected);
                    changed = true;
                    if (selected) {
                        this.selectedNetworkViews.add(p.getNetworkView());
                        continue;
                    }
                    this.selectedNetworkViews.remove(p.getNetworkView());
                }
                if (changed && this.fireSelectedNetworkViewsEvent) {
                    this.firePropertyChange("selectedNetworkViews", oldValue, this.getSelectedNetworkViews());
                }
            }
        });
        this.init();
    }

    public ThumbnailPanel getItem(CyNetworkView view) {
        return this.thumbnailPanels.get(view);
    }

    public Collection<ThumbnailPanel> getItems() {
        return new ArrayList<ThumbnailPanel>(this.thumbnailPanels.values());
    }

    protected ThumbnailPanel getCurrentItem() {
        return this.currentNetworkView != null ? this.thumbnailPanels.get(this.currentNetworkView) : null;
    }

    public ThumbnailPanel firstItem() {
        return this.thumbnailPanels.firstEntry().getValue();
    }

    public ThumbnailPanel lastItem() {
        return this.thumbnailPanels.lastEntry().getValue();
    }

    public int indexOf(ThumbnailPanel tp) {
        return new ArrayList<CyNetworkView>(this.thumbnailPanels.keySet()).indexOf(tp.getNetworkView());
    }

    public boolean isEmpty() {
        return this.thumbnailPanels.isEmpty();
    }

    public void addItem(RenderingEngine<CyNetwork> re, RenderingEngineFactory<CyNetwork> thumbnailFactory) {
        if (!this.contains(re)) {
            List<CyNetworkView> oldViews = this.getAllNetworkViews();
            this.enginesMap.put((CyNetworkView)re.getViewModel(), new RenderingEngines(re, thumbnailFactory));
            this.dirty = true;
            this.firePropertyChange("networkViews", oldViews, this.getAllNetworkViews());
        }
    }

    public void removeItems(Collection<RenderingEngine<CyNetwork>> enginesToRemove) {
        if (enginesToRemove != null && !enginesToRemove.isEmpty()) {
            List<CyNetworkView> oldViews = this.getAllNetworkViews();
            boolean removed = false;
            for (RenderingEngine<CyNetwork> re : enginesToRemove) {
                if (re == null || this.enginesMap.remove(re.getViewModel()) == null) continue;
                removed = true;
                this.dirty = true;
            }
            if (removed) {
                this.updateToolBar();
                this.firePropertyChange("networkViews", oldViews, this.getAllNetworkViews());
            }
        }
    }

    public List<CyNetworkView> getAllNetworkViews() {
        return new ArrayList<CyNetworkView>(this.enginesMap.keySet());
    }

    public void scrollToCurrentItem() {
        ThumbnailPanel tp = this.getCurrentItem();
        if (tp != null && tp.getParent() instanceof JComponent) {
            if (!this.isValid()) {
                this.validate();
            }
            ((JComponent)tp.getParent()).scrollRectToVisible(tp.getBounds());
        }
    }

    public void dispose() {
        if (this.componentAdapter != null) {
            this.removeComponentListener(this.componentAdapter);
            this.componentAdapter = null;
        }
        this.removeAll();
    }

    private boolean contains(RenderingEngine<CyNetwork> re) {
        return this.enginesMap.containsKey(re.getViewModel());
    }

    void selectAndSetCurrent(ThumbnailPanel item) {
        if (item == null) {
            return;
        }
        List<ThumbnailPanel> allItems = this.getAllItems();
        this.setSelectedIndex(allItems.indexOf(item));
        this.setCurrentNetworkView(item.getNetworkView());
    }

    void setSelectedIndex(int index) {
        if (index >= this.thumbnailPanels.size()) {
            return;
        }
        this.selectionModel.setSelectionInterval(index, index);
    }

    protected CyNetworkView getCurrentNetworkView() {
        return this.currentNetworkView;
    }

    protected boolean setCurrentNetworkView(CyNetworkView newView) {
        if (this.currentNetworkView == null && newView == null || this.currentNetworkView != null && this.currentNetworkView.equals(newView)) {
            return false;
        }
        CyNetworkView oldView = this.currentNetworkView;
        this.currentNetworkView = newView;
        for (ThumbnailPanel tp : this.thumbnailPanels.values()) {
            tp.update(false);
        }
        this.firePropertyChange("currentNetworkView", oldView, newView);
        return true;
    }

    protected boolean isDetached(CyNetworkView view) {
        return this.detachedViews.contains(view);
    }

    protected void setDetached(CyNetworkView view, boolean newValue) {
        boolean oldValue = this.isDetached(view);
        if (newValue != oldValue) {
            if (newValue) {
                this.detachedViews.add(view);
            } else {
                this.detachedViews.remove(view);
            }
            this.updateDetachReattachButtons();
        }
    }

    protected void update(int thumbnailSize) {
        this.dirty = this.dirty || thumbnailSize < this.thumbnailSize || thumbnailSize > this.maxThumbnailSize;
        this.thumbnailSize = thumbnailSize;
        Dimension size = this.getSize();
        if (!this.dirty && size != null && size.width > 0) {
            this.cols = NetworkViewGrid.calculateColumns(thumbnailSize, size.width);
            this.dirty = this.getGridPanel().getLayout() instanceof GridLayout ? this.cols != ((GridLayout)this.getGridPanel().getLayout()).getColumns() : true;
        }
        if (!this.dirty) {
            return;
        }
        this.recreateThumbnails();
        this.updateToolBar();
    }

    protected void updateToolBar() {
        Collection<ThumbnailPanel> items = this.getItems();
        List<ThumbnailPanel> selectedItems = this.getSelectedItems();
        this.gridViewTogglePanel.update();
        this.getDestroySelectedViewsButton().setEnabled(!selectedItems.isEmpty());
        if (items.isEmpty()) {
            this.getViewSelectionLabel().setText(null);
        } else {
            this.getViewSelectionLabel().setText(selectedItems.size() + " of " + items.size() + " View" + (items.size() == 1 ? "" : "s") + " selected");
        }
        this.updateDetachReattachButtons();
        this.getToolBar().updateUI();
    }

    private void updateDetachReattachButtons() {
        boolean hasAttached = false;
        boolean hasDetached = false;
        for (ThumbnailPanel tp : this.getSelectedItems()) {
            if (this.isDetached(tp.getNetworkView())) continue;
            hasAttached = true;
            break;
        }
        for (ThumbnailPanel tp : this.getItems()) {
            if (!this.isDetached(tp.getNetworkView())) continue;
            hasDetached = true;
            break;
        }
        this.getDetachSelectedViewsButton().setEnabled(hasAttached);
        this.getReattachAllViewsButton().setEnabled(hasDetached);
    }

    protected int getThumbnailSize() {
        return this.thumbnailSize;
    }

    protected void selectAll() {
        if (!this.thumbnailPanels.isEmpty()) {
            this.selectionModel.setSelectionInterval(0, this.thumbnailPanels.size() - 1);
        }
    }

    protected void deselectAll() {
        this.setCurrentNetworkView(null);
        this.setSelectedItems(Collections.emptyList());
    }

    void onMousePressedItem(MouseEvent e, ThumbnailPanel item) {
        item.requestFocusInWindow();
        if (!e.isPopupTrigger() && SwingUtilities.isLeftMouseButton(e)) {
            boolean isControlDown;
            boolean isMac = LookAndFeelUtil.isMac();
            boolean bl = isControlDown = isMac && e.isMetaDown() || !isMac && e.isControlDown();
            if (isControlDown) {
                this.toggleSelection(item);
            } else if (e.isShiftDown()) {
                List<ThumbnailPanel> allItems = this.getAllItems();
                int index = allItems.indexOf(item);
                this.shiftSelectTo(index);
            } else {
                this.selectAndSetCurrent(item);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shiftSelectTo(int index) {
        int size = this.thumbnailPanels.size();
        if (index < 0 || index >= size) {
            return;
        }
        int anchor = this.selectionModel.getAnchorSelectionIndex();
        int lead = this.selectionModel.getLeadSelectionIndex();
        this.selectionModel.setValueIsAdjusting(true);
        if (anchor != lead && (anchor >= 0 || lead >= 0)) {
            this.fireSelectedNetworkViewsEvent = false;
            try {
                this.selectionModel.removeSelectionInterval(Math.max(0, anchor), Math.max(0, lead));
            }
            finally {
                this.fireSelectedNetworkViewsEvent = true;
            }
        }
        this.selectionModel.addSelectionInterval(Math.max(0, anchor), index);
        this.selectionModel.setValueIsAdjusting(false);
        List<ThumbnailPanel> allItems = this.getAllItems();
        allItems.get(index).requestFocusInWindow();
    }

    private void toggleSelection(ThumbnailPanel item) {
        List<ThumbnailPanel> allItems = this.getAllItems();
        int index = allItems.indexOf(item);
        if (this.selectionModel.isSelectedIndex(index)) {
            this.selectionModel.removeSelectionInterval(index, index);
        } else {
            this.selectionModel.addSelectionInterval(index, index);
        }
        this.selectionModel.setValueIsAdjusting(true);
        if (this.selectionModel.isSelectedIndex(index)) {
            this.selectionModel.setAnchorSelectionIndex(index);
            this.selectionModel.moveLeadSelectionIndex(index);
        } else {
            index = this.selectionModel.getMaxSelectionIndex();
            this.selectionModel.setAnchorSelectionIndex(index);
            this.selectionModel.moveLeadSelectionIndex(index);
        }
        this.selectionModel.setValueIsAdjusting(false);
    }

    protected List<CyNetworkView> getSelectedNetworkViews() {
        return new ArrayList<CyNetworkView>(this.selectedNetworkViews);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setSelectedNetworkViews(Collection<CyNetworkView> views) {
        if (Util.equalSets(views, this.selectedNetworkViews)) {
            return;
        }
        this.selectedNetworkViews.clear();
        this.selectedNetworkViews.addAll(views);
        if (this.thumbnailPanels.isEmpty() || this.enginesMap.isEmpty()) {
            return;
        }
        LinkedHashSet<ThumbnailPanel> selectedItems = new LinkedHashSet<ThumbnailPanel>();
        for (Map.Entry<CyNetworkView, ThumbnailPanel> entry : this.thumbnailPanels.entrySet()) {
            if (!views.contains(entry.getKey()) || !this.enginesMap.containsKey(entry.getKey())) continue;
            selectedItems.add(entry.getValue());
        }
        this.fireSelectedNetworkViewsEvent = false;
        try {
            this.setSelectedItems(selectedItems);
        }
        finally {
            this.fireSelectedNetworkViewsEvent = true;
        }
        this.updateToolBar();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSelectedItems(Collection<ThumbnailPanel> items) {
        this.selectionModel.setValueIsAdjusting(true);
        try {
            this.selectionModel.clearSelection();
            ArrayList<CyNetworkView> allKeys = new ArrayList<CyNetworkView>(this.thumbnailPanels.keySet());
            int maxIdx = -1;
            for (ThumbnailPanel p : items) {
                int idx = allKeys.indexOf(p.getNetworkView());
                if (idx < 0) continue;
                this.selectionModel.addSelectionInterval(idx, idx);
                maxIdx = Math.max(idx, maxIdx);
            }
            this.selectionModel.setAnchorSelectionIndex(maxIdx);
            this.selectionModel.moveLeadSelectionIndex(maxIdx);
        }
        finally {
            this.selectionModel.setValueIsAdjusting(false);
        }
    }

    protected List<ThumbnailPanel> getSelectedItems() {
        ArrayList<ThumbnailPanel> list = new ArrayList<ThumbnailPanel>();
        for (Map.Entry<CyNetworkView, ThumbnailPanel> entry : this.thumbnailPanels.entrySet()) {
            ThumbnailPanel tp = entry.getValue();
            if (!tp.isSelected()) continue;
            list.add(tp);
        }
        return list;
    }

    private List<ThumbnailPanel> getAllItems() {
        return new ArrayList<ThumbnailPanel>(this.thumbnailPanels.values());
    }

    private void init() {
        this.setName(NAME);
        this.setFocusable(true);
        this.setRequestFocusEnabled(true);
        this.setLayout(new BorderLayout());
        this.add((Component)this.getGridScrollPane(), "Center");
        this.add((Component)this.getToolBar(), "South");
        this.componentAdapter = new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                NetworkViewGrid.this.update(NetworkViewGrid.this.thumbnailSize);
                NetworkViewGrid.this.updateToolBar();
            }

            @Override
            public void componentResized(ComponentEvent e) {
                NetworkViewGrid.this.update(NetworkViewGrid.this.thumbnailSize);
            }
        };
        this.addComponentListener(this.componentAdapter);
        this.setSelectionKeyBindings(this);
        this.setSelectionKeyBindings(this.getGridScrollPane().getViewport());
        this.update(this.thumbnailSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recreateThumbnails() {
        Dimension size = this.getSize();
        if (size == null || size.width <= 0) {
            return;
        }
        this.getGridPanel().removeAll();
        for (ThumbnailPanel tp : this.thumbnailPanels.values()) {
            tp.getThumbnailRenderingEngine().ifPresent(CyDisposable::dispose);
        }
        this.thumbnailPanels.clear();
        if (this.enginesMap == null || this.enginesMap.isEmpty()) {
            GroupLayout layout = new GroupLayout(this.getGridPanel());
            this.getGridPanel().setLayout(layout);
            layout.setAutoCreateContainerGaps(true);
            layout.setAutoCreateGaps(true);
            layout.setHorizontalGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.getInfoLabel(), -2, -1, -2).addGap(0, 0, Short.MAX_VALUE));
            layout.setVerticalGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.getInfoLabel()).addGap(0, 0, Short.MAX_VALUE));
            this.detachedViews.clear();
            this.deselectAll();
        } else {
            this.maxThumbnailSize = NetworkViewGrid.maxThumbnailSize(this.thumbnailSize, size.width);
            int cols = NetworkViewGrid.calculateColumns(this.maxThumbnailSize, size.width);
            int rows = NetworkViewGrid.calculateRows(this.enginesMap.size(), cols);
            this.getGridPanel().setLayout(new GridLayout(rows, cols));
            for (Map.Entry<CyNetworkView, RenderingEngines> entry : this.enginesMap.entrySet()) {
                CyNetworkView view = entry.getKey();
                RenderingEngines engines = entry.getValue();
                boolean selected = this.selectedNetworkViews.contains(view);
                ThumbnailPanel tp = new ThumbnailPanel(engines, this.maxThumbnailSize, selected);
                this.thumbnailPanels.put(tp.getNetworkView(), tp);
                this.setSelectionKeyBindings(tp);
            }
            for (ThumbnailPanel tp : this.thumbnailPanels.values()) {
                this.getGridPanel().add(tp);
            }
            if (this.thumbnailPanels.size() < cols) {
                int diff = cols - this.thumbnailPanels.size();
                for (int i = 0; i < diff; ++i) {
                    JPanel filler = new JPanel();
                    filler.setOpaque(false);
                    this.getGridPanel().add(filler);
                }
            }
            Iterator<CyNetworkView> iter = this.detachedViews.iterator();
            while (iter.hasNext()) {
                if (this.thumbnailPanels.containsKey(iter.next())) continue;
                iter.remove();
            }
            iter = this.selectedNetworkViews.iterator();
            while (iter.hasNext()) {
                if (this.thumbnailPanels.containsKey(iter.next())) continue;
                iter.remove();
            }
            this.fireSelectedNetworkViewsEvent = false;
            try {
                this.setSelectedItems(this.getSelectedItems());
            }
            finally {
                this.fireSelectedNetworkViewsEvent = true;
            }
            if (this.currentNetworkView != null && !this.thumbnailPanels.containsKey(this.currentNetworkView)) {
                this.currentNetworkView = null;
            }
        }
        this.dirty = false;
        this.updateToolBar();
        this.getGridPanel().updateUI();
        this.firePropertyChange("thumbnailPanels", null, this.getAllItems());
    }

    private GridPanel getGridPanel() {
        if (this.gridPanel == null) {
            this.gridPanel = new GridPanel();
            this.gridPanel.setBackground(NetworkViewGrid.getBackgroundColor());
            this.gridPanel.setBorder(BorderFactory.createLineBorder(NetworkViewGrid.getBackgroundColor(), 1));
            this.gridPanel.setOpaque(false);
        }
        return this.gridPanel;
    }

    protected JScrollPane getGridScrollPane() {
        if (this.gridScrollPane == null) {
            this.gridScrollPane = new JScrollPane(this.getGridPanel(), 22, 31);
            this.gridScrollPane.getViewport().setBackground(NetworkViewGrid.getBackgroundColor());
            this.gridScrollPane.setBorder(BorderFactory.createEmptyBorder());
            this.gridScrollPane.getViewport().addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    Collection<ThumbnailPanel> items;
                    if (!e.isPopupTrigger()) {
                        NetworkViewGrid.this.deselectAll();
                    }
                    if (!(items = NetworkViewGrid.this.getItems()).isEmpty()) {
                        items.iterator().next().requestFocusInWindow();
                    }
                }
            });
        }
        return this.gridScrollPane;
    }

    private JPanel getToolBar() {
        if (this.toolBar == null) {
            this.toolBar = new JPanel();
            this.toolBar.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, UIManager.getColor("Separator.foreground")));
            JSeparator sep1 = ViewUtil.createToolBarSeparator();
            JSeparator sep2 = ViewUtil.createToolBarSeparator();
            JSeparator sep3 = ViewUtil.createToolBarSeparator();
            JSeparator sep4 = ViewUtil.createToolBarSeparator();
            GroupLayout layout = new GroupLayout(this.toolBar);
            this.toolBar.setLayout(layout);
            layout.setAutoCreateContainerGaps(false);
            layout.setAutoCreateGaps(false);
            layout.setHorizontalGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.gridViewTogglePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(sep1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.getDetachSelectedViewsButton(), -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.getReattachAllViewsButton(), -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(sep2, -2, -1, -2).addGap(0, 10, Short.MAX_VALUE).addComponent(this.getViewSelectionLabel(), -2, -1, -2).addGap(0, 10, Short.MAX_VALUE).addComponent(sep3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.getDestroySelectedViewsButton(), -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(sep4, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.getThumbnailSlider(), 100, 100, 100).addContainerGap());
            layout.setVerticalGroup(layout.createSequentialGroup().addGap(1).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.gridViewTogglePanel, -2, -1, -2).addComponent(sep1, -1, -1, Short.MAX_VALUE).addComponent(this.getDetachSelectedViewsButton(), -2, -1, -2).addComponent(this.getReattachAllViewsButton(), -2, -1, -2).addComponent(sep2, -1, -1, Short.MAX_VALUE).addComponent(this.getViewSelectionLabel(), -2, -1, -2).addComponent(sep3, -1, -1, Short.MAX_VALUE).addComponent(this.getDestroySelectedViewsButton(), -2, -1, -2).addComponent(sep4, -1, -1, Short.MAX_VALUE).addComponent(this.getThumbnailSlider(), -2, -1, -2)).addGap(1));
            LookAndFeelUtil.equalizeSize((JComponent[])new JComponent[]{this.gridViewTogglePanel.getGridModeButton(), this.gridViewTogglePanel.getViewModeButton(), this.getDetachSelectedViewsButton(), this.getReattachAllViewsButton(), this.getDestroySelectedViewsButton()});
        }
        return this.toolBar;
    }

    JButton getDetachSelectedViewsButton() {
        if (this.detachSelectedViewsButton == null) {
            this.detachSelectedViewsButton = new JButton("\uf14c");
            this.detachSelectedViewsButton.setToolTipText("Detach Selected Views");
            ViewUtil.styleToolBarButton((AbstractButton)this.detachSelectedViewsButton, ((IconManager)this.serviceRegistrar.getService(IconManager.class)).getIconFont(22.0f));
        }
        return this.detachSelectedViewsButton;
    }

    JButton getReattachAllViewsButton() {
        if (this.reattachAllViewsButton == null) {
            this.reattachAllViewsButton = new JButton("(");
            this.reattachAllViewsButton.setToolTipText("Reattach All Views");
            ViewUtil.styleToolBarButton((AbstractButton)this.reattachAllViewsButton, ((IconManager)this.serviceRegistrar.getService(IconManager.class)).getIconFont("cytoscape-3", 16.0f));
        }
        return this.reattachAllViewsButton;
    }

    JButton getDestroySelectedViewsButton() {
        if (this.destroySelectedViewsButton == null) {
            this.destroySelectedViewsButton = new JButton("\uf014");
            this.destroySelectedViewsButton.setToolTipText("Destroy Selected Views");
            ViewUtil.styleToolBarButton((AbstractButton)this.destroySelectedViewsButton, ((IconManager)this.serviceRegistrar.getService(IconManager.class)).getIconFont(22.0f));
        }
        return this.destroySelectedViewsButton;
    }

    private JLabel getInfoLabel() {
        if (this.infoLabel == null) {
            this.infoLabel = new JLabel("No views");
            this.infoLabel.setFont(this.infoLabel.getFont().deriveFont(18.0f).deriveFont(1));
            this.infoLabel.setEnabled(false);
            Color c = UIManager.getColor("Label.disabledForeground");
            c = new Color(c.getRed(), c.getGreen(), c.getBlue(), 120);
            this.infoLabel.setForeground(c);
        }
        return this.infoLabel;
    }

    private JLabel getViewSelectionLabel() {
        if (this.viewSelectionLabel == null) {
            this.viewSelectionLabel = new JLabel();
            this.viewSelectionLabel.setHorizontalAlignment(0);
            this.viewSelectionLabel.setFont(this.viewSelectionLabel.getFont().deriveFont(LookAndFeelUtil.getSmallFontSize()));
        }
        return this.viewSelectionLabel;
    }

    protected JSlider getThumbnailSlider() {
        if (this.thumbnailSlider == null) {
            int value = Math.round((float)MIN_THUMBNAIL_SIZE + (float)(MAX_THUMBNAIL_SIZE - MIN_THUMBNAIL_SIZE) / 3.0f);
            this.thumbnailSlider = new JSlider(MIN_THUMBNAIL_SIZE, MAX_THUMBNAIL_SIZE, value);
            this.thumbnailSlider.setToolTipText("Thumbnail Size");
            this.thumbnailSlider.putClientProperty("JComponent.sizeVariant", "mini");
            this.thumbnailSlider.addChangeListener(e -> {
                if (!this.thumbnailSlider.getValueIsAdjusting()) {
                    int thumbSize = this.thumbnailSlider.getValue();
                    this.update(thumbSize);
                }
            });
        }
        return this.thumbnailSlider;
    }

    private void setSelectionKeyBindings(JComponent comp) {
        ActionMap actionMap = comp.getActionMap();
        InputMap inputMap = comp.getInputMap(1);
        int CTRL = LookAndFeelUtil.isMac() ? 256 : 128;
        inputMap.put(KeyStroke.getKeyStroke(37, 0), "VK_LEFT");
        inputMap.put(KeyStroke.getKeyStroke(39, 0), "VK_RIGHT");
        inputMap.put(KeyStroke.getKeyStroke(38, 0), "VK_UP");
        inputMap.put(KeyStroke.getKeyStroke(40, 0), "VK_DOWN");
        inputMap.put(KeyStroke.getKeyStroke(37, 64), "VK_SHIFT_LEFT");
        inputMap.put(KeyStroke.getKeyStroke(39, 64), "VK_SHIFT_RIGHT");
        inputMap.put(KeyStroke.getKeyStroke(38, 64), "VK_SHIFT_UP");
        inputMap.put(KeyStroke.getKeyStroke(40, 64), "VK_SHIFT_DOWN");
        inputMap.put(KeyStroke.getKeyStroke(65, CTRL), "VK_CTRL_A");
        inputMap.put(KeyStroke.getKeyStroke(65, CTRL + 64), "VK_CTRL_SHIFT_A");
        actionMap.put("VK_LEFT", new KeyAction("VK_LEFT"));
        actionMap.put("VK_RIGHT", new KeyAction("VK_RIGHT"));
        actionMap.put("VK_UP", new KeyAction("VK_UP"));
        actionMap.put("VK_DOWN", new KeyAction("VK_DOWN"));
        actionMap.put("VK_SHIFT_LEFT", new KeyAction("VK_SHIFT_LEFT"));
        actionMap.put("VK_SHIFT_RIGHT", new KeyAction("VK_SHIFT_RIGHT"));
        actionMap.put("VK_SHIFT_UP", new KeyAction("VK_SHIFT_UP"));
        actionMap.put("VK_SHIFT_DOWN", new KeyAction("VK_SHIFT_DOWN"));
        actionMap.put("VK_CTRL_A", new KeyAction("VK_CTRL_A"));
        actionMap.put("VK_CTRL_SHIFT_A", new KeyAction("VK_CTRL_SHIFT_A"));
    }

    private static int calculateColumns(int thumbnailSize, int gridWidth) {
        return thumbnailSize > 0 ? Math.floorDiv(gridWidth, thumbnailSize) : 0;
    }

    private static int calculateRows(int total, int cols) {
        return (int)Math.round(Math.ceil((float)total / (float)cols));
    }

    private static int maxThumbnailSize(int thumbnailSize, int gridWidth) {
        thumbnailSize = Math.max(thumbnailSize, MIN_THUMBNAIL_SIZE);
        thumbnailSize = Math.min(thumbnailSize, MAX_THUMBNAIL_SIZE);
        thumbnailSize = Math.min(thumbnailSize, gridWidth);
        return thumbnailSize;
    }

    private static Color getBackgroundColor() {
        return UIManager.getColor("Panel.background");
    }

    static List<CyNetworkView> getNetworkViews(Collection<ThumbnailPanel> thumbnailPanels) {
        ArrayList<CyNetworkView> views = new ArrayList<CyNetworkView>();
        for (ThumbnailPanel tp : thumbnailPanels) {
            views.add(tp.getNetworkView());
        }
        return views;
    }

    class ThumbnailPanel
    extends JPanel {
        static final int PAD = 4;
        static final int GAP = 1;
        static final int MT = 1;
        static final int BT = 1;
        static final int PT = 1;
        static final int BORDER_WIDTH = 3;
        static final int IMG_BORDER_WIDTH = 1;
        private JLabel currentLabel;
        private JLabel titleLabel;
        private JRootPane imagePanel;
        private Optional<RenderingEngine<?>> thumbnailRenderer = Optional.empty();
        private boolean selected;
        private final RenderingEngines engines;
        private final Color BORDER_COLOR = UIManager.getColor("Separator.foreground");
        private final Color SEL_COLOR = UIManager.getColor("Table.focusCellBackground");
        private Border EMPTY_BORDER = BorderFactory.createEmptyBorder(1, 1, 1, 1);
        private Border MARGIN_BORDER = BorderFactory.createLineBorder(NetworkViewGrid.getBackgroundColor(), 1);
        private Border SIMPLE_BORDER = BorderFactory.createLineBorder(this.BORDER_COLOR, 1);
        private Border DEFAULT_BORDER = BorderFactory.createCompoundBorder(this.MARGIN_BORDER, BorderFactory.createCompoundBorder(this.SIMPLE_BORDER, this.EMPTY_BORDER));
        private Border DEFAULT_HOVER_BORDER = BorderFactory.createCompoundBorder(this.MARGIN_BORDER, BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(this.SEL_COLOR, 1), this.EMPTY_BORDER));
        private Border MIDDLE_SIBLING_BORDER = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 1, 0, NetworkViewGrid.getBackgroundColor()), BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 1, 0, this.BORDER_COLOR), this.EMPTY_BORDER));
        private Border FIRST_SIBLING_BORDER = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 1, 1, 0, NetworkViewGrid.getBackgroundColor()), BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 1, 1, 0, this.BORDER_COLOR), this.EMPTY_BORDER));
        private Border LAST_SIBLING_BORDER = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 1, 1, NetworkViewGrid.getBackgroundColor()), BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 1, 1, this.BORDER_COLOR), this.EMPTY_BORDER));
        private Border MIDDLE_SIBLING_SEL_BORDER = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 1, 0, NetworkViewGrid.getBackgroundColor()), BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, this.SEL_COLOR), BorderFactory.createEmptyBorder(1, 0, 1, 0)));
        private Border FIRST_SIBLING_SEL_BORDER = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 1, 1, 0, NetworkViewGrid.getBackgroundColor()), BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, this.SEL_COLOR), BorderFactory.createEmptyBorder(1, 1, 1, 0)));
        private Border LAST_SIBLING_SEL_BORDER = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 1, 1, NetworkViewGrid.getBackgroundColor()), BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, this.SEL_COLOR), BorderFactory.createEmptyBorder(1, 0, 1, 1)));

        ThumbnailPanel(RenderingEngines engines, int size, boolean selected) {
            this.engines = engines;
            this.selected = selected;
            this.setFocusable(true);
            this.setRequestFocusEnabled(true);
            this.setBorder(this.DEFAULT_BORDER);
            this.setBackground(UIManager.getColor("Table.background"));
            Dimension d = new Dimension(size - 3, size - 3);
            this.setMinimumSize(d);
            this.setPreferredSize(d);
            int CURR_LABEL_W = this.getCurrentLabel().getWidth();
            GroupLayout layout = new GroupLayout(this);
            this.setLayout(layout);
            layout.setAutoCreateContainerGaps(false);
            layout.setAutoCreateGaps(false);
            layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, true).addGroup(layout.createSequentialGroup().addGap(4).addComponent(this.getCurrentLabel(), CURR_LABEL_W, CURR_LABEL_W, CURR_LABEL_W).addGap(1, 1, Short.MAX_VALUE).addComponent(this.getTitleLabel()).addGap(1, 1, Short.MAX_VALUE).addGap(CURR_LABEL_W).addGap(4)).addGroup(layout.createSequentialGroup().addGap(4, 4, 4).addComponent(this.getImagePanel(), -2, -1, Short.MAX_VALUE).addGap(4, 4, 4)));
            layout.setVerticalGroup(layout.createSequentialGroup().addGap(1).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.getCurrentLabel(), -2, -1, -2).addComponent(this.getTitleLabel(), -2, -1, -2)).addGap(1).addComponent(this.getImagePanel(), -2, -1, Short.MAX_VALUE).addGap(4, 4, 4));
            this.update(true);
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    ThumbnailPanel.this.updateTitleLabel();
                }
            });
        }

        @Override
        public Color getBackground() {
            return UIManager.getColor(this.selected ? "Table.focusCellBackground" : "Table.background");
        }

        private void setSelected(boolean newValue) {
            if (this.selected != newValue) {
                boolean oldValue = this.selected;
                this.selected = newValue;
                this.updateBorder();
                this.repaint();
                this.firePropertyChange("selected", oldValue, newValue);
            }
        }

        boolean isSelected() {
            return this.selected;
        }

        boolean isCurrent() {
            return this.getNetworkView().equals(NetworkViewGrid.this.currentNetworkView);
        }

        boolean isFirstSibling() {
            CyNetworkView netView = this.getNetworkView();
            CyNetwork net = (CyNetwork)netView.getModel();
            Map.Entry<CyNetworkView, ThumbnailPanel> previous = NetworkViewGrid.this.thumbnailPanels.lowerEntry(netView);
            Map.Entry<CyNetworkView, ThumbnailPanel> next = NetworkViewGrid.this.thumbnailPanels.higherEntry(netView);
            return (previous == null || !((CyNetwork)previous.getKey().getModel()).equals(net)) && next != null && ((CyNetwork)next.getKey().getModel()).equals(net);
        }

        boolean isMiddleSibling() {
            CyNetworkView netView = this.getNetworkView();
            CyNetwork net = (CyNetwork)netView.getModel();
            Map.Entry<CyNetworkView, ThumbnailPanel> previous = NetworkViewGrid.this.thumbnailPanels.lowerEntry(netView);
            Map.Entry<CyNetworkView, ThumbnailPanel> next = NetworkViewGrid.this.thumbnailPanels.higherEntry(netView);
            return previous != null && ((CyNetwork)previous.getKey().getModel()).equals(net) && next != null && ((CyNetwork)next.getKey().getModel()).equals(net);
        }

        boolean isLastSibling() {
            CyNetworkView netView = this.getNetworkView();
            CyNetwork net = (CyNetwork)netView.getModel();
            Map.Entry<CyNetworkView, ThumbnailPanel> previous = NetworkViewGrid.this.thumbnailPanels.lowerEntry(netView);
            Map.Entry<CyNetworkView, ThumbnailPanel> next = NetworkViewGrid.this.thumbnailPanels.higherEntry(netView);
            return (next == null || !((CyNetwork)next.getKey().getModel()).equals(net)) && previous != null && ((CyNetwork)previous.getKey().getModel()).equals(net);
        }

        void update(boolean redraw) {
            this.updateCurrentLabel();
            this.updateBorder();
            this.updateTitleLabel();
        }

        private void updateCurrentLabel() {
            this.getCurrentLabel().setText(this.isCurrent() ? "\uf111" : " ");
            this.getCurrentLabel().setToolTipText(this.isCurrent() ? "Current View" : null);
        }

        private void updateBorder() {
            if (this.isFirstSibling()) {
                this.setBorder(this.selected ? this.FIRST_SIBLING_SEL_BORDER : this.FIRST_SIBLING_BORDER);
            } else if (this.isMiddleSibling()) {
                this.setBorder(this.selected ? this.MIDDLE_SIBLING_SEL_BORDER : this.MIDDLE_SIBLING_BORDER);
            } else if (this.isLastSibling()) {
                this.setBorder(this.selected ? this.LAST_SIBLING_SEL_BORDER : this.LAST_SIBLING_BORDER);
            } else {
                this.setBorder(this.selected ? this.DEFAULT_HOVER_BORDER : this.DEFAULT_BORDER);
            }
        }

        private void updateTitleLabel() {
            String title = ViewUtil.getTitle(this.getNetworkView());
            this.setToolTipText(title);
            this.getTitleLabel().setText(title);
        }

        CyNetworkView getNetworkView() {
            return (CyNetworkView)this.engines.networkEngine.getViewModel();
        }

        JLabel getCurrentLabel() {
            if (this.currentLabel == null) {
                this.currentLabel = new ThumbnailLabel("\uf111", true);
                this.currentLabel.setFont(((IconManager)NetworkViewGrid.this.serviceRegistrar.getService(IconManager.class)).getIconFont(10.0f));
                this.currentLabel.setMinimumSize(this.currentLabel.getPreferredSize());
                this.currentLabel.setMaximumSize(this.currentLabel.getPreferredSize());
                this.currentLabel.setSize(this.currentLabel.getPreferredSize());
            }
            return this.currentLabel;
        }

        JLabel getTitleLabel() {
            if (this.titleLabel == null) {
                this.titleLabel = new ThumbnailLabel(false);
                this.titleLabel.setHorizontalAlignment(0);
                this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(LookAndFeelUtil.getSmallFontSize()));
                this.titleLabel.setMinimumSize(this.titleLabel.getPreferredSize());
            }
            return this.titleLabel;
        }

        private JLabel createIconLabel() {
            JLabel label = new JLabel("\uf1e1");
            label.setFont(((IconManager)NetworkViewGrid.this.serviceRegistrar.getService(IconManager.class)).getIconFont(40.0f));
            Color c = UIManager.getColor("Label.disabledForeground");
            c = new Color(c.getRed(), c.getGreen(), c.getBlue(), 40);
            label.setForeground(c);
            label.setHorizontalAlignment(0);
            label.setVerticalAlignment(0);
            return label;
        }

        JRootPane getImagePanel() {
            if (this.imagePanel == null) {
                this.imagePanel = new JRootPane();
                this.imagePanel.setBorder(BorderFactory.createLineBorder(UIManager.getColor("Label.foreground"), 1));
                this.imagePanel.getGlassPane().setVisible(true);
                Container contentPane = this.imagePanel.getContentPane();
                this.thumbnailRenderer = Optional.empty();
                if (this.engines.thumbnailEngineFactory.isPresent()) {
                    try {
                        RenderingEngineFactory<CyNetwork> engineFactory = this.engines.thumbnailEngineFactory.get();
                        CyNetworkView netView = this.getNetworkView();
                        RenderingEngine re = engineFactory.createRenderingEngine((Object)contentPane, (View)netView);
                        this.thumbnailRenderer = Optional.of(re);
                    }
                    catch (IllegalArgumentException | IllegalStateException e) {
                        contentPane.setLayout(new BorderLayout());
                        contentPane.add((Component)this.createIconLabel(), "Center");
                    }
                } else {
                    contentPane.setLayout(new BorderLayout());
                    contentPane.add((Component)this.createIconLabel(), "Center");
                }
            }
            return this.imagePanel;
        }

        public Optional<RenderingEngine<?>> getThumbnailRenderingEngine() {
            return this.thumbnailRenderer;
        }

        @Override
        public String toString() {
            return (String)this.getNetworkView().getVisualProperty(BasicVisualLexicon.NETWORK_TITLE);
        }

        private class ThumbnailLabel
        extends JLabel {
            private final boolean highlightWhenCurrent;

            public ThumbnailLabel(boolean highlightWhenCurrent) {
                this.highlightWhenCurrent = highlightWhenCurrent;
            }

            public ThumbnailLabel(String text, boolean highlightWhenCurrent) {
                this(highlightWhenCurrent);
                this.setText(text);
            }

            @Override
            public Color getForeground() {
                String defColor = this.highlightWhenCurrent ? "Focus.color" : "Label.foreground";
                return UIManager.getColor(ThumbnailPanel.this.selected ? "Table.focusCellForeground" : defColor);
            }
        }
    }

    private static class RenderingEngines {
        public final RenderingEngine<CyNetwork> networkEngine;
        public final Optional<RenderingEngineFactory<CyNetwork>> thumbnailEngineFactory;

        public RenderingEngines(RenderingEngine<CyNetwork> networkEngine, RenderingEngineFactory<CyNetwork> thumbnailEngineFactory) {
            this.networkEngine = networkEngine;
            this.thumbnailEngineFactory = Optional.ofNullable(thumbnailEngineFactory);
        }
    }

    private class GridPanel
    extends JPanel
    implements Scrollable {
        private GridPanel() {
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 10;
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return (orientation == 1 ? visibleRect.height : visibleRect.width) - 10;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return NetworkViewGrid.this.thumbnailPanels == null || NetworkViewGrid.this.thumbnailPanels.isEmpty();
        }
    }

    private class KeyAction
    extends AbstractAction {
        static final String VK_LEFT = "VK_LEFT";
        static final String VK_RIGHT = "VK_RIGHT";
        static final String VK_UP = "VK_UP";
        static final String VK_DOWN = "VK_DOWN";
        static final String VK_SHIFT_LEFT = "VK_SHIFT_LEFT";
        static final String VK_SHIFT_RIGHT = "VK_SHIFT_RIGHT";
        static final String VK_SHIFT_UP = "VK_SHIFT_UP";
        static final String VK_SHIFT_DOWN = "VK_SHIFT_DOWN";
        static final String VK_CTRL_A = "VK_CTRL_A";
        static final String VK_CTRL_SHIFT_A = "VK_CTRL_SHIFT_A";

        KeyAction(String actionCommand) {
            this.putValue("ActionCommandKey", actionCommand);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int idx;
            Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (focusOwner instanceof JTextComponent || focusOwner instanceof JTable || !NetworkViewGrid.this.isVisible() || NetworkViewGrid.this.isEmpty()) {
                return;
            }
            String cmd = e.getActionCommand();
            boolean shift = cmd.startsWith("VK_SHIFT_");
            int size = NetworkViewGrid.this.thumbnailPanels.size();
            int newIdx = idx = NetworkViewGrid.this.selectionModel.getLeadSelectionIndex();
            if (cmd.equals(VK_RIGHT) || cmd.equals(VK_SHIFT_RIGHT)) {
                newIdx = idx + 1;
            } else if (cmd.equals(VK_LEFT) || cmd.equals(VK_SHIFT_LEFT)) {
                newIdx = idx - 1;
            } else if (cmd.equals(VK_UP) || cmd.equals(VK_SHIFT_UP)) {
                newIdx = idx - NetworkViewGrid.this.cols < 0 ? idx : idx - NetworkViewGrid.this.cols;
            } else if (cmd.equals(VK_DOWN) || cmd.equals(VK_SHIFT_DOWN)) {
                boolean sameRow = Math.ceil((double)size / (double)NetworkViewGrid.this.cols) == Math.ceil((double)(idx + 1) / (double)NetworkViewGrid.this.cols);
                newIdx = sameRow ? idx : Math.min(size - 1, idx + NetworkViewGrid.this.cols);
            } else if (cmd.equals(VK_CTRL_A)) {
                NetworkViewGrid.this.selectAll();
            } else if (cmd.equals(VK_CTRL_SHIFT_A)) {
                NetworkViewGrid.this.deselectAll();
            }
            if (newIdx != idx) {
                if (shift) {
                    NetworkViewGrid.this.shiftSelectTo(newIdx);
                } else {
                    NetworkViewGrid.this.setSelectedIndex(newIdx);
                }
            }
        }
    }
}

