/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal.view;

import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Properties;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.JToolBar;
import org.cytoscape.internal.view.NetworkViewContainer;
import org.cytoscape.internal.view.util.ViewUtil;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.property.CyProperty;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.presentation.RenderingEngine;

public class NetworkViewFrame
extends JFrame {
    private final JToolBar toolBar;
    private final NetworkViewContainer networkViewContainer;
    private final JRootPane containerRootPane;
    private final CyServiceRegistrar serviceRegistrar;

    public NetworkViewFrame(NetworkViewContainer vc, GraphicsConfiguration gc, JToolBar toolBar, CyServiceRegistrar serviceRegistrar) {
        super(ViewUtil.getTitle(vc.getNetworkView()), gc);
        this.toolBar = toolBar;
        this.networkViewContainer = vc;
        this.serviceRegistrar = serviceRegistrar;
        this.containerRootPane = vc.getRootPane();
        this.init();
    }

    private void init() {
        this.setName("Frame." + this.networkViewContainer.getName());
        this.setDefaultCloseOperation(2);
        this.networkViewContainer.setRootPane(new JRootPane());
        this.getContentPane().add((Component)this.containerRootPane, "Center");
        if (this.toolBar != null) {
            this.toolBar.setFloatable(false);
            Properties props = (Properties)((CyProperty)this.serviceRegistrar.getService(CyProperty.class, "(cyPropertyName=cytoscape3.props)")).getProperties();
            this.setToolBarVisible(props.getProperty("showDetachedViewToolBars", "true").equalsIgnoreCase("true"));
            this.getContentPane().add((Component)this.toolBar, "North");
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                NetworkViewFrame.this.networkViewContainer.update(true, true);
                NetworkViewFrame.this.networkViewContainer.updateViewSize();
            }
        });
        this.update();
    }

    public JToolBar getToolBar() {
        return this.toolBar;
    }

    public void setToolBarVisible(boolean b) {
        this.getToolBar().setVisible(b);
    }

    protected NetworkViewContainer getNetworkViewContainer() {
        return this.networkViewContainer;
    }

    protected JRootPane getContainerRootPane() {
        return this.containerRootPane;
    }

    protected RenderingEngine<CyNetwork> getRenderingEngine() {
        return this.networkViewContainer.getRenderingEngine();
    }

    public CyNetworkView getNetworkView() {
        return this.networkViewContainer.getNetworkView();
    }

    public void update() {
        this.getNetworkViewContainer().update(true, true);
    }

    @Override
    public void dispose() {
        this.getContentPane().removeAll();
        this.remove(this.getRootPane());
        super.dispose();
        this.networkViewContainer.setRootPane(this.containerRootPane);
    }

    @Override
    public String toString() {
        return "NetworkViewFrame: " + this.getNetworkView();
    }
}

