/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolTip;
import javax.swing.LayoutStyle;
import javax.swing.Timer;
import javax.swing.UIManager;
import org.cytoscape.internal.model.SelectionMode;
import org.cytoscape.internal.util.SimpleToolBarToggleButton;
import org.cytoscape.internal.util.Util;
import org.cytoscape.internal.view.BirdsEyeViewPanel;
import org.cytoscape.internal.view.GridViewToggleModel;
import org.cytoscape.internal.view.GridViewTogglePanel;
import org.cytoscape.internal.view.SimpleRootPaneContainer;
import org.cytoscape.internal.view.util.ViewUtil;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.CyToolTip;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewSnapshot;
import org.cytoscape.view.model.Range;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.VisualLexicon;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.presentation.RenderingEngine;
import org.cytoscape.view.presentation.RenderingEngineFactory;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;

public class NetworkViewContainer
extends SimpleRootPaneContainer {
    private final CyNetworkView networkView;
    private final RenderingEngine<CyNetwork> renderingEngine;
    private final RenderingEngineFactory<CyNetwork> thumbnailEngineFactory;
    private final VisualLexicon lexicon;
    private VisRootPaneContainer visualizationContainer;
    private JPanel toolBar;
    private JButton detachViewButton;
    private JButton reattachViewButton;
    private JButton exportButton;
    private JLabel currentLabel;
    private JLabel viewTitleLabel;
    private JTextField viewTitleTextField;
    private Set<SelectionModeButton> selectionModeButtons = new LinkedHashSet<SelectionModeButton>();
    private JPanel selectionModePanel;
    private JPanel infoPanel;
    private JLabel selectionIconLabel;
    private JLabel hiddenIconLabel;
    private JLabel nodeSelectionLabel;
    private JLabel edgeSelectionLabel;
    private JLabel nodeHiddenLabel;
    private JLabel edgeHiddenLabel;
    private JToggleButton graphicsDetailButton;
    private JToggleButton birdsEyeViewButton;
    private BirdsEyeViewPanel birdsEyeViewPanel;
    private final GridViewTogglePanel gridViewTogglePanel;
    final JSeparator sep1 = ViewUtil.createToolBarSeparator();
    final JSeparator sep2 = ViewUtil.createToolBarSeparator();
    final JSeparator sep3 = ViewUtil.createToolBarSeparator();
    final JSeparator sep4 = ViewUtil.createToolBarSeparator();
    final JSeparator sep5 = ViewUtil.createToolBarSeparator();
    final JSeparator sep6 = ViewUtil.createToolBarSeparator();
    private boolean detached;
    private boolean comparing;
    private boolean current;
    private Timer resizeTimer;
    private final CyServiceRegistrar serviceRegistrar;

    public NetworkViewContainer(CyNetworkView networkView, boolean current, RenderingEngineFactory<CyNetwork> engineFactory, RenderingEngineFactory<CyNetwork> thumbnailFactory, GridViewToggleModel gridViewToggleModel, CyServiceRegistrar serviceRegistrar) {
        this.networkView = networkView;
        this.lexicon = engineFactory.getVisualLexicon();
        this.current = current;
        this.gridViewTogglePanel = new GridViewTogglePanel(gridViewToggleModel, serviceRegistrar);
        this.serviceRegistrar = serviceRegistrar;
        this.setName(ViewUtil.createUniqueKey(networkView));
        this.init();
        this.renderingEngine = engineFactory.createRenderingEngine((Object)this.getVisualizationContainer(), (View)networkView);
        this.thumbnailEngineFactory = thumbnailFactory;
    }

    public boolean isDetached() {
        return this.detached;
    }

    public void setDetached(boolean detached) {
        this.detached = detached;
        if (detached) {
            this.comparing = false;
        }
    }

    public boolean isComparing() {
        return this.comparing;
    }

    public void setComparing(boolean comparing) {
        if (this.comparing == comparing) {
            return;
        }
        this.comparing = comparing;
        if (comparing) {
            this.detached = false;
            this.hideBirdsEyePanel();
        }
    }

    public void hideBirdsEyePanel() {
        if (this.getBirdsEyeViewPanel().isVisible()) {
            this.getBirdsEyeViewButton().doClick();
        }
    }

    public boolean isCurrent() {
        return this.current;
    }

    public void setCurrent(boolean newValue) {
        if (this.current != newValue) {
            boolean oldValue = this.current;
            this.current = newValue;
            this.updateCurrentLabel();
            this.firePropertyChange("current", oldValue, newValue);
        }
    }

    public void update(boolean updateSelectionInfo, boolean updateHiddenInfo) {
        this.getVisualizationContainer().repaint();
        this.updateTollBar(updateSelectionInfo, updateHiddenInfo);
        if (this.isVisible() && this.getBirdsEyeViewPanel().isVisible()) {
            this.updateBirdsEyeViewPanel();
        }
    }

    protected void updateTollBar(boolean updateSelectionInfo, boolean updateHiddenInfo) {
        this.gridViewTogglePanel.setVisible(!this.isDetached() && !this.isComparing());
        this.getDetachViewButton().setVisible(!this.isDetached() && !this.isComparing());
        this.getReattachViewButton().setVisible(this.isDetached());
        this.getExportButton().setVisible(!this.isComparing());
        this.getGraphicsDetailButton().setVisible(!this.isComparing() && Util.isVisualPropertySupported("NETWORK_FORCE_HIGH_DETAIL", CyNetwork.class, this.networkView, this.serviceRegistrar));
        this.getSelectionModePanel().setVisible(!this.isComparing() && !this.selectionModeButtons.isEmpty());
        this.getInfoPanel().setVisible(!this.isComparing());
        this.getCurrentLabel().setVisible(this.isComparing());
        CyNetworkView view = this.getNetworkView();
        this.getViewTitleLabel().setText(view != null ? ViewUtil.getTitle(view) : "");
        this.getViewTitleLabel().setToolTipText(view != null ? ViewUtil.getTitle(view) : null);
        ViewUtil.updateToolBarStyle(this.getGraphicsDetailButton());
        if (this.getSelectionModePanel().isVisible()) {
            this.updateSelectionModePanel();
        }
        if (updateSelectionInfo) {
            this.updateSelectionInfo();
        }
        if (updateHiddenInfo) {
            this.updateHiddenInfo();
        }
        if (this.isComparing()) {
            this.updateCurrentLabel();
        }
        if (this.getGraphicsDetailButton().isVisible()) {
            this.updateHighDetailButton();
        }
        this.sanitizeToolBar();
        this.updateBirdsEyeButton();
        this.getToolBar().updateUI();
        this.updateBirdsEyeViewPanel();
    }

    private void updateHighDetailButton() {
        boolean hd = Boolean.TRUE.equals(Util.getVisualProperty("NETWORK_FORCE_HIGH_DETAIL", CyNetwork.class, this.networkView, this.serviceRegistrar));
        this.getGraphicsDetailButton().setSelected(hd);
    }

    private void updateSelectionModePanel() {
        this.selectionModeButtons.forEach(btn -> {
            boolean selected = (Boolean)this.networkView.getVisualProperty(btn.getVisualProperty());
            btn.setSelected(selected);
        });
    }

    protected void updateSelectionInfo() {
        CyNetworkView view = this.getNetworkView();
        if (this.getInfoPanel().isVisible() && !Util.isDisposed(view)) {
            int sn = ((CyNetwork)view.getModel()).getDefaultNodeTable().countMatchingRows("selected", (Object)Boolean.TRUE);
            int se = ((CyNetwork)view.getModel()).getDefaultEdgeTable().countMatchingRows("selected", (Object)Boolean.TRUE);
            this.getNodeSelectionLabel().setText("" + sn);
            this.getEdgeSelectionLabel().setText("" + se);
            String sTooltip = NetworkViewContainer.createInfoToolTipText(sn, se, "selected");
            this.getSelectionIconLabel().setToolTipText(sTooltip);
            this.getNodeSelectionLabel().setToolTipText(sTooltip);
        }
    }

    protected void updateHiddenInfo() {
        CyNetworkView view = this.getNetworkView();
        String HIDDEN_NODES = "HIDDEN_NODES";
        String HIDDEN_EDGES = "HIDDEN_EDGES";
        if (this.getInfoPanel().isVisible() && !Util.isDisposed(view)) {
            int he;
            int hn;
            if (view.supportsSnapshots()) {
                CyNetworkViewSnapshot snapshot = view.createSnapshot();
                if (snapshot != null && snapshot.isTrackedNodeKey((Object)HIDDEN_NODES) && snapshot.isTrackedEdgeKey((Object)HIDDEN_EDGES)) {
                    hn = snapshot.getTrackedNodeCount((Object)HIDDEN_NODES);
                    he = snapshot.getTrackedEdgeCount((Object)HIDDEN_EDGES);
                } else {
                    hn = ViewUtil.getHiddenNodeCount(view);
                    he = ViewUtil.getHiddenEdgeCount(view);
                }
            } else {
                hn = ViewUtil.getHiddenNodeCount(view);
                he = ViewUtil.getHiddenEdgeCount(view);
            }
            this.getNodeHiddenLabel().setText("" + hn);
            this.getEdgeHiddenLabel().setText("" + he);
            String hTooltip = NetworkViewContainer.createInfoToolTipText(hn, he, "hidden");
            this.getHiddenIconLabel().setToolTipText(hTooltip);
            this.getNodeHiddenLabel().setToolTipText(hTooltip);
        }
    }

    protected void updateCurrentLabel() {
        this.getCurrentLabel().setForeground(this.isCurrent() ? UIManager.getColor("Focus.color") : new Color(0, 0, 0, 0));
        this.getCurrentLabel().setToolTipText(this.isCurrent() ? "Current Network" : null);
    }

    private void updateBirdsEyeButton() {
        boolean bevVisible = this.getBirdsEyeViewPanel().isVisible();
        this.getBirdsEyeViewButton().setToolTipText((bevVisible ? "Hide" : "Show") + " Navigator");
        ViewUtil.updateToolBarStyle(this.getBirdsEyeViewButton());
    }

    private void updateBirdsEyeViewPanel() {
        int cw = this.getVisualizationContainer().getWidth();
        int ch = this.getVisualizationContainer().getHeight();
        if (cw > 0 && ch > 0) {
            int w = Math.min(200, cw);
            int h = Math.min(200, ch);
            if (w > 0 && h > 0) {
                int x = cw - w;
                int y = ch - h;
                this.getBirdsEyeViewPanel().setBounds(x, y, w, h);
                this.getBirdsEyeViewPanel().update();
            }
        }
    }

    void updateViewSize() {
        if (this.isVisible() && this.getBirdsEyeViewPanel().isVisible()) {
            this.updateBirdsEyeViewPanel();
        }
        this.resizeTimer.stop();
        this.resizeTimer.setInitialDelay(100);
        this.resizeTimer.start();
    }

    void dispose() {
        this.getRootPane().getLayeredPane().removeAll();
        this.getRootPane().getContentPane().removeAll();
        this.getBirdsEyeViewPanel().dispose();
        this.gridViewTogglePanel.dispose();
    }

    private void init() {
        this.setFocusable(true);
        this.setRequestFocusEnabled(true);
        this.createSelectionModeButtons();
        JPanel glassPane = new JPanel(null);
        this.getRootPane().setGlassPane(glassPane);
        glassPane.setOpaque(false);
        glassPane.setVisible(true);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.getVisualizationContainer(), "Center");
        this.getContentPane().add((Component)this.getToolBar(), "South");
        this.updateTollBar(true, true);
        this.updateBirdsEyeViewPanel();
        glassPane.add(this.getBirdsEyeViewPanel());
        this.resizeTimer = new Timer(0, new ResizeActionListener());
        this.resizeTimer.setRepeats(false);
        this.resizeTimer.setCoalesce(true);
        this.resizeTimer.start();
    }

    private void createSelectionModeButtons() {
        for (SelectionMode mode : SelectionMode.values()) {
            Range range;
            VisualProperty vp = this.lexicon.lookup(CyNetwork.class, mode.getPropertyId());
            if (vp == null || !this.lexicon.isSupported(vp) || (range = vp.getRange()) != null && range.getType() != Boolean.class) continue;
            SelectionModeButton btn = new SelectionModeButton((VisualProperty<Boolean>)vp, mode);
            this.selectionModeButtons.add(btn);
            btn.addActionListener(evt -> {
                boolean selected = btn.isSelected();
                this.networkView.batch(nv -> nv.setLockedValue(vp, (Object)selected), false);
            });
        }
    }

    protected RenderingEngine<CyNetwork> getRenderingEngine() {
        return this.renderingEngine;
    }

    protected RenderingEngineFactory<CyNetwork> getThumbnailEngineFactory() {
        return this.thumbnailEngineFactory;
    }

    protected CyNetworkView getNetworkView() {
        return this.networkView;
    }

    protected VisRootPaneContainer getVisualizationContainer() {
        if (this.visualizationContainer == null) {
            this.visualizationContainer = new VisRootPaneContainer();
        }
        return this.visualizationContainer;
    }

    JPanel getToolBar() {
        if (this.toolBar == null) {
            this.toolBar = new JPanel();
            this.toolBar.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, UIManager.getColor("Separator.foreground")));
            GroupLayout layout = new GroupLayout(this.toolBar);
            this.toolBar.setLayout(layout);
            layout.setAutoCreateContainerGaps(false);
            layout.setAutoCreateGaps(false);
            layout.setHorizontalGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.gridViewTogglePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sep1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.getDetachViewButton(), -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.getReattachViewButton(), -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sep2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.getCurrentLabel(), -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.getViewTitleLabel()).addComponent(this.getViewTitleTextField(), 100, 260, 320).addGap(0, 10, Short.MAX_VALUE).addComponent(this.sep3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.getExportButton(), -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sep4, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.getGraphicsDetailButton(), -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.getSelectionModePanel(), -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sep5, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.getInfoPanel(), -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sep6, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.getBirdsEyeViewButton(), -2, -1, -2).addContainerGap());
            layout.setVerticalGroup(layout.createSequentialGroup().addGap(1).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.gridViewTogglePanel, -2, -1, -2).addComponent(this.sep1, -1, -1, Short.MAX_VALUE).addComponent(this.getDetachViewButton(), -2, -1, -2).addComponent(this.getReattachViewButton(), -2, -1, -2).addComponent(this.sep2, -1, -1, Short.MAX_VALUE).addComponent(this.getCurrentLabel(), -2, -1, -2).addComponent(this.getViewTitleLabel(), -2, -1, -2).addComponent(this.getViewTitleTextField(), -2, -1, -2).addComponent(this.sep3, -1, -1, Short.MAX_VALUE).addComponent(this.getExportButton(), -2, -1, -2).addComponent(this.sep4, -1, -1, Short.MAX_VALUE).addComponent(this.getGraphicsDetailButton(), -2, -1, -2).addComponent(this.getSelectionModePanel(), -2, -1, -2).addComponent(this.sep5, -1, -1, Short.MAX_VALUE).addComponent(this.getInfoPanel(), -2, -1, -2).addComponent(this.sep6, -1, -1, Short.MAX_VALUE).addComponent(this.getBirdsEyeViewButton(), -2, -1, -2)).addGap(1));
            HashSet<SelectionModeButton> allButtons = new HashSet<SelectionModeButton>(this.selectionModeButtons);
            allButtons.add((SelectionModeButton)((Object)this.getDetachViewButton()));
            allButtons.add((SelectionModeButton)((Object)this.getReattachViewButton()));
            allButtons.add((SelectionModeButton)((Object)this.getExportButton()));
            allButtons.add((SelectionModeButton)this.getGraphicsDetailButton());
            allButtons.add((SelectionModeButton)this.getBirdsEyeViewButton());
            LookAndFeelUtil.equalizeSize((JComponent[])allButtons.toArray(new JComponent[allButtons.size()]));
        }
        return this.toolBar;
    }

    JButton getDetachViewButton() {
        if (this.detachViewButton == null) {
            this.detachViewButton = new JButton("\uf14c");
            this.detachViewButton.setToolTipText("Detach View");
            ViewUtil.styleToolBarButton((AbstractButton)this.detachViewButton, ((IconManager)this.serviceRegistrar.getService(IconManager.class)).getIconFont(22.0f));
        }
        return this.detachViewButton;
    }

    JButton getReattachViewButton() {
        if (this.reattachViewButton == null) {
            this.reattachViewButton = new JButton("'");
            this.reattachViewButton.setToolTipText("Reattach View");
            ViewUtil.styleToolBarButton((AbstractButton)this.reattachViewButton, ((IconManager)this.serviceRegistrar.getService(IconManager.class)).getIconFont("cytoscape-3", 16.0f));
        }
        return this.reattachViewButton;
    }

    JButton getExportButton() {
        if (this.exportButton == null) {
            this.exportButton = new JButton("+");
            this.exportButton.setToolTipText("Export to File...");
            ViewUtil.styleToolBarButton((AbstractButton)this.exportButton, ((IconManager)this.serviceRegistrar.getService(IconManager.class)).getIconFont("cytoscape-3", 22.0f));
        }
        return this.exportButton;
    }

    JLabel getCurrentLabel() {
        if (this.currentLabel == null) {
            this.currentLabel = new JLabel("\uf111");
            this.currentLabel.setFont(((IconManager)this.serviceRegistrar.getService(IconManager.class)).getIconFont(10.0f));
            this.currentLabel.setMinimumSize(this.currentLabel.getPreferredSize());
            this.currentLabel.setMaximumSize(this.currentLabel.getPreferredSize());
            this.currentLabel.setSize(this.currentLabel.getPreferredSize());
            this.currentLabel.setForeground(UIManager.getColor("Focus.color"));
        }
        return this.currentLabel;
    }

    JLabel getViewTitleLabel() {
        if (this.viewTitleLabel == null) {
            this.viewTitleLabel = new JLabel();
            this.viewTitleLabel.setFont(this.viewTitleLabel.getFont().deriveFont(LookAndFeelUtil.getSmallFontSize()));
            this.viewTitleLabel.setMinimumSize(new Dimension(this.viewTitleLabel.getPreferredSize().width, this.getViewTitleTextField().getPreferredSize().height));
        }
        return this.viewTitleLabel;
    }

    JTextField getViewTitleTextField() {
        if (this.viewTitleTextField == null) {
            this.viewTitleTextField = new JTextField();
            this.viewTitleTextField.putClientProperty("JComponent.sizeVariant", "mini");
            this.viewTitleTextField.setVisible(false);
        }
        return this.viewTitleTextField;
    }

    private JPanel getSelectionModePanel() {
        if (this.selectionModePanel == null) {
            this.selectionModePanel = new JPanel();
            if (LookAndFeelUtil.isAquaLAF()) {
                this.selectionModePanel.setOpaque(false);
            }
            if (this.selectionModeButtons.isEmpty()) {
                this.selectionModePanel.setPreferredSize(new Dimension());
                this.selectionModePanel.setVisible(false);
            } else {
                GroupLayout layout = new GroupLayout(this.selectionModePanel);
                this.selectionModePanel.setLayout(layout);
                layout.setAutoCreateContainerGaps(false);
                layout.setAutoCreateGaps(false);
                GroupLayout.SequentialGroup hGroup = layout.createSequentialGroup();
                GroupLayout.ParallelGroup vGroup = layout.createParallelGroup(GroupLayout.Alignment.CENTER, false);
                layout.setHorizontalGroup(hGroup);
                layout.setVerticalGroup(vGroup);
                this.selectionModeButtons.forEach(btn -> {
                    hGroup.addComponent((Component)btn, -2, -1, -2);
                    vGroup.addComponent((Component)btn, -2, -1, -2);
                });
            }
        }
        return this.selectionModePanel;
    }

    private JPanel getInfoPanel() {
        if (this.infoPanel == null) {
            this.infoPanel = new JPanel();
            if (LookAndFeelUtil.isAquaLAF()) {
                this.infoPanel.setOpaque(false);
            }
            JSeparator sep = ViewUtil.createToolBarSeparator();
            LookAndFeelUtil.equalizeSize((JComponent[])new JComponent[]{this.getSelectionIconLabel(), this.getHiddenIconLabel()});
            int lw = 50;
            int gap = 4;
            GroupLayout layout = new GroupLayout(this.infoPanel);
            this.infoPanel.setLayout(layout);
            layout.setAutoCreateContainerGaps(false);
            layout.setAutoCreateGaps(false);
            layout.setHorizontalGroup(layout.createSequentialGroup().addComponent(this.getSelectionIconLabel(), -2, -1, -2).addGap(4).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, true).addComponent(this.getNodeSelectionLabel(), 50, 50, Short.MAX_VALUE).addComponent(this.getEdgeSelectionLabel(), 50, 50, Short.MAX_VALUE)).addGap(4).addComponent(sep, -2, -1, -2).addGap(4).addComponent(this.getHiddenIconLabel(), -2, -1, -2).addGap(4).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, true).addComponent(this.getNodeHiddenLabel(), 50, 50, Short.MAX_VALUE).addComponent(this.getEdgeHiddenLabel(), 50, 50, Short.MAX_VALUE)));
            layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.getSelectionIconLabel(), -2, -1, -2).addGroup(layout.createSequentialGroup().addComponent(this.getNodeSelectionLabel(), -1, -1, Short.MAX_VALUE).addComponent(this.getEdgeSelectionLabel(), -1, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGap(4).addComponent(sep, -1, -1, Short.MAX_VALUE).addGap(4)).addComponent(this.getHiddenIconLabel(), -2, -1, -2).addGroup(layout.createSequentialGroup().addComponent(this.getNodeHiddenLabel(), -1, -1, Short.MAX_VALUE).addComponent(this.getEdgeHiddenLabel(), -1, -1, Short.MAX_VALUE)));
        }
        return this.infoPanel;
    }

    private JLabel getSelectionIconLabel() {
        if (this.selectionIconLabel == null) {
            this.selectionIconLabel = new JLabel("\uf14a");
            this.selectionIconLabel.setFont(((IconManager)this.serviceRegistrar.getService(IconManager.class)).getIconFont(10.0f));
            this.selectionIconLabel.setForeground(UIManager.getColor("Label.infoForeground"));
        }
        return this.selectionIconLabel;
    }

    private JLabel getHiddenIconLabel() {
        if (this.hiddenIconLabel == null) {
            this.hiddenIconLabel = new JLabel("\uf070");
            this.hiddenIconLabel.setFont(((IconManager)this.serviceRegistrar.getService(IconManager.class)).getIconFont(12.0f));
            this.hiddenIconLabel.setForeground(UIManager.getColor("Label.infoForeground"));
        }
        return this.hiddenIconLabel;
    }

    private JLabel getNodeSelectionLabel() {
        if (this.nodeSelectionLabel == null) {
            this.nodeSelectionLabel = new JLabel();
            this.nodeSelectionLabel.setHorizontalAlignment(4);
            this.nodeSelectionLabel.setFont(this.nodeSelectionLabel.getFont().deriveFont(LookAndFeelUtil.getSmallFontSize()));
            this.nodeSelectionLabel.setForeground(UIManager.getColor("Label.infoForeground"));
        }
        return this.nodeSelectionLabel;
    }

    private JLabel getEdgeSelectionLabel() {
        if (this.edgeSelectionLabel == null) {
            this.edgeSelectionLabel = new JLabel();
            this.edgeSelectionLabel.setHorizontalAlignment(4);
            this.edgeSelectionLabel.setFont(this.edgeSelectionLabel.getFont().deriveFont(LookAndFeelUtil.getSmallFontSize()));
            this.edgeSelectionLabel.setForeground(UIManager.getColor("Label.infoForeground"));
        }
        return this.edgeSelectionLabel;
    }

    private JLabel getNodeHiddenLabel() {
        if (this.nodeHiddenLabel == null) {
            this.nodeHiddenLabel = new JLabel();
            this.nodeHiddenLabel.setHorizontalAlignment(4);
            this.nodeHiddenLabel.setFont(this.nodeHiddenLabel.getFont().deriveFont(LookAndFeelUtil.getSmallFontSize()));
            this.nodeHiddenLabel.setForeground(UIManager.getColor("Label.infoForeground"));
        }
        return this.nodeHiddenLabel;
    }

    private JLabel getEdgeHiddenLabel() {
        if (this.edgeHiddenLabel == null) {
            this.edgeHiddenLabel = new JLabel();
            this.edgeHiddenLabel.setHorizontalAlignment(4);
            this.edgeHiddenLabel.setFont(this.edgeHiddenLabel.getFont().deriveFont(LookAndFeelUtil.getSmallFontSize()));
            this.edgeHiddenLabel.setForeground(UIManager.getColor("Label.infoForeground"));
        }
        return this.edgeHiddenLabel;
    }

    JToggleButton getGraphicsDetailButton() {
        if (this.graphicsDetailButton == null) {
            this.graphicsDetailButton = new SimpleToolBarToggleButton("&");
            this.graphicsDetailButton.setToolTipText("Always Show Graphics Details");
            ViewUtil.styleToolBarButton((AbstractButton)this.graphicsDetailButton, ((IconManager)this.serviceRegistrar.getService(IconManager.class)).getIconFont("cytoscape-3", 20.0f));
            this.graphicsDetailButton.addActionListener(evt -> Util.setLockedValue("NETWORK_FORCE_HIGH_DETAIL", CyNetwork.class, this.graphicsDetailButton.isSelected(), this.networkView, this.serviceRegistrar));
            this.graphicsDetailButton.addItemListener(evt -> this.getGraphicsDetailButton().setText(this.graphicsDetailButton.isSelected() ? "$" : "&"));
        }
        return this.graphicsDetailButton;
    }

    JToggleButton getBirdsEyeViewButton() {
        if (this.birdsEyeViewButton == null) {
            this.birdsEyeViewButton = new JToggleButton("\uf05b", this.getBirdsEyeViewPanel().isVisible());
            ViewUtil.styleToolBarButton((AbstractButton)this.birdsEyeViewButton, ((IconManager)this.serviceRegistrar.getService(IconManager.class)).getIconFont(20.0f));
            this.birdsEyeViewButton.addActionListener(evt -> {
                this.getBirdsEyeViewPanel().setVisible(!this.getBirdsEyeViewPanel().isVisible());
                this.updateBirdsEyeButton();
                if (this.getBirdsEyeViewPanel().isVisible()) {
                    this.updateBirdsEyeViewPanel();
                }
            });
        }
        return this.birdsEyeViewButton;
    }

    BirdsEyeViewPanel getBirdsEyeViewPanel() {
        if (this.birdsEyeViewPanel == null) {
            this.birdsEyeViewPanel = new BirdsEyeViewPanel(this.getNetworkView(), this.serviceRegistrar);
            this.birdsEyeViewPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 1, 0, 0, UIManager.getColor("Table.background")), BorderFactory.createMatteBorder(1, 1, 1, 1, UIManager.getColor("Focus.color"))));
            this.birdsEyeViewPanel.setFocusable(true);
            this.birdsEyeViewPanel.setRequestFocusEnabled(true);
            this.birdsEyeViewPanel.setVisible(false);
        }
        return this.birdsEyeViewPanel;
    }

    private void showViewTitleEditor() {
        this.getViewTitleTextField().setText(this.getViewTitleLabel().getText());
        this.getViewTitleLabel().setVisible(false);
        this.getViewTitleTextField().setVisible(true);
        this.getViewTitleTextField().requestFocusInWindow();
    }

    @Override
    public String toString() {
        return this.networkView.toString();
    }

    private static String createInfoToolTipText(int nodes, int edges, String adjective) {
        Object tooltip = "<html>";
        if (nodes > 0 || edges > 0) {
            if (nodes > 0) {
                tooltip = (String)tooltip + "<b>" + nodes + "</b> " + adjective + " node" + (nodes > 1 ? "s" : "");
            }
            if (edges > 0) {
                tooltip = (String)tooltip + (nodes > 0 ? "<br>" : "") + "<b>" + edges + "</b> " + adjective + " edge" + (edges > 1 ? "s" : "");
            }
        } else {
            tooltip = (String)tooltip + "No " + adjective + " nodes or edges";
        }
        tooltip = (String)tooltip + "</html>";
        return tooltip;
    }

    public void sanitizeToolBar() {
        JPanel toolBar = this.getToolBar();
        boolean hasSeparator = false;
        int visibleCount = 0;
        for (int i = 0; i < toolBar.getComponentCount(); ++i) {
            Component comp = toolBar.getComponent(i);
            if (comp instanceof JSeparator) {
                if (hasSeparator || visibleCount == 0 || this.isComparing()) {
                    comp.setVisible(false);
                } else {
                    comp.setVisible(true);
                    hasSeparator = true;
                }
            } else if (comp.isVisible()) {
                hasSeparator = false;
            }
            if (!comp.isVisible()) continue;
            ++visibleCount;
        }
    }

    protected final class VisRootPaneContainer
    extends SimpleRootPaneContainer {
        protected VisRootPaneContainer() {
        }

        @Override
        protected JRootPane createDefaultRootPane() {
            return new VisRootPane();
        }
    }

    private class ResizeActionListener
    implements ActionListener {
        private ResizeActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean updated = false;
            Container c = NetworkViewContainer.this.getVisualizationContainer().getContentPane();
            if (c.getWidth() > 0) {
                NetworkViewContainer.this.networkView.setVisualProperty(BasicVisualLexicon.NETWORK_WIDTH, (Object)c.getWidth());
                updated = true;
            }
            if (c.getHeight() > 0) {
                NetworkViewContainer.this.networkView.setVisualProperty(BasicVisualLexicon.NETWORK_HEIGHT, (Object)c.getHeight());
                updated = true;
            }
            if (updated) {
                NetworkViewContainer.this.networkView.updateView();
            }
            NetworkViewContainer.this.resizeTimer.stop();
        }
    }

    private final class SelectionModeButton
    extends SimpleToolBarToggleButton {
        private static final int ICON_SIZE = 18;
        private final ImageIcon tipIcon;
        private final SelectionMode mode;
        private final VisualProperty<Boolean> visualProperty;

        public SelectionModeButton(VisualProperty<Boolean> vp, SelectionMode mode) {
            super("", (Boolean)NetworkViewContainer.this.networkView.getVisualProperty(vp));
            this.visualProperty = vp;
            this.mode = mode;
            IconManager iconManager = (IconManager)NetworkViewContainer.this.serviceRegistrar.getService(IconManager.class);
            Font iconFont = iconManager.getIconFont("cytoscape-3", 20.0f);
            URL tipImgUrl = mode.getToolTipImage() == null ? null : Util.getURL(this.getClass().getResource(mode.getToolTipImage()).toString());
            this.tipIcon = tipImgUrl == null ? null : new ImageIcon(tipImgUrl);
            this.init();
        }

        @Override
        public JToolTip createToolTip() {
            return new CyToolTip((JComponent)this, this.mode != null ? this.mode.getText() : null, this.mode != null ? this.mode.getToolTipText() : null, (Icon)this.tipIcon);
        }

        public SelectionMode getMode() {
            return this.mode;
        }

        public VisualProperty<Boolean> getVisualProperty() {
            return this.visualProperty;
        }

        private void init() {
            this.setText(this.mode.getIconText());
            this.setToolTipText(this.mode.getText());
            IconManager iconManager = (IconManager)NetworkViewContainer.this.serviceRegistrar.getService(IconManager.class);
            Font font = iconManager.getIconFont("cytoscape-3", 20.0f);
            ViewUtil.styleToolBarButton((AbstractButton)this, font);
            this.update();
        }
    }

    private final class VisRootPane
    extends JRootPane {
        private VisRootPane() {
        }

        @Override
        protected LayoutManager createRootLayout() {
            return new VisRootLayout();
        }

        protected class VisRootLayout
        extends JRootPane.RootLayout {
            protected VisRootLayout() {
                super(VisRootPane.this);
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = VisRootPane.this.contentPane != null ? VisRootPane.this.contentPane.getWidth() : 0;
                int h = VisRootPane.this.contentPane != null ? VisRootPane.this.contentPane.getHeight() : 0;
                super.layoutContainer(parent);
                if (VisRootPane.this.contentPane != null && (VisRootPane.this.contentPane.getWidth() != w || VisRootPane.this.contentPane.getHeight() != h)) {
                    NetworkViewContainer.this.updateViewSize();
                }
            }
        }
    }
}

