/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.net.URL;
import java.text.Collator;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import org.cytoscape.application.swing.search.NetworkSearchTaskFactory;
import org.cytoscape.internal.util.RandomImage;
import org.cytoscape.internal.view.util.ViewUtil;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.util.swing.OpenBrowser;

public class NetworkSearchBar
extends JPanel {
    private static final int ICON_SIZE = 32;
    private static final String DEF_SEARCH_TEXT = "Type your query here...";
    private JButton providersButton;
    private JButton providerSelectorButton;
    private JPanel contentPane;
    private JTextField searchTextField;
    private JToggleButton optionsButton;
    private JButton searchButton;
    private JPopupMenu providersPopup;
    private ProvidersPanel providersPanel;
    private OptionsDialog optionsDialog;
    private final EmptyIcon emptyIcon = new EmptyIcon(32, 32);
    private final Map<NetworkSearchTaskFactory, Icon> providerIcons = new HashMap<NetworkSearchTaskFactory, Icon>();
    private final TreeSet<NetworkSearchTaskFactory> providers;
    private NetworkSearchTaskFactory selectedProvider;
    private final CyServiceRegistrar serviceRegistrar;

    public NetworkSearchBar(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
        Collator collator = Collator.getInstance();
        this.providers = new TreeSet((o1, o2) -> collator.compare(o1.getName(), o2.getName()));
        this.init();
    }

    private void setDefaultProvider(NetworkSearchTaskFactory suggestedProvider) {
        String id;
        if (!(suggestedProvider != null && this.providers.contains(suggestedProvider) || (id = ViewUtil.getViewProperty("networkSearch.defaultProvider", this.serviceRegistrar)) == null)) {
            suggestedProvider = this.getProvider(id);
        }
        if (suggestedProvider != null) {
            ViewUtil.setViewProperty("networkSearch.defaultProvider", suggestedProvider.getId(), this.serviceRegistrar);
        }
    }

    private NetworkSearchTaskFactory getDefaultProvider() {
        String id = ViewUtil.getViewProperty("networkSearch.defaultProvider", this.serviceRegistrar);
        return this.getProvider(id);
    }

    public void setSelectedProvider(NetworkSearchTaskFactory newValue) {
        if (newValue != this.selectedProvider) {
            NetworkSearchTaskFactory oldValue = this.getSelectedProvider();
            this.selectedProvider = newValue;
            this.setDefaultProvider(newValue);
            if (newValue != oldValue) {
                this.firePropertyChange("selectedProvider", oldValue, newValue);
            }
        }
    }

    public NetworkSearchTaskFactory getSelectedProvider() {
        if (this.selectedProvider != null) {
            return this.selectedProvider;
        }
        NetworkSearchTaskFactory defProvider = this.getDefaultProvider();
        if (defProvider != null) {
            return defProvider;
        }
        if (!this.providers.isEmpty()) {
            return this.providers.first();
        }
        return null;
    }

    public NetworkSearchTaskFactory getProvider(String id) {
        for (NetworkSearchTaskFactory tf : this.providers) {
            if (!tf.getId().equals(id)) continue;
            return tf;
        }
        return null;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.getProvidersButton().setEnabled(enabled);
        this.getProviderSelectorButton().setEnabled(enabled);
        this.getSearchTextField().setEnabled(enabled);
        this.getOptionsButton().setEnabled(enabled);
        this.getSearchButton().setEnabled(enabled);
    }

    void update(Collection<NetworkSearchTaskFactory> newProviders) {
        NetworkSearchTaskFactory newSelected;
        NetworkSearchTaskFactory oldSelected = this.getSelectedProvider();
        this.providers.clear();
        this.providerIcons.clear();
        if (newProviders != null) {
            this.providers.addAll(newProviders);
            newProviders.forEach(p -> {
                ImageIcon ii;
                Icon icon = p.getIcon();
                if (icon instanceof ImageIcon && ((ii = (ImageIcon)icon).getIconWidth() > 32 || ii.getIconHeight() > 32)) {
                    icon = new ImageIcon(ii.getImage().getScaledInstance(32, 32, 4));
                }
                this.providerIcons.put((NetworkSearchTaskFactory)p, icon != null ? icon : new ImageIcon(new RandomImage(32, 32)));
            });
        }
        if (this.selectedProvider != null && !newProviders.contains(this.selectedProvider)) {
            this.selectedProvider = null;
        }
        if ((newSelected = this.getSelectedProvider()) != oldSelected) {
            this.firePropertyChange("selectedProvider", oldSelected, newSelected);
        }
    }

    void updateProvidersButton() {
        NetworkSearchTaskFactory currentProvider = this.getSelectedProvider();
        if (currentProvider != null) {
            Icon icon = this.providerIcons.get(currentProvider);
            this.getProvidersButton().setIcon(icon != null ? icon : this.emptyIcon);
            this.getProvidersButton().setToolTipText(currentProvider.getName());
        } else {
            this.getProvidersButton().setIcon(this.emptyIcon);
            this.getProvidersButton().setToolTipText("Please select a search provider...");
        }
        this.getProvidersButton().setEnabled(!this.providers.isEmpty());
        this.getProviderSelectorButton().setEnabled(!this.providers.isEmpty());
    }

    void updateSearchEnabled() {
        boolean enabled = this.getSelectedProvider() != null;
        this.getSearchTextField().setEnabled(enabled);
        this.getOptionsButton().setEnabled(enabled);
        this.updateSearchButton();
    }

    void updateSearchButton() {
        NetworkSearchTaskFactory tf = this.getSelectedProvider();
        this.getSearchButton().setEnabled(tf != null && tf.isReady());
    }

    void updateSelectedSearchComponent(JComponent queryComp) {
        this.getContentPane().removeAll();
        if (queryComp == null) {
            queryComp = this.getSearchTextField();
        }
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setAutoCreateContainerGaps(false);
        layout.setAutoCreateGaps(false);
        layout.setHorizontalGroup(layout.createSequentialGroup().addComponent(queryComp, -1, -1, Short.MAX_VALUE).addComponent(this.getOptionsButton(), -2, -1, -2));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, true).addComponent(queryComp, -1, -1, Short.MAX_VALUE).addComponent(this.getOptionsButton(), -1, -1, Short.MAX_VALUE));
    }

    private void showProvidersPopup() {
        if (this.providers.isEmpty()) {
            return;
        }
        if (this.providersPopup != null) {
            this.disposeProvidersPopup(false);
        }
        this.providersPopup = new JPopupMenu();
        this.providersPopup.setBackground(this.getBackground());
        this.providersPopup.setBorder(BorderFactory.createEmptyBorder());
        this.providersPopup.setLayout(new BorderLayout());
        this.providersPopup.add((Component)this.getProvidersPanel(), "Center");
        this.providersPopup.addPropertyChangeListener("visible", evt -> {
            if (Boolean.FALSE.equals(evt.getNewValue())) {
                this.updateProvidersButton();
                this.updateSearchEnabled();
            }
        });
        this.getProvidersPanel().update();
        this.providersPopup.pack();
        this.providersPopup.show(this.getProvidersButton(), 0, this.getProvidersButton().getHeight());
        this.providersPopup.requestFocus();
        this.getProvidersPanel().getTable().requestFocusInWindow();
    }

    private void disposeProvidersPopup(boolean commit) {
        if (this.providersPopup != null) {
            if (commit && this.getProvidersPanel().getSelectedValue() != null) {
                this.setSelectedProvider(this.getProvidersPanel().getSelectedValue());
            }
            this.providersPopup.removeAll();
            this.providersPopup.setVisible(false);
            this.providersPopup = null;
        }
    }

    void showOptionsDialog(JComponent comp) {
        if (comp == null) {
            return;
        }
        this.getOptionsDialog().update(comp);
        Point pt = this.getOptionsButton().getLocationOnScreen();
        this.getOptionsDialog().setLocation(pt.x, pt.y + this.getOptionsButton().getHeight());
        this.getOptionsDialog().pack();
        this.getOptionsDialog().setVisible(true);
        this.getOptionsDialog().requestFocus();
    }

    private void disposeOptionsDialog() {
        this.getOptionsDialog().dispose();
    }

    private void init() {
        this.setBackground(UIManager.getColor("Table.background"));
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, UIManager.getColor("Separator.foreground")), BorderFactory.createEmptyBorder(2, 1, 2, 1)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateContainerGaps(false);
        layout.setAutoCreateGaps(false);
        int maxHeight = this.getContentPane().getPreferredSize().height;
        layout.setHorizontalGroup(layout.createSequentialGroup().addComponent(this.getProvidersButton(), -2, -1, -2).addComponent(this.getProviderSelectorButton(), -2, -1, -2).addComponent(this.getContentPane(), -1, -1, Short.MAX_VALUE).addComponent(this.getSearchButton(), -2, -1, -2));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, true).addComponent(this.getProvidersButton(), -1, -1, Short.MAX_VALUE).addComponent(this.getProviderSelectorButton(), -1, -1, Short.MAX_VALUE).addComponent(this.getContentPane(), maxHeight, maxHeight, maxHeight).addComponent(this.getSearchButton(), -1, -1, Short.MAX_VALUE));
        this.update(Collections.emptyList());
    }

    JButton getProvidersButton() {
        if (this.providersButton == null) {
            this.providersButton = new JButton(this.emptyIcon);
            this.styleButton(this.providersButton, 32, this.providersButton.getFont(), -1);
            this.providersButton.addActionListener(evt -> this.showProvidersPopup());
            this.updateProvidersButton();
        }
        return this.providersButton;
    }

    JButton getProviderSelectorButton() {
        if (this.providerSelectorButton == null) {
            this.providerSelectorButton = new JButton("\uf0dd");
            this.providerSelectorButton.setToolTipText("Click to select a search provider...");
            this.styleButton(this.providerSelectorButton, 12, ((IconManager)this.serviceRegistrar.getService(IconManager.class)).getIconFont(10.0f), 4);
            this.providerSelectorButton.addActionListener(evt -> this.getProvidersButton().doClick());
        }
        return this.providerSelectorButton;
    }

    JPanel getContentPane() {
        if (this.contentPane == null) {
            this.contentPane = new JPanel();
            this.contentPane.setBackground(this.getBackground());
            this.updateSelectedSearchComponent(this.getSearchTextField());
        }
        return this.contentPane;
    }

    JTextField getSearchTextField() {
        if (this.searchTextField == null) {
            final Color msgColor = UIManager.getColor("Label.disabledForeground");
            final int vgap = 1;
            final int hgap = 5;
            this.searchTextField = new JTextField(){

                @Override
                public void paint(Graphics g) {
                    super.paint(g);
                    if (this.getText() == null || this.getText().trim().isEmpty()) {
                        Graphics2D g2 = (Graphics2D)g.create();
                        g2.setRenderingHints(new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON));
                        g2.setFont(this.getFont());
                        FontMetrics metrics = g2.getFontMetrics(this.getFont());
                        int x = hgap;
                        int y = metrics.getHeight() / 2 + metrics.getAscent() + vgap;
                        g2.setColor(msgColor);
                        g2.drawString(NetworkSearchBar.DEF_SEARCH_TEXT, x, y);
                        g2.dispose();
                    }
                }
            };
            this.searchTextField.setBackground(this.getBackground());
            this.searchTextField.setMinimumSize(this.searchTextField.getPreferredSize());
            this.searchTextField.setBorder(BorderFactory.createEmptyBorder(vgap, hgap, vgap, hgap));
            this.searchTextField.setFont(this.searchTextField.getFont().deriveFont(LookAndFeelUtil.getSmallFontSize()));
        }
        return this.searchTextField;
    }

    JToggleButton getOptionsButton() {
        if (this.optionsButton == null) {
            this.optionsButton = new JToggleButton("\uf0c9");
            this.optionsButton.setToolTipText("More Options...");
            this.styleButton(this.optionsButton, 32, ((IconManager)this.serviceRegistrar.getService(IconManager.class)).getIconFont(14.0f), 2);
        }
        return this.optionsButton;
    }

    JButton getSearchButton() {
        if (this.searchButton == null) {
            this.searchButton = new JButton("\uf002");
            this.styleButton(this.searchButton, 32, ((IconManager)this.serviceRegistrar.getService(IconManager.class)).getIconFont(16.0f), 2);
            this.searchButton.setBorder(BorderFactory.createMatteBorder(0, 1, 0, 0, UIManager.getColor("Separator.foreground")));
            this.searchButton.setToolTipText("Search Network");
        }
        return this.searchButton;
    }

    ProvidersPanel getProvidersPanel() {
        if (this.providersPanel == null) {
            this.providersPanel = new ProvidersPanel();
        }
        return this.providersPanel;
    }

    public OptionsDialog getOptionsDialog() {
        if (this.optionsDialog == null) {
            this.optionsDialog = new OptionsDialog();
        }
        return this.optionsDialog;
    }

    private void styleButton(AbstractButton btn, int width, Font font, int borderSide) {
        btn.setFont(font);
        btn.setContentAreaFilled(false);
        if (borderSide == 2) {
            btn.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(1, 0, 1, 1), BorderFactory.createMatteBorder(0, 1, 0, 0, UIManager.getColor("Separator.foreground"))));
        } else if (borderSide == 4) {
            btn.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(1, 1, 1, 0), BorderFactory.createMatteBorder(0, 0, 0, 1, UIManager.getColor("Separator.foreground"))));
        } else {
            btn.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        }
        Dimension d = new Dimension(width, Math.max(width, this.getSearchTextField().getPreferredSize().height));
        btn.setMinimumSize(d);
        btn.setPreferredSize(d);
    }

    private class EmptyIcon
    implements Icon {
        private final String text = "\uf05e";
        private final Color fgColor;
        private final int width;
        private final int height;

        public EmptyIcon(int width, int height) {
            this.width = width;
            this.height = height;
            Color c = UIManager.getColor("Label.disabledForeground");
            this.fgColor = new Color(c.getRed(), c.getGreen(), c.getBlue(), 60);
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHints(new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON));
            Font font = ((IconManager)NetworkSearchBar.this.serviceRegistrar.getService(IconManager.class)).getIconFont(28.0f);
            g2.setFont(font);
            FontMetrics metrics = g2.getFontMetrics(font);
            int sx = x + 2 + (this.width - metrics.stringWidth("\uf05e")) / 2;
            int sy = y + 1 + (this.height - metrics.getHeight()) / 2 + metrics.getAscent();
            g2.setColor(this.fgColor);
            g2.drawString("\uf05e", sx, sy);
        }

        @Override
        public int getIconWidth() {
            return this.width;
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }
    }

    class ProvidersPanel
    extends JPanel {
        private static final int MAX_VISIBLE_ROWS = 10;
        private static final int COL_COUNT = 3;
        static final int ICON_COL_IDX = 0;
        static final int NAME_COL_IDX = 1;
        static final int WEBSITE_COL_IDX = 2;
        private JScrollPane scrollPane;
        private JTable table;

        ProvidersPanel() {
            this.setLayout(new BorderLayout());
            this.add((Component)this.getScrollPane(), "Center");
            this.setKeyBindings(this.getTable());
        }

        private NetworkSearchTaskFactory getProvider(int row) {
            return (NetworkSearchTaskFactory)this.getTable().getModel().getValueAt(row, 1);
        }

        public NetworkSearchTaskFactory getSelectedValue() {
            int row = this.getTable().getSelectedRow();
            return row != -1 ? this.getProvider(row) : null;
        }

        JScrollPane getScrollPane() {
            if (this.scrollPane == null) {
                this.scrollPane = new JScrollPane(this.getTable());
                this.scrollPane.setVerticalScrollBarPolicy(20);
                this.scrollPane.setHorizontalScrollBarPolicy(31);
            }
            return this.scrollPane;
        }

        JTable getTable() {
            if (this.table == null) {
                DefaultTableModel model = new DefaultTableModel(){

                    @Override
                    public boolean isCellEditable(int row, int column) {
                        return false;
                    }
                };
                model.setColumnCount(3);
                this.table = new JTable(model);
                this.table.setDefaultRenderer(Object.class, new ProvidersTableCellRenderer());
                this.table.setTableHeader(null);
                this.table.setIntercellSpacing(new Dimension(0, 0));
                this.table.setShowGrid(false);
                this.table.setSelectionMode(0);
                this.table.setColumnSelectionAllowed(false);
                this.table.setRowHeight(34);
                this.table.addMouseMotionListener(new MouseMotionAdapter(){

                    @Override
                    public void mouseMoved(MouseEvent e) {
                        int row = ProvidersPanel.this.getTable().rowAtPoint(e.getPoint());
                        if (row != -1) {
                            ProvidersPanel.this.setSelectedRow(row);
                        }
                    }
                });
                this.table.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent e) {
                        int col = ProvidersPanel.this.getTable().columnAtPoint(e.getPoint());
                        int row = ProvidersPanel.this.getTable().rowAtPoint(e.getPoint());
                        if (row != -1) {
                            NetworkSearchTaskFactory tf = ProvidersPanel.this.getProvider(row);
                            if (col == 2 && tf != null && tf.getWebsite() != null) {
                                ((OpenBrowser)NetworkSearchBar.this.serviceRegistrar.getService(OpenBrowser.class)).openURL(tf.getWebsite().toString());
                            } else {
                                ProvidersPanel.this.getTable().repaint();
                                NetworkSearchBar.this.disposeProvidersPopup(true);
                            }
                        }
                    }
                });
                this.table.addMouseListener(new DismissDelayMouseAdapter((int)TimeUnit.MINUTES.toMillis(5L)));
            }
            return this.table;
        }

        void update() {
            Object[][] data = new Object[NetworkSearchBar.this.providers.size()][3];
            int nameWidth = 100;
            int selectedRow = -1;
            int i = 0;
            Font defFont = ((ProvidersTableCellRenderer)this.getTable().getDefaultRenderer(Object.class)).defFont;
            AffineTransform af = new AffineTransform();
            FontRenderContext frc = new FontRenderContext(af, true, true);
            for (NetworkSearchTaskFactory tf : NetworkSearchBar.this.providers) {
                data[i][0] = tf;
                data[i][1] = tf;
                data[i][2] = tf;
                if (tf.equals(NetworkSearchBar.this.getSelectedProvider())) {
                    selectedRow = i;
                }
                nameWidth = Math.max(nameWidth, (int)defFont.getStringBounds(tf.getName(), frc).getWidth());
                ++i;
            }
            nameWidth = Math.min(340, nameWidth);
            DefaultTableModel model = (DefaultTableModel)this.getTable().getModel();
            model.setDataVector(data, new String[3]);
            this.getTable().getColumnModel().getColumn(0).setMinWidth(32);
            this.getTable().getColumnModel().getColumn(0).setMaxWidth(32);
            this.getTable().getColumnModel().getColumn(1).setMinWidth(nameWidth + 10);
            this.getTable().getColumnModel().getColumn(2).setMinWidth(32);
            this.getTable().getColumnModel().getColumn(2).setMaxWidth(32);
            this.setSelectedRow(selectedRow);
            this.getTable().repaint();
            int w = this.getTable().getColumnModel().getTotalColumnWidth() + 20;
            int h = NetworkSearchBar.this.providers.size() <= 10 ? this.getTable().getPreferredSize().height : this.getTable().getRowHeight() * 10;
            this.getScrollPane().getViewport().setPreferredSize(new Dimension(w, h));
        }

        void setSelectedRow(int row) {
            if (row != -1) {
                this.getTable().setRowSelectionInterval(row, row);
            }
        }

        private void setKeyBindings(JComponent comp) {
            ActionMap actionMap = comp.getActionMap();
            InputMap inputMap = comp.getInputMap(1);
            inputMap.put(KeyStroke.getKeyStroke(10, 0), "VK_ENTER");
            inputMap.put(KeyStroke.getKeyStroke(32, 0), "VK_SPACE");
            inputMap.put(KeyStroke.getKeyStroke(9, 0), "VK_TAB");
            actionMap.put("VK_ENTER", new KeyAction("VK_ENTER"));
            actionMap.put("VK_SPACE", new KeyAction("VK_SPACE"));
            actionMap.put("VK_TAB", new KeyAction("VK_TAB"));
        }

        private class ProvidersTableCellRenderer
        extends DefaultTableCellRenderer {
            final IconManager iconManager;
            final Font defFont;
            final Font iconFont;
            final Border defBorder;
            final Border nameBorder;

            private ProvidersTableCellRenderer() {
                this.iconManager = (IconManager)NetworkSearchBar.this.serviceRegistrar.getService(IconManager.class);
                this.defFont = this.getFont().deriveFont(LookAndFeelUtil.getSmallFontSize());
                this.iconFont = this.iconManager.getIconFont(12.0f);
                this.defBorder = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(1, 0, 0, 0), BorderFactory.createMatteBorder(0, 0, 1, 0, UIManager.getColor("Separator.foreground")));
                this.nameBorder = BorderFactory.createCompoundBorder(this.defBorder, BorderFactory.createEmptyBorder(0, 10, 0, 0));
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                this.setForeground(UIManager.getColor("Label.foreground"));
                this.setBackground(UIManager.getColor(isSelected ? "Table.selectionBackground" : "Table.background"));
                this.setHorizontalAlignment(0);
                this.setFont(this.defFont);
                this.setText(null);
                this.setIcon(null);
                this.setBorder(this.defBorder);
                if (value instanceof NetworkSearchTaskFactory) {
                    NetworkSearchTaskFactory tf = (NetworkSearchTaskFactory)value;
                    this.setToolTipText(tf.getDescription());
                    switch (column) {
                        case 0: {
                            Icon icon = NetworkSearchBar.this.providerIcons.get(tf);
                            this.setIcon(icon != null ? icon : NetworkSearchBar.this.emptyIcon);
                            break;
                        }
                        case 1: {
                            this.setText(tf.getName());
                            this.setHorizontalAlignment(2);
                            this.setBorder(this.nameBorder);
                            break;
                        }
                        case 2: {
                            URL url = tf.getWebsite();
                            this.setText(url != null ? "\uf08e" : "");
                            this.setFont(this.iconFont);
                            this.setForeground(UIManager.getColor("Table.focusCellBackground"));
                            this.setToolTipText(url != null ? "Visit Website..." : null);
                        }
                    }
                }
                return this;
            }
        }

        private class KeyAction
        extends AbstractAction {
            static final String VK_ENTER = "VK_ENTER";
            static final String VK_SPACE = "VK_SPACE";
            static final String VK_TAB = "VK_TAB";

            KeyAction(String actionCommand) {
                this.putValue("ActionCommandKey", actionCommand);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                String cmd = e.getActionCommand();
                if (cmd.equals(VK_ENTER) || cmd.equals(VK_SPACE) || cmd.equals(VK_TAB)) {
                    NetworkSearchBar.this.disposeProvidersPopup(true);
                }
            }
        }
    }

    private class OptionsDialog
    extends JDialog {
        public OptionsDialog() {
            super(SwingUtilities.getWindowAncestor(NetworkSearchBar.this), Dialog.ModalityType.MODELESS);
            this.setBackground(this.getBackground());
            this.setUndecorated(true);
            this.getRootPane().setBorder(BorderFactory.createLineBorder(UIManager.getColor("Separator.foreground")));
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    NetworkSearchBar.this.updateSearchEnabled();
                }
            });
            this.addWindowFocusListener(new WindowFocusListener(){

                @Override
                public void windowLostFocus(WindowEvent e) {
                    if (!ViewUtil.hasVisibleOwnedWindows(OptionsDialog.this)) {
                        if (OptionsDialog.this.isShowing() && NetworkSearchBar.this.getOptionsButton().isShowing()) {
                            Point mouseLoc = MouseInfo.getPointerInfo().getLocation();
                            Point buttonLoc = NetworkSearchBar.this.getOptionsButton().getLocationOnScreen();
                            mouseLoc.x -= buttonLoc.x;
                            mouseLoc.y -= buttonLoc.y;
                            if (!NetworkSearchBar.this.getOptionsButton().contains(mouseLoc)) {
                                NetworkSearchBar.this.getOptionsButton().setSelected(false);
                            }
                        }
                        NetworkSearchBar.this.disposeOptionsDialog();
                    }
                }

                @Override
                public void windowGainedFocus(WindowEvent e) {
                }
            });
        }

        void update(JComponent comp) {
            this.setContentPane(comp);
            this.setKeyBindings(comp);
        }

        private void setKeyBindings(JComponent comp) {
            ActionMap actionMap = comp.getActionMap();
            InputMap inputMap = comp.getInputMap(2);
            inputMap.put(KeyStroke.getKeyStroke(27, 0), "VK_ESCAPE");
            actionMap.put("VK_ESCAPE", new KeyAction("VK_ESCAPE"));
        }

        private class KeyAction
        extends AbstractAction {
            static final String VK_ESCAPE = "VK_ESCAPE";

            KeyAction(String actionCommand) {
                this.putValue("ActionCommandKey", actionCommand);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                String cmd = e.getActionCommand();
                if (cmd.equals(VK_ESCAPE)) {
                    NetworkSearchBar.this.disposeOptionsDialog();
                    NetworkSearchBar.this.getOptionsButton().setSelected(false);
                }
            }
        }
    }

    private class DismissDelayMouseAdapter
    extends MouseAdapter {
        final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
        final int dismissDelayMinutes;

        public DismissDelayMouseAdapter(int milliseconds) {
            this.dismissDelayMinutes = milliseconds;
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            ToolTipManager.sharedInstance().setDismissDelay(this.dismissDelayMinutes);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            ToolTipManager.sharedInstance().setDismissDelay(this.defaultDismissTimeout);
        }
    }
}

