/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal.view;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import org.cytoscape.application.CyApplicationConfiguration;
import org.cytoscape.application.swing.CyAction;
import org.cytoscape.internal.view.util.CyToolBar;
import org.cytoscape.internal.view.util.MenuScroller;
import org.cytoscape.internal.view.util.ViewUtil;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.IconManager;

public class CytoscapeToolBar
extends CyToolBar {
    private static final String STOPLIST_FILENAME = "toolbar.stoplist";
    private final Set<String> stopList = new HashSet<String>();
    private final JPopupMenu prefPopup = new JPopupMenu();
    private final PopupMouseListener popupMouseListener = new PopupMouseListener();
    private ComponentAdapter componentAdapter;

    public CytoscapeToolBar(CyServiceRegistrar serviceRegistrar) {
        super("Cytoscape Tools", 0, serviceRegistrar);
        this.addMouseListener(this.popupMouseListener);
        this.readStopList();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this.componentAdapter != null) {
            this.removeComponentListener(this.componentAdapter);
        }
    }

    @Override
    public AbstractButton addAction(CyAction action) {
        AbstractButton button = super.addAction(action);
        if (button != null && button.isVisible() && this.stopList.contains(action.getName())) {
            button.setVisible(false);
            this.update();
        }
        return button;
    }

    @Override
    public Component add(Component comp) {
        if (this.stopList.contains(comp.getName())) {
            comp.setVisible(false);
        }
        return super.add(comp);
    }

    private void resave() {
        ArrayList<String> hidden = new ArrayList<String>();
        for (Component c : this.getComponents()) {
            if (!(c instanceof AbstractButton) || c.isVisible()) continue;
            AbstractButton button = (AbstractButton)c;
            String name = ((CyAction)button.getAction()).getName();
            hidden.add(name);
        }
        this.writeStopList(hidden);
    }

    private void readStopList() {
        List<String> lines;
        block13: {
            this.stopList.clear();
            lines = null;
            try {
                CyApplicationConfiguration applicationConfig = (CyApplicationConfiguration)this.serviceRegistrar.getService(CyApplicationConfiguration.class);
                if (applicationConfig == null) {
                    return;
                }
                File configDirectory = applicationConfig.getConfigurationDirectoryLocation();
                File configFile = null;
                if (configDirectory.exists() && (configFile = new File(configDirectory.toPath() + "/toolbar.stoplist")).exists()) {
                    lines = Files.readAllLines(configFile.toPath(), Charset.defaultCharset());
                }
                if (lines != null) break block13;
                try (InputStream is = this.getClass().getResourceAsStream("/toolbar.stoplist");){
                    if (is != null) {
                        lines = new BufferedReader(new InputStreamReader(is, Charset.defaultCharset())).lines().collect(Collectors.toList());
                    }
                }
            }
            catch (IOException e) {
                return;
            }
        }
        if (lines != null) {
            for (String line : lines) {
                this.stopList.add(line.trim());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeStopList(List<String> list) {
        BufferedWriter writer = null;
        try {
            CyApplicationConfiguration applicationConfig = (CyApplicationConfiguration)this.serviceRegistrar.getService(CyApplicationConfiguration.class);
            if (applicationConfig == null) {
                System.err.println("cyApplicationConfiguration not found");
                return;
            }
            File configDirectory = applicationConfig.getConfigurationDirectoryLocation();
            File configFile = null;
            if (configDirectory.exists()) {
                configFile = new File(configDirectory.toPath() + "/toolbar.stoplist");
            }
            writer = new BufferedWriter(new FileWriter(configFile));
            for (String line : list) {
                if (line == null) continue;
                writer.write(line + "\n");
            }
        }
        catch (IOException e) {
            System.err.println("IOException: " + e.getMessage());
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private class PopupMouseListener
    extends MouseAdapter {
        private PopupMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent evt) {
            this.showPopup(evt);
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
            this.showPopup(evt);
        }

        private void showPopup(MouseEvent evt) {
            if (!evt.isPopupTrigger()) {
                return;
            }
            Component source = evt.getComponent();
            if (source != null && CytoscapeToolBar.this.overflowToolBar.getComponentIndex(source) >= 0) {
                return;
            }
            CytoscapeToolBar.this.prefPopup.removeAll();
            JMenuItem menuItem = new JMenuItem("Show All");
            CytoscapeToolBar.this.prefPopup.add(menuItem);
            menuItem.addActionListener(e -> {
                CytoscapeToolBar.this.showAll();
                CytoscapeToolBar.this.resave();
            });
            menuItem = new JMenuItem("Hide All");
            CytoscapeToolBar.this.prefPopup.add(menuItem);
            CytoscapeToolBar.this.prefPopup.addSeparator();
            menuItem.addActionListener(e -> {
                CytoscapeToolBar.this.hideAll();
                CytoscapeToolBar.this.resave();
            });
            for (CyToolBar.ToolBarItem item : CytoscapeToolBar.this.orderedItems) {
                AbstractButton button;
                String tip;
                Component comp = item.getComponent();
                if (!(comp instanceof AbstractButton) || (tip = (button = (AbstractButton)comp).getToolTipText()) == null || tip.isEmpty()) continue;
                JCheckBoxMenuItem mi = new JCheckBoxMenuItem();
                mi.setText(tip);
                mi.setState(button.isVisible());
                Icon icon = button.getIcon();
                if (icon instanceof ImageIcon) {
                    if (icon.getIconWidth() > CytoscapeToolBar.this.iconWidth || icon.getIconHeight() > CytoscapeToolBar.this.iconHeight) {
                        icon = IconManager.resizeIcon((Icon)icon, (int)Math.min(CytoscapeToolBar.this.iconWidth, CytoscapeToolBar.this.iconHeight));
                    }
                    final int originalWidth = icon.getIconWidth();
                    icon = new ImageIcon(((ImageIcon)icon).getImage()){

                        @Override
                        public int getIconWidth() {
                            return CytoscapeToolBar.this.iconWidth;
                        }

                        @Override
                        public synchronized void paintIcon(Component c, Graphics g, int x, int y) {
                            g.translate((this.getIconWidth() - originalWidth) / 2, 0);
                            super.paintIcon(c, g, x, y);
                        }
                    };
                }
                mi.setIcon(icon);
                mi.setPreferredSize(new Dimension(mi.getPreferredSize().width, Math.max(CytoscapeToolBar.this.iconWidth, mi.getPreferredSize().height)));
                mi.addActionListener(ev -> {
                    button.setVisible(!button.isVisible());
                    CytoscapeToolBar.this.updateSeparators(CytoscapeToolBar.this);
                    CytoscapeToolBar.this.resave();
                });
                CytoscapeToolBar.this.prefPopup.add(mi);
            }
            Window window = SwingUtilities.getWindowAncestor(CytoscapeToolBar.this);
            if (window != null) {
                GraphicsConfiguration gc = window.getGraphicsConfiguration();
                int ph = CytoscapeToolBar.this.prefPopup.getPreferredSize().height;
                int sh = ViewUtil.getEffectiveScreenArea((GraphicsConfiguration)gc).height;
                if (ph > sh) {
                    int h = 0;
                    MenuScroller tmpScroller = MenuScroller.setScrollerFor(new JPopupMenu(), 1);
                    h += tmpScroller.getUpItem().getPreferredSize().height;
                    h += tmpScroller.getDownItem().getPreferredSize().height;
                    tmpScroller.dispose();
                    int sepIdx = -1;
                    for (int count = 0; count < CytoscapeToolBar.this.prefPopup.getComponentCount(); ++count) {
                        Component comp = CytoscapeToolBar.this.prefPopup.getComponent(count);
                        if (comp instanceof JSeparator) {
                            sepIdx = count;
                        } else {
                            h += comp.getPreferredSize().height;
                        }
                        if (h <= sh) continue;
                        if (sepIdx >= 0) {
                            CytoscapeToolBar.this.prefPopup.remove(sepIdx);
                        }
                        MenuScroller.setScrollerFor(CytoscapeToolBar.this.prefPopup, Math.max(1, count - 2 - 2), 125, 2, 0);
                        break;
                    }
                }
            }
            CytoscapeToolBar.this.prefPopup.show(source, evt.getX(), evt.getY());
        }
    }
}

