/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal.view;

import java.awt.Component;
import java.awt.Container;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import org.cytoscape.application.swing.CyAction;
import org.cytoscape.internal.view.CytoscapeMenuBar;
import org.cytoscape.internal.view.CytoscapeToolBar;
import org.cytoscape.internal.view.util.CyToolBar;
import org.cytoscape.internal.view.util.ViewUtil;

public class CytoscapeMenus {
    private final CytoscapeMenuBar menuBar;
    private final CytoscapeToolBar toolBar;
    private final Set<CyAction> viewFrameActions;

    public CytoscapeMenus(CytoscapeMenuBar menuBar, CytoscapeToolBar toolBar) {
        this.menuBar = menuBar;
        this.toolBar = toolBar;
        this.viewFrameActions = new LinkedHashSet<CyAction>();
        menuBar.addMenu("File.New Network", 3.0);
        menuBar.addSeparator("File", 3.1);
        menuBar.addMenu("Edit", 0.0);
        menuBar.addMenu("View", 0.0);
        menuBar.addMenu("Select", 0.0);
        menuBar.addMenu("Layout", 0.0);
        menuBar.addMenu("Apps", 0.0);
        menuBar.addMenu("Tools", 0.0);
        menuBar.addMenu("Help", 0.0);
        menuBar.addSeparator("Edit", 2.0);
        menuBar.addSeparator("Edit", 4.0);
        menuBar.addMenu("Edit.Preferences", 100.0);
        menuBar.addSeparator("View", 2.0);
        menuBar.addSeparator("View", 6.0);
        menuBar.addSeparator("View", 9.0);
        menuBar.addSeparator("Select", 4.01);
        menuBar.addSeparator("Layout", 2.0);
        menuBar.addSeparator("Layout", 4.0);
        menuBar.addSeparator("Layout", 6.0);
        menuBar.addSeparator("Apps", 1.0);
        menuBar.addSeparator("Help", 2.0);
        menuBar.addSeparator("Help", 6.0);
        menuBar.addSeparator("Help", 9.0);
        toolBar.addSeparator(2.0f);
        toolBar.addSeparator(3.0f);
        toolBar.addSeparator(4.0f);
        toolBar.addSeparator(5.0f);
        toolBar.addSeparator(6.0f);
        toolBar.addSeparator(7.0f);
        toolBar.addSeparator(8.0f);
        toolBar.addSeparator(9.0f);
        toolBar.addSeparator(10.0f);
        toolBar.addSeparator(11.0f);
        toolBar.addSpacer(1.0E14f);
    }

    public JMenu getJMenu(String s) {
        return this.menuBar.getMenu(s);
    }

    public JMenuBar getJMenuBar() {
        return this.menuBar;
    }

    public JToolBar getJToolBar() {
        return this.toolBar;
    }

    public JToolBar createViewFrameToolBar() {
        Container viewToolBar = null;
        int total = this.toolBar.getComponentCount();
        boolean addSeparator = false;
        int buttonsAfterSeparator = 0;
        for (int i = 0; i < total; ++i) {
            Component c = this.toolBar.getComponent(i);
            if (c instanceof JButton && ((JButton)c).getAction() instanceof CyAction) {
                JButton btn = (JButton)c;
                CyAction action = (CyAction)btn.getAction();
                if (!this.viewFrameActions.contains(action)) continue;
                if (viewToolBar == null) {
                    viewToolBar = new JToolBar();
                    ((JComponent)viewToolBar).setBorder(this.toolBar.getBorder());
                }
                if (addSeparator) {
                    ((JToolBar)viewToolBar).addSeparator();
                    addSeparator = false;
                    buttonsAfterSeparator = 0;
                }
                AbstractButton newBtn = CyToolBar.createToolBarButton(action, this.toolBar.getIconWidth(), this.toolBar.getIconHeight());
                viewToolBar.add(newBtn);
                ++buttonsAfterSeparator;
                continue;
            }
            if (!(c instanceof JSeparator) || buttonsAfterSeparator <= 0) continue;
            addSeparator = true;
        }
        if (viewToolBar != null && viewToolBar.getComponentCount() > 0 && ((JToolBar)viewToolBar).getComponentAtIndex(viewToolBar.getComponentCount() - 1) instanceof JSeparator) {
            viewToolBar.remove(viewToolBar.getComponentCount() - 1);
        }
        return viewToolBar;
    }

    public void removeAction(CyAction action) {
        ViewUtil.invokeOnEDT(() -> {
            if (action.isInMenuBar()) {
                this.menuBar.removeAction(action);
            }
            if (action.isInToolBar()) {
                this.toolBar.removeAction(action);
            }
        });
    }

    public void addAction(CyAction action, Map<?, ?> props) {
        ViewUtil.invokeOnEDT(() -> {
            if (action.isInMenuBar()) {
                this.menuBar.addAction(action);
            }
            if (action.isInToolBar()) {
                this.toolBar.addAction(action);
            }
            if ("true".equals(props.get("inToolBar")) && ("networkAndView".equals(props.get("enableFor")) || "selectedNodesOrEdges".equals(props.get("enableFor")))) {
                this.viewFrameActions.add(action);
            }
        });
    }

    public void setMenuBarVisible(boolean b) {
        if (this.menuBar != null) {
            int menuCount = this.menuBar.getMenuCount();
            for (int i = 0; i < menuCount - 1; ++i) {
                JMenu menu = this.menuBar.getMenu(i);
                if (menu == null || menu.isVisible() == b) continue;
                menu.setVisible(b);
            }
        }
    }

    public JMenuBar createDummyMenuBar() {
        JMenuBar dummy = new JMenuBar();
        if (this.menuBar != null) {
            int menuCount = this.menuBar.getMenuCount();
            for (int i = 0; i < menuCount; ++i) {
                JMenu menu = this.menuBar.getMenu(i);
                if (menu == null) continue;
                dummy.add(new JMenu(menu.getText()));
            }
        }
        return dummy;
    }
}

