/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal.view;

import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import org.cytoscape.application.swing.CyAction;
import org.cytoscape.internal.model.RootNetworkManager;
import org.cytoscape.internal.task.CytoPanelTaskFactoryTunableAction;
import org.cytoscape.internal.task.DynamicTaskFactory;
import org.cytoscape.internal.task.DynamicTogglableTaskFactory;
import org.cytoscape.internal.task.TaskFactoryTunableAction;
import org.cytoscape.internal.view.CytoscapeDesktop;
import org.cytoscape.internal.view.util.ViewUtil;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.DynamicTaskFactoryProvisioner;
import org.cytoscape.task.NetworkCollectionTaskFactory;
import org.cytoscape.task.NetworkTaskFactory;
import org.cytoscape.task.NetworkViewCollectionTaskFactory;
import org.cytoscape.task.NetworkViewTaskFactory;
import org.cytoscape.task.RootNetworkCollectionTaskFactory;
import org.cytoscape.task.TableTaskFactory;
import org.cytoscape.work.TaskFactory;
import org.cytoscape.work.Togglable;

public class CytoscapeMenuPopulator {
    private final CytoscapeDesktop app;
    private final RootNetworkManager rootNetManager;
    private final CyServiceRegistrar serviceRegistrar;
    private final Map<TaskFactory, CyAction> taskMap;
    private final Map<Object, TaskFactory> provisionerMap;

    public CytoscapeMenuPopulator(CytoscapeDesktop app, RootNetworkManager rootNetManager, CyServiceRegistrar serviceRegistrar) {
        this.app = app;
        this.rootNetManager = rootNetManager;
        this.serviceRegistrar = serviceRegistrar;
        this.taskMap = new HashMap<TaskFactory, CyAction>();
        this.provisionerMap = new IdentityHashMap<Object, TaskFactory>();
    }

    public void addTaskFactory(TaskFactory factory, Map<String, String> props) {
        String pref = props.get("preferredTaskManager");
        if (pref != null && pref.equals("panel")) {
            this.addAction((CyAction)new CytoPanelTaskFactoryTunableAction(factory, null, props, this.serviceRegistrar), factory, props);
        } else {
            this.addFactory(factory, props);
        }
    }

    public void removeTaskFactory(TaskFactory factory, Map<String, String> props) {
        this.removeFactory(factory, props);
    }

    public void addRootNetworkCollectionTaskFactory(RootNetworkCollectionTaskFactory factory, Map<String, String> props) {
        ViewUtil.invokeOnEDT(() -> {
            DynamicTaskFactory provisioner = factory instanceof Togglable ? new DynamicTogglableTaskFactory(factory, this.rootNetManager) : new DynamicTaskFactory(factory, this.rootNetManager);
            this.provisionerMap.put(factory, provisioner);
            this.addFactory(provisioner, props);
        });
    }

    public void removeRootNetworkCollectionTaskFactory(RootNetworkCollectionTaskFactory factory, Map<String, String> props) {
        ViewUtil.invokeOnEDT(() -> this.removeFactory(this.provisionerMap.remove(factory), props));
    }

    public void addNetworkTaskFactory(NetworkTaskFactory factory, Map<String, String> props) {
        DynamicTaskFactoryProvisioner factoryProvisioner = (DynamicTaskFactoryProvisioner)this.serviceRegistrar.getService(DynamicTaskFactoryProvisioner.class);
        TaskFactory provisioner = factoryProvisioner.createFor(factory);
        this.provisionerMap.put(factory, provisioner);
        this.addFactory(provisioner, props);
    }

    public void removeNetworkTaskFactory(NetworkTaskFactory factory, Map<String, String> props) {
        this.removeFactory(this.provisionerMap.get(factory), props);
    }

    public void addNetworkViewTaskFactory(NetworkViewTaskFactory factory, Map<String, String> props) {
        if (props.containsKey("inMenuBar") && !Boolean.parseBoolean(props.get("inMenuBar").toString())) {
            return;
        }
        DynamicTaskFactoryProvisioner factoryProvisioner = (DynamicTaskFactoryProvisioner)this.serviceRegistrar.getService(DynamicTaskFactoryProvisioner.class);
        TaskFactory provisioner = factoryProvisioner.createFor(factory);
        this.provisionerMap.put(factory, provisioner);
        this.addFactory(provisioner, props);
    }

    public void removeNetworkViewTaskFactory(NetworkViewTaskFactory factory, Map<String, String> props) {
        this.removeFactory(this.provisionerMap.get(factory), props);
    }

    public void addNetworkViewCollectionTaskFactory(NetworkViewCollectionTaskFactory factory, Map<String, String> props) {
        DynamicTaskFactoryProvisioner factoryProvisioner = (DynamicTaskFactoryProvisioner)this.serviceRegistrar.getService(DynamicTaskFactoryProvisioner.class);
        TaskFactory provisioner = factoryProvisioner.createFor(factory);
        this.provisionerMap.put(factory, provisioner);
        this.addFactory(provisioner, props);
    }

    public void removeNetworkViewCollectionTaskFactory(NetworkViewCollectionTaskFactory factory, Map<String, String> props) {
        this.removeFactory(this.provisionerMap.get(factory), props);
    }

    public void addNetworkCollectionTaskFactory(NetworkCollectionTaskFactory factory, Map<String, String> props) {
        DynamicTaskFactoryProvisioner factoryProvisioner = (DynamicTaskFactoryProvisioner)this.serviceRegistrar.getService(DynamicTaskFactoryProvisioner.class);
        TaskFactory provisioner = factoryProvisioner.createFor(factory);
        this.provisionerMap.put(factory, provisioner);
        this.addFactory(provisioner, props);
    }

    public void removeNetworkCollectionTaskFactory(NetworkCollectionTaskFactory factory, Map<String, String> props) {
        this.removeFactory(this.provisionerMap.get(factory), props);
    }

    public void addTableTaskFactory(TableTaskFactory factory, Map<String, String> props) {
        DynamicTaskFactoryProvisioner factoryProvisioner = (DynamicTaskFactoryProvisioner)this.serviceRegistrar.getService(DynamicTaskFactoryProvisioner.class);
        TaskFactory provisioner = factoryProvisioner.createFor(factory);
        this.provisionerMap.put(factory, provisioner);
        this.addFactory(provisioner, props);
    }

    public void removeTableTaskFactory(TableTaskFactory factory, Map<String, String> props) {
        this.removeFactory(this.provisionerMap.get(factory), props);
    }

    private void addFactory(TaskFactory factory, Map<String, String> props) {
        TaskFactoryTunableAction action = props.containsKey("enableFor") ? new TaskFactoryTunableAction(factory, props, this.serviceRegistrar) : new TaskFactoryTunableAction(this.serviceRegistrar, factory, props);
        this.addAction((CyAction)action, factory, props);
    }

    private void addAction(CyAction action, TaskFactory factory, Map<String, String> props) {
        this.taskMap.put(factory, action);
        this.app.addAction(action, props);
    }

    private void removeFactory(TaskFactory factory, Map<String, String> props) {
        CyAction action = this.taskMap.remove(factory);
        if (action != null) {
            if (action.isInMenuBar()) {
                this.app.removeAction(action);
            }
            if (action.isInToolBar()) {
                this.app.removeAction(action);
            }
        }
    }
}

