/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal.view;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import org.cytoscape.internal.view.CytoPanelNameInternal;

public final class CytoPanelUtil {
    public static final int WEST_MIN_WIDTH = 100;
    public static final int WEST_MAX_WIDTH = 400;
    public static final int WEST_MIN_HEIGHT = 100;
    public static final int SOUTH_MIN_WIDTH = 500;
    public static final int SOUTH_MIN_HEIGHT = 50;
    public static final int EAST_MIN_WIDTH = 100;
    public static final int EAST_MAX_WIDTH = 1500;
    public static final int EAST_MIN_HEIGHT = 100;
    public static final int BOTTOM_MIN_WIDTH = 100;
    public static final int BOTTOM_MAX_WIDTH = 1500;
    public static final int BOTTOM_MIN_HEIGHT = 32;
    public static final int BOTTOM_MAX_HEIGHT = 500;
    static final int BUTTON_SIZE = 16;
    static final String WINDOWS = "windows";
    private static final int INSET = 5;

    public static Point getLocationOfExternalWindow(Dimension screenDimension, Rectangle containerBounds, Dimension frameDimension, CytoPanelNameInternal compassDirection, boolean outputDiagnostics) {
        if (outputDiagnostics) {
            CytoPanelUtil.outputDiagnostics(screenDimension, containerBounds, frameDimension, compassDirection);
        }
        Point containerLocation = containerBounds.getLocation();
        int containerWidth = (int)containerBounds.getWidth();
        int containerHeight = (int)containerBounds.getHeight();
        int screenWidth = (int)screenDimension.getWidth();
        int screenHeight = (int)screenDimension.getHeight();
        Point p = new Point(containerLocation.x, containerLocation.y);
        if (compassDirection == CytoPanelNameInternal.WEST) {
            p.x = containerLocation.x - 5 - (int)frameDimension.getWidth();
        } else if (compassDirection == CytoPanelNameInternal.EAST) {
            p.x = containerLocation.x + 5 + containerWidth;
        } else if (compassDirection == CytoPanelNameInternal.SOUTH) {
            p.y = containerLocation.y + 5 + containerHeight;
        } else if (compassDirection == CytoPanelNameInternal.BOTTOM) {
            p.y = containerLocation.y + 5 + containerHeight;
        }
        p.x = Math.max(0, p.x);
        p.y = Math.max(0, p.y);
        if ((double)p.x + frameDimension.getWidth() > (double)screenWidth) {
            p.x = screenWidth - (int)frameDimension.getWidth();
        }
        if ((double)p.y + frameDimension.getHeight() > (double)screenHeight) {
            p.y = screenHeight - (int)frameDimension.getHeight();
        }
        return p;
    }

    public static void styleButton(AbstractButton btn) {
        btn.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        btn.setMinimumSize(new Dimension(16, 16));
        btn.setPreferredSize(new Dimension(16, 16));
        btn.setSize(new Dimension(16, 16));
        btn.setRolloverEnabled(false);
        btn.setFocusPainted(false);
        btn.setFocusable(false);
        btn.setContentAreaFilled(false);
    }

    private static void outputDiagnostics(Dimension screenDimension, Rectangle containerBounds, Dimension preferredSizeOfPanel, CytoPanelNameInternal compassDirection) {
        System.err.println("Compass Direction:  " + compassDirection);
        System.err.println("Screen Dimension:  " + screenDimension);
        System.err.println("Container Bounds:  " + containerBounds.toString());
        System.err.println("Preferred Size of Panel:  " + preferredSizeOfPanel.toString());
    }
}

