/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.NetworkViewRenderer;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.presentation.RenderingEngine;
import org.cytoscape.view.presentation.RenderingEngineFactory;

public class BirdsEyeViewPanel
extends JPanel {
    private JPanel presentationPanel;
    private RenderingEngine<CyNetwork> engine;
    private final CyNetworkView networkView;
    private CyServiceRegistrar serviceRegistrar;

    public BirdsEyeViewPanel(CyNetworkView networkView, CyServiceRegistrar serviceRegistrar) {
        this.networkView = networkView;
        this.serviceRegistrar = serviceRegistrar;
        this.init();
    }

    public RenderingEngine<CyNetwork> getEngine() {
        return this.engine;
    }

    public final void update() {
        Dimension currentPanelSize = this.getSize();
        this.getPresentationPanel().setSize(currentPanelSize);
        this.getPresentationPanel().setPreferredSize(currentPanelSize);
        if (this.engine == null) {
            CyApplicationManager applicationManager = (CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class);
            NetworkViewRenderer renderer = applicationManager.getNetworkViewRenderer(this.networkView.getRendererId());
            RenderingEngineFactory bevFactory = renderer.getRenderingEngineFactory("birdsEye");
            this.engine = bevFactory.createRenderingEngine((Object)this.getPresentationPanel(), (View)this.networkView);
        }
        this.repaint();
    }

    public void dispose() {
        if (this.engine != null) {
            this.engine.dispose();
        }
        this.getPresentationPanel().removeAll();
        this.repaint();
    }

    private void init() {
        this.setBackground(UIManager.getColor("Table.background"));
        this.setLayout(new BorderLayout());
        this.add((Component)this.getPresentationPanel(), "Center");
    }

    protected JPanel getPresentationPanel() {
        if (this.presentationPanel == null) {
            this.presentationPanel = new JPanel();
        }
        return this.presentationPanel;
    }
}

