/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal.view;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.cytoscape.internal.view.util.ViewUtil;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;

public abstract class AbstractNetworkPanelModel<T extends CyNetwork> {
    private T network;
    private boolean current;
    private int viewCount;
    protected final PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    protected final CyServiceRegistrar serviceRegistrar;

    protected AbstractNetworkPanelModel(T network, CyServiceRegistrar serviceRegistrar) {
        if (network == null) {
            throw new IllegalArgumentException("'subNetwork' must not be null.");
        }
        if (serviceRegistrar == null) {
            throw new IllegalArgumentException("'serviceRegistrar' must not be null.");
        }
        this.network = network;
        this.serviceRegistrar = serviceRegistrar;
    }

    public T getNetwork() {
        return this.network;
    }

    public int getViewCount() {
        return this.viewCount;
    }

    public void setViewCount(int newValue) {
        if (this.viewCount != newValue) {
            int oldValue = this.viewCount;
            this.viewCount = newValue;
            this.changeSupport.firePropertyChange("viewCount", oldValue, newValue);
        }
    }

    public int getNodeCount() {
        return this.getNetwork().getNodeCount();
    }

    public int getEdgeCount() {
        return this.getNetwork().getEdgeCount();
    }

    public String getNetworkName() {
        return ViewUtil.getName(this.getNetwork());
    }

    public boolean isCurrent() {
        return this.current;
    }

    public void setCurrent(boolean newValue) {
        if (this.current != newValue) {
            boolean oldValue = this.current;
            this.current = newValue;
            this.changeSupport.firePropertyChange("current", oldValue, newValue);
        }
    }

    public abstract int getSubNetworkCount();

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }
}

