/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal.undo;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.undo.CannotUndoException;
import org.cytoscape.application.swing.AbstractCyAction;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.work.swing.undo.SwingUndoSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UndoAction
extends AbstractCyAction {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private final CyServiceRegistrar serviceRegistrar;

    public UndoAction(CyServiceRegistrar serviceRegistrar) {
        super("Undo");
        this.serviceRegistrar = serviceRegistrar;
        this.setAcceleratorKeyStroke(KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()));
        this.setPreferredMenu("Edit");
        this.setEnabled(true);
        this.setMenuGravity(1.0f);
    }

    public void actionPerformed(ActionEvent e) {
        try {
            SwingUndoSupport undo = (SwingUndoSupport)this.serviceRegistrar.getService(SwingUndoSupport.class);
            if (undo.getUndoManager().canUndo()) {
                undo.getUndoManager().undo();
            }
        }
        catch (CannotUndoException ex) {
            logger.warn("Unable to undo: " + ex);
            ex.printStackTrace();
        }
    }

    public void menuSelected(MenuEvent e) {
        SwingUndoSupport undo = (SwingUndoSupport)this.serviceRegistrar.getService(SwingUndoSupport.class);
        if (undo.getUndoManager().canUndo()) {
            this.setEnabled(true);
            this.putValue("Name", undo.getUndoManager().getUndoPresentationName());
        } else {
            this.setEnabled(false);
            this.putValue("Name", "Undo");
        }
    }
}

