/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal.tunable;

import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.LayoutStyle;
import org.cytoscape.internal.tunable.CyPropertyConfirmation;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.swing.AbstractGUITunableHandler;
import org.cytoscape.work.swing.DirectlyPresentableTunableHandler;

public class CyPropertyConfirmationHandler
extends AbstractGUITunableHandler
implements DirectlyPresentableTunableHandler {
    public CyPropertyConfirmationHandler(Field f, Object o, Tunable t) {
        super(f, o, t);
    }

    public CyPropertyConfirmationHandler(Method getter, Method setter, Object instance, Tunable tunable) {
        super(getter, setter, instance, tunable);
    }

    public void handle() {
    }

    public boolean setTunableDirectly(Window possibleParent) {
        CyPropertyConfirmation value = this.getCyPropertyConfirmation();
        if (value == null || value.getPropertyValue() == null) {
            return true;
        }
        ConfirmationDialog dialog = new ConfirmationDialog(possibleParent, value);
        dialog.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        dialog.pack();
        dialog.setLocationRelativeTo(possibleParent);
        dialog.setVisible(true);
        if (dialog.getHideStatus()) {
            value.setPropertyValue("false");
        }
        return value.isConfirmed();
    }

    public boolean isForcedToSetDirectly() {
        return true;
    }

    private CyPropertyConfirmation getCyPropertyConfirmation() {
        try {
            return (CyPropertyConfirmation)this.getValue();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private class ConfirmationDialog
    extends JDialog {
        private JPanel msgPanel;
        private JCheckBox checkBox;
        private JButton okButton;
        private JButton cancelButton;
        private final JLabel iconLabel;
        private final JLabel msgLabel;
        private CyPropertyConfirmation value;
        private final CyServiceRegistrar serviceRegistrar;

        ConfirmationDialog(Window owner, CyPropertyConfirmation value) {
            super(owner);
            this.iconLabel = new JLabel();
            this.msgLabel = new JLabel();
            this.value = value;
            this.serviceRegistrar = value.getServiceRegistrar();
            this.initComponents();
        }

        public boolean getHideStatus() {
            return this.getCheckBox().isSelected();
        }

        private void initComponents() {
            this.setTitle(CyPropertyConfirmationHandler.this.getParams().getProperty("ForceSetTitle", ""));
            this.setResizable(false);
            this.setModalExclusionType(Dialog.ModalExclusionType.APPLICATION_EXCLUDE);
            this.iconLabel.setText("\uf059");
            this.iconLabel.setFont(((IconManager)this.serviceRegistrar.getService(IconManager.class)).getIconFont(48.0f));
            this.iconLabel.setForeground(LookAndFeelUtil.getInfoColor());
            String desc = CyPropertyConfirmationHandler.this.getDescription();
            if (desc != null) {
                desc = desc.replaceAll("\\$\\{" + this.value.getPropertyName() + "\\}", this.value.getPropertyValue());
            }
            this.msgLabel.setText(desc);
            JPanel bottomPanel = LookAndFeelUtil.createOkCancelPanel((JButton)this.getOkButton(), (JButton)this.getCancelButton());
            GroupLayout layout = new GroupLayout(this.getContentPane());
            this.getContentPane().setLayout(layout);
            layout.setAutoCreateContainerGaps(true);
            layout.setAutoCreateGaps(!LookAndFeelUtil.isAquaLAF());
            layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addComponent(this.getMsgPanel(), -1, -1, Short.MAX_VALUE).addComponent(bottomPanel, -1, -1, Short.MAX_VALUE));
            layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.getMsgPanel(), -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(bottomPanel, -2, -1, -2));
            LookAndFeelUtil.setDefaultOkCancelKeyStrokes((JRootPane)this.getRootPane(), (Action)this.getOkButton().getAction(), (Action)this.getCancelButton().getAction());
            this.getRootPane().setDefaultButton(this.getOkButton());
            this.getOkButton().requestFocusInWindow();
        }

        private JPanel getMsgPanel() {
            if (this.msgPanel == null) {
                this.msgPanel = new JPanel();
                int hpad = 20;
                int vpad = 40;
                GroupLayout layout = new GroupLayout(this.msgPanel);
                this.msgPanel.setLayout(layout);
                layout.setAutoCreateContainerGaps(true);
                layout.setAutoCreateGaps(true);
                layout.setHorizontalGroup(layout.createSequentialGroup().addGap(20).addComponent(this.iconLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addComponent(this.msgLabel, -1, -1, Short.MAX_VALUE).addComponent(this.getCheckBox(), -2, -1, -2)).addGap(20, 20, Short.MAX_VALUE));
                layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addGap(40).addComponent(this.iconLabel, -2, -1, -2).addGroup(layout.createSequentialGroup().addComponent(this.msgLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.getCheckBox(), -2, -1, -2)).addGap(40));
            }
            return this.msgPanel;
        }

        private JCheckBox getCheckBox() {
            if (this.checkBox == null) {
                String s = CyPropertyConfirmationHandler.this.getParams().getProperty("doNotAskLabel", "Do not ask me again");
                this.checkBox = new JCheckBox(s);
                this.checkBox.setHorizontalAlignment(2);
            }
            return this.checkBox;
        }

        private JButton getCancelButton() {
            if (this.cancelButton == null) {
                String s = CyPropertyConfirmationHandler.this.getParams().getProperty("cancelLabel", "Cancel");
                this.cancelButton = new JButton(new AbstractAction(s){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ConfirmationDialog.this.value.setConfirmed(false);
                        ConfirmationDialog.this.dispose();
                    }
                });
            }
            return this.cancelButton;
        }

        private JButton getOkButton() {
            if (this.okButton == null) {
                String s = CyPropertyConfirmationHandler.this.getParams().getProperty("okLabel", "OK");
                this.okButton = new JButton(new AbstractAction(s){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ConfirmationDialog.this.value.setConfirmed(true);
                        ConfirmationDialog.this.dispose();
                    }
                });
            }
            return this.okButton;
        }
    }
}

