/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal.task;

import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.event.MenuEvent;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.swing.AbstractCyAction;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.work.TaskFactory;
import org.cytoscape.work.Togglable;
import org.cytoscape.work.swing.DialogTaskManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskFactoryTunableAction
extends AbstractCyAction
implements PopupMenuListener {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private final TaskFactory factory;
    private final CyServiceRegistrar serviceRegistrar;

    public TaskFactoryTunableAction(CyServiceRegistrar serviceRegistrar, TaskFactory factory, Map<String, String> props) {
        super(props, factory);
        this.factory = factory;
        this.serviceRegistrar = serviceRegistrar;
        this.config();
    }

    public TaskFactoryTunableAction(TaskFactory factory, Map<String, String> props, CyServiceRegistrar serviceRegistrar) {
        super(props, (CyApplicationManager)serviceRegistrar.getService(CyApplicationManager.class), (CyNetworkViewManager)serviceRegistrar.getService(CyNetworkViewManager.class), factory);
        this.factory = factory;
        this.serviceRegistrar = serviceRegistrar;
        this.config();
    }

    public void actionPerformed(ActionEvent evt) {
        logger.debug("About to execute task from factory: " + this.factory.toString());
        DialogTaskManager taskManager = (DialogTaskManager)this.serviceRegistrar.getService(DialogTaskManager.class);
        taskManager.execute(this.factory.createTaskIterator());
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
        if (this.factory instanceof Togglable) {
            this.putValue("SwingSelectedKey", this.factory.isOn());
        }
    }

    public void menuSelected(MenuEvent evt) {
        super.menuSelected(evt);
        if (this.factory instanceof Togglable) {
            this.putValue("SwingSelectedKey", this.factory.isOn());
        }
    }

    private void config() {
        Icon icon;
        String smallIconId;
        Icon icon2;
        this.useCheckBoxMenuItem = this.useToggleButton = this.factory instanceof Togglable;
        IconManager iconManager = (IconManager)this.serviceRegistrar.getService(IconManager.class);
        String largeIconId = (String)this.configurationProperties.get("largeIconID");
        if (largeIconId != null && !largeIconId.trim().isEmpty() && (icon2 = iconManager.getIcon(largeIconId)) != null) {
            this.putValue("SwingLargeIconKey", icon2);
        }
        if ((smallIconId = (String)this.configurationProperties.get("smallIconID")) != null && !smallIconId.trim().isEmpty() && (icon = iconManager.getIcon(smallIconId)) != null) {
            this.putValue("SmallIcon", icon);
        }
    }
}

