/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal.task;

import java.net.UnknownHostException;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.cytoscape.property.CyProperty;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class GetLatestVersionTask
extends AbstractTask {
    private static final String NEWS_URL = "http://chianti.ucsd.edu/cytoscape-news/news.html";
    private String latestVersion = null;
    private final CyServiceRegistrar registrar;
    private final String thisVersion;
    private static final String os = System.getProperty("os.name");
    private static final String os_version = System.getProperty("os.version");
    private static final String os_arch = System.getProperty("os.arch");
    private static final String java_version = System.getProperty("java.version");
    private final Properties props;

    public GetLatestVersionTask(CyServiceRegistrar registrar, String thisVersion) {
        this.registrar = registrar;
        this.thisVersion = thisVersion;
        CyProperty cyProps = (CyProperty)registrar.getService(CyProperty.class, "(cyPropertyName=cytoscape3.props)");
        this.props = (Properties)cyProps.getProperties();
    }

    public void run(TaskMonitor tm) throws Exception {
        tm.setTitle("Get Latest Cytoscape Version");
        String user_agent = "Cytoscape v" + this.thisVersion + " Java " + java_version + " " + os + " " + os_version;
        String share = this.props.getProperty("installoptions.shareStatistics");
        if (share != null && !Boolean.parseBoolean(share)) {
            user_agent = "Cytoscape v" + this.thisVersion;
        }
        try {
            Document doc = Jsoup.connect((String)NEWS_URL).userAgent(user_agent).get();
            Elements metaTags = doc.getElementsByTag("meta");
            for (Element tag : metaTags) {
                if (!"latestVersion".equals(tag.attr("name"))) continue;
                this.latestVersion = tag.attr("content");
                break;
            }
            System.out.println("UserAgent = " + user_agent);
            System.out.println("latestVersion = " + this.latestVersion);
        }
        catch (UnknownHostException e) {
            Logger.getLogger((String)"org.cytoscape.application.userlog").warn((Object)"Cannot find host (please check your Internet connection).", (Throwable)e);
            tm.showMessage(TaskMonitor.Level.WARN, "Cannot find host (please check your Internet connection): " + e.getMessage());
        }
        catch (Exception e) {
            Logger.getLogger((String)"org.cytoscape.application.userlog").error((Object)"Unexpected error when getting latest Cytoscape version.", (Throwable)e);
            tm.showMessage(TaskMonitor.Level.ERROR, "Unexpected error: " + e.getMessage());
        }
    }

    public String getLatestVersion() {
        return this.latestVersion;
    }
}

