/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal.select;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.internal.select.RowViewTracker;
import org.cytoscape.internal.view.NetworkViewMediator;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.VirtualColumnInfo;
import org.cytoscape.model.events.RowSetRecord;
import org.cytoscape.model.events.RowsSetEvent;
import org.cytoscape.model.events.RowsSetListener;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.presentation.RenderingEngine;
import org.cytoscape.view.presentation.property.values.CyColumnIdentifier;
import org.cytoscape.view.presentation.property.values.CyColumnIdentifierFactory;
import org.cytoscape.view.presentation.property.values.MappableVisualPropertyValue;
import org.cytoscape.view.vizmap.VisualMappingFunction;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualStyle;

public class RowsSetViewUpdater
implements RowsSetListener {
    private final NetworkViewMediator netViewMediator;
    private final RowViewTracker tracker;
    private final CyServiceRegistrar serviceRegistrar;

    public RowsSetViewUpdater(RowViewTracker tracker, NetworkViewMediator netViewMediator, CyServiceRegistrar serviceRegistrar) {
        this.netViewMediator = netViewMediator;
        this.tracker = tracker;
        this.serviceRegistrar = serviceRegistrar;
    }

    public void handleEvent(final RowsSetEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RowsSetViewUpdater.this.updateView(e);
            }
        });
    }

    private final void updateView(RowsSetEvent e) {
        boolean refreshView = false;
        boolean refreshOtherViews = false;
        CyApplicationManager applicationManager = (CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class);
        CyColumnIdentifierFactory columnIdentifierFactory = (CyColumnIdentifierFactory)this.serviceRegistrar.getService(CyColumnIdentifierFactory.class);
        CyNetworkViewManager networkViewManager = (CyNetworkViewManager)this.serviceRegistrar.getService(CyNetworkViewManager.class);
        VisualMappingManager visualMappingManager = (VisualMappingManager)this.serviceRegistrar.getService(VisualMappingManager.class);
        RenderingEngine renderer = applicationManager.getCurrentRenderingEngine();
        CyNetwork network = applicationManager.getCurrentNetwork();
        if (network == null) {
            return;
        }
        Collection views = networkViewManager.getNetworkViews(network);
        CyNetworkView networkView = null;
        if (views.isEmpty()) {
            return;
        }
        networkView = (CyNetworkView)views.iterator().next();
        VisualStyle vs = visualMappingManager.getVisualStyle(networkView);
        Map<CyRow, View<? extends CyIdentifiable>> rowViewMap = this.tracker.getRowViewMap(networkView);
        for (RowSetRecord record : e.getPayloadCollection()) {
            CyEdge edge;
            CyRow row = record.getRow();
            String columnName = record.getColumn();
            CyColumn column = row.getTable().getColumn(columnName);
            if (column == null) continue;
            VirtualColumnInfo virtualColInfo = column.getVirtualColumnInfo();
            boolean virtual = virtualColInfo.isVirtual();
            View<? extends CyIdentifiable> v = rowViewMap.get(row);
            if (v == null) continue;
            if (v.getModel() instanceof CyNode) {
                CyNode node = (CyNode)v.getModel();
                if (network.containsNode(node) && RowsSetViewUpdater.isStyleAffected(vs, columnName, (RenderingEngine<CyNetwork>)renderer, columnIdentifierFactory)) {
                    vs.apply(row, v);
                    refreshView = false;
                }
            } else if (v.getModel() instanceof CyEdge && network.containsEdge(edge = (CyEdge)v.getModel()) && RowsSetViewUpdater.isStyleAffected(vs, columnName, (RenderingEngine<CyNetwork>)renderer, columnIdentifierFactory)) {
                vs.apply(row, v);
                refreshView = false;
            }
            if (!refreshView || !virtual) continue;
            refreshOtherViews = true;
        }
        if (refreshView) {
            vs.apply(networkView);
            networkView.updateView();
            if (refreshOtherViews) {
                for (CyNetworkView view : networkViewManager.getNetworkViewSet()) {
                    VisualStyle style;
                    if (view == networkView || (style = visualMappingManager.getVisualStyle(view)) != vs) continue;
                    this.netViewMediator.setUpdateFlag(view);
                }
            }
        }
    }

    private static boolean isStyleAffected(VisualStyle vs, String columnName, RenderingEngine<CyNetwork> renderer, CyColumnIdentifierFactory columnIdentifierFactory) {
        boolean result = false;
        if (renderer != null) {
            CyColumnIdentifier colId = columnIdentifierFactory.createColumnIdentifier(columnName);
            Set properties = renderer.getVisualLexicon().getAllVisualProperties();
            for (VisualProperty vp : properties) {
                Set mappedColIds;
                VisualMappingFunction f = vs.getVisualMappingFunction(vp);
                if (f != null && f.getMappingColumnName().equalsIgnoreCase(columnName)) {
                    result = true;
                    break;
                }
                Object defValue = vs.getDefaultValue(vp);
                if (!(defValue instanceof MappableVisualPropertyValue) || !(mappedColIds = ((MappableVisualPropertyValue)defValue).getMappedColumns()).contains(colId)) continue;
                result = true;
                break;
            }
        }
        return result;
    }
}

