/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal.select;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.events.AboutToRemoveEdgeViewsEvent;
import org.cytoscape.view.model.events.AboutToRemoveEdgeViewsListener;
import org.cytoscape.view.model.events.AboutToRemoveNodeViewsEvent;
import org.cytoscape.view.model.events.AboutToRemoveNodeViewsListener;
import org.cytoscape.view.model.events.AddedEdgeViewsEvent;
import org.cytoscape.view.model.events.AddedEdgeViewsListener;
import org.cytoscape.view.model.events.AddedNodeViewsEvent;
import org.cytoscape.view.model.events.AddedNodeViewsListener;
import org.cytoscape.view.model.events.NetworkViewAboutToBeDestroyedEvent;
import org.cytoscape.view.model.events.NetworkViewAboutToBeDestroyedListener;
import org.cytoscape.view.model.events.NetworkViewAddedEvent;
import org.cytoscape.view.model.events.NetworkViewAddedListener;

public class RowViewTracker
implements NetworkViewAddedListener,
AddedNodeViewsListener,
AddedEdgeViewsListener,
AboutToRemoveNodeViewsListener,
AboutToRemoveEdgeViewsListener,
NetworkViewAboutToBeDestroyedListener {
    private static String DING_ID = "org.cytoscape.ding";
    private final Map<CyNetworkView, Map<CyRow, View<? extends CyIdentifiable>>> rowViewMapsByNetworkView = new IdentityHashMap<CyNetworkView, Map<CyRow, View<? extends CyIdentifiable>>>();
    private final Map<CyTable, Set<CyNetworkView>> networkViewsByTable = new IdentityHashMap<CyTable, Set<CyNetworkView>>();

    public void handleEvent(final NetworkViewAddedEvent e) {
        String rendererId = e.getNetworkView().getRendererId();
        if (rendererId.equals(DING_ID)) {
            DING_ID = rendererId;
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CyNetworkView view = e.getNetworkView();
                CyNetwork net = (CyNetwork)view.getModel();
                Map<CyRow, View<? extends CyIdentifiable>> rowViewMap = RowViewTracker.this.getRowViewMapInternal(view);
                for (View nv : view.getNodeViews()) {
                    rowViewMap.put(net.getRow((CyIdentifiable)nv.getModel()), (View<? extends CyIdentifiable>)nv);
                }
                for (View ev : view.getEdgeViews()) {
                    rowViewMap.put(net.getRow((CyIdentifiable)ev.getModel()), (View<? extends CyIdentifiable>)ev);
                }
                RowViewTracker.this.addTables(view);
            }
        });
    }

    protected void addTables(CyNetworkView view) {
        CyNetwork network = (CyNetwork)view.getModel();
        this.addTable(view, network.getTable(CyNetwork.class, "USER"));
        this.addTable(view, network.getTable(CyNode.class, "USER"));
        this.addTable(view, network.getTable(CyEdge.class, "USER"));
    }

    private void addTable(CyNetworkView view, CyTable table) {
        if (table == null) {
            return;
        }
        Set<CyNetworkView> views = this.networkViewsByTable.get(table);
        if (views == null) {
            views = new HashSet<CyNetworkView>();
            this.networkViewsByTable.put(table, views);
        }
        views.add(view);
    }

    protected void removeTables(CyNetworkView view) {
        CyNetwork network = (CyNetwork)view.getModel();
        this.removeTable(view, network.getTable(CyNetwork.class, "USER"));
        this.removeTable(view, network.getTable(CyNode.class, "USER"));
        this.removeTable(view, network.getTable(CyEdge.class, "USER"));
    }

    private void removeTable(CyNetworkView view, CyTable table) {
        Set<CyNetworkView> views = this.networkViewsByTable.get(table);
        if (views == null) {
            return;
        }
        views.remove(view);
        if (views.size() == 0) {
            this.networkViewsByTable.remove(table);
        }
    }

    public void handleEvent(final AddedNodeViewsEvent e) {
        if (((CyNetworkView)e.getSource()).getRendererId().equals(DING_ID)) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CyNetworkView view = (CyNetworkView)e.getSource();
                CyNetwork net = (CyNetwork)view.getModel();
                Map<CyRow, View<? extends CyIdentifiable>> rowViewMap = RowViewTracker.this.getRowViewMapInternal(view);
                for (View v : e.getNodeViews()) {
                    if (!net.containsNode((CyNode)v.getModel())) continue;
                    rowViewMap.put(net.getRow((CyIdentifiable)v.getModel()), (View<? extends CyIdentifiable>)v);
                }
            }
        });
    }

    public void handleEvent(final AddedEdgeViewsEvent e) {
        if (((CyNetworkView)e.getSource()).getRendererId().equals(DING_ID)) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CyNetworkView view = (CyNetworkView)e.getSource();
                CyNetwork net = (CyNetwork)view.getModel();
                Map<CyRow, View<? extends CyIdentifiable>> rowViewMap = RowViewTracker.this.getRowViewMapInternal(view);
                for (View v : e.getEdgeViews()) {
                    if (!net.containsEdge((CyEdge)v.getModel())) continue;
                    rowViewMap.put(net.getRow((CyIdentifiable)v.getModel()), (View<? extends CyIdentifiable>)v);
                }
            }
        });
    }

    public void handleEvent(final AboutToRemoveNodeViewsEvent e) {
        if (((CyNetworkView)e.getSource()).getRendererId().equals(DING_ID)) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Map<CyRow, View<? extends CyIdentifiable>> rowViewMap = RowViewTracker.this.rowViewMapsByNetworkView.get(e.getSource());
                if (rowViewMap == null) {
                    return;
                }
                Collection<View<? extends CyIdentifiable>> values = rowViewMap.values();
                for (View v : e.getPayloadCollection()) {
                    values.remove(v);
                }
            }
        });
    }

    public void handleEvent(final AboutToRemoveEdgeViewsEvent e) {
        if (((CyNetworkView)e.getSource()).getRendererId().equals(DING_ID)) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Map<CyRow, View<? extends CyIdentifiable>> rowViewMap = RowViewTracker.this.rowViewMapsByNetworkView.get(e.getSource());
                if (rowViewMap == null) {
                    return;
                }
                Collection<View<? extends CyIdentifiable>> values = rowViewMap.values();
                for (View v : e.getPayloadCollection()) {
                    values.remove(v);
                }
            }
        });
    }

    public void handleEvent(final NetworkViewAboutToBeDestroyedEvent e) {
        if (e.getNetworkView().getRendererId().equals(DING_ID)) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CyNetworkView view = e.getNetworkView();
                RowViewTracker.this.rowViewMapsByNetworkView.remove(view);
                RowViewTracker.this.removeTables(view);
            }
        });
    }

    private Map<CyRow, View<? extends CyIdentifiable>> getRowViewMapInternal(CyNetworkView view) {
        Map<CyRow, View<? extends CyIdentifiable>> rowViewMap = this.rowViewMapsByNetworkView.get(view);
        if (rowViewMap == null) {
            rowViewMap = new IdentityHashMap<CyRow, View<? extends CyIdentifiable>>();
            this.rowViewMapsByNetworkView.put(view, rowViewMap);
        }
        return rowViewMap;
    }

    public Map<CyRow, View<? extends CyIdentifiable>> getRowViewMap(CyNetworkView networkView) {
        Map<Object, Object> map = this.rowViewMapsByNetworkView.get(networkView);
        if (map == null) {
            map = Collections.emptyMap();
        }
        return Collections.unmodifiableMap(map);
    }

    public Collection<CyNetworkView> getAffectedNetworkViews(CyTable cyTable) {
        Set<CyNetworkView> views = this.networkViewsByTable.get(cyTable);
        if (views == null) {
            return Collections.emptySet();
        }
        return views;
    }
}

