/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal.layout.ui;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Map;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.events.SetCurrentNetworkViewEvent;
import org.cytoscape.application.events.SetCurrentNetworkViewListener;
import org.cytoscape.application.swing.AbstractCyAction;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.internal.layout.ui.LayoutSettingsDialog;
import org.cytoscape.internal.layout.ui.LayoutSettingsManager;
import org.cytoscape.internal.view.util.ViewUtil;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.layout.CyLayoutAlgorithm;
import org.cytoscape.view.model.CyNetworkViewManager;

public class SettingsAction
extends AbstractCyAction
implements SetCurrentNetworkViewListener {
    private LayoutSettingsDialog settingsDialog;
    private final LayoutSettingsManager layoutSettingsMgr;
    private final CyServiceRegistrar serviceRegistrar;

    public SettingsAction(LayoutSettingsManager layoutSettingsMgr, CyServiceRegistrar serviceRegistrar) {
        super("Settings...", (CyApplicationManager)serviceRegistrar.getService(CyApplicationManager.class), "always", (CyNetworkViewManager)serviceRegistrar.getService(CyNetworkViewManager.class));
        this.layoutSettingsMgr = layoutSettingsMgr;
        this.serviceRegistrar = serviceRegistrar;
        this.setPreferredMenu("Layout");
        this.setMenuGravity(3.0f);
    }

    public void actionPerformed(ActionEvent evt) {
        if (this.settingsDialog == null) {
            CySwingApplication swingApplication = (CySwingApplication)this.serviceRegistrar.getService(CySwingApplication.class);
            Window owner = ViewUtil.getWindowAncestor(evt, swingApplication);
            this.settingsDialog = new LayoutSettingsDialog(owner, this.layoutSettingsMgr, this.serviceRegistrar);
            this.settingsDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    SettingsAction.this.settingsDialog = null;
                }
            });
        }
        this.settingsDialog.actionPerformed(evt);
    }

    public void handleEvent(SetCurrentNetworkViewEvent e) {
        if (this.settingsDialog != null) {
            ViewUtil.invokeOnEDT(() -> this.settingsDialog.setNetworkView(e.getNetworkView()));
        }
    }

    public void addLayout(CyLayoutAlgorithm layout, Map<?, ?> props) {
        if (this.settingsDialog != null) {
            ViewUtil.invokeOnEDT(() -> this.settingsDialog.addLayout(layout));
        }
    }

    public void removeLayout(CyLayoutAlgorithm layout, Map<?, ?> props) {
        if (this.settingsDialog != null) {
            ViewUtil.invokeOnEDT(() -> this.settingsDialog.removeLayout(layout));
        }
    }
}

