/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal.layout.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.UIManager;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.internal.layout.ui.LayoutSettingsManager;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTable;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.DynamicTaskFactoryProvisioner;
import org.cytoscape.task.NetworkViewTaskFactory;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.view.layout.CyLayoutAlgorithm;
import org.cytoscape.view.layout.CyLayoutAlgorithmManager;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.work.TaskFactory;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.TunableMutator;
import org.cytoscape.work.swing.PanelTaskManager;
import org.cytoscape.work.swing.TunableUIHelper;
import org.cytoscape.work.util.ListChangeListener;
import org.cytoscape.work.util.ListSelection;
import org.cytoscape.work.util.ListSingleSelection;

public class LayoutSettingsDialog
extends JDialog
implements ActionListener {
    private static final String UNWEIGHTED = "(none)";
    private CyLayoutAlgorithm currentLayout;
    private TaskFactory currentAction;
    private LocalNetworkViewTaskFactory networkViewTaskFactory;
    private JPanel settingsPnl;
    private JPanel buttonPnl;
    private JComboBox<CyLayoutAlgorithm> algorithmCmb;
    private JPanel algorithmPnl;
    private JPanel layoutAttrPnl;
    private JButton makeDefaultBtn;
    private JButton applyBtn;
    private JButton applySelectedBtn;
    private JButton resetBtn;
    private JButton doneBtn;
    private LayoutSettingsManager layoutSettingsMgr;
    private LayoutEdgeAttributeTunable layoutEdgeAttrTunable;
    private LayoutNodeAttributeTunable layoutNodeAttrTunable;
    private boolean initialized;
    private boolean initializing;
    private Set<CyLayoutAlgorithm> tunablesToSave = new HashSet<CyLayoutAlgorithm>();
    private final CyServiceRegistrar serviceRegistrar;
    private final PanelTaskManager taskMgr;

    public LayoutSettingsDialog(Window owner, LayoutSettingsManager layoutSettingsMgr, CyServiceRegistrar serviceRegistrar) {
        super(owner, "Layout Settings", Dialog.ModalityType.MODELESS);
        this.layoutSettingsMgr = layoutSettingsMgr;
        this.serviceRegistrar = serviceRegistrar;
        this.taskMgr = (PanelTaskManager)serviceRegistrar.getService(PanelTaskManager.class);
        this.initComponents();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.pack();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                LayoutSettingsDialog.this.saveLayoutContexts();
            }

            @Override
            public void windowActivated(WindowEvent e) {
                LayoutSettingsDialog.this.updateMakeDefaultBtn();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                LayoutSettingsDialog.this.saveLayoutContexts();
            }

            @Override
            public void componentShown(ComponentEvent e) {
                LayoutSettingsDialog.this.tunablesToSave.add(LayoutSettingsDialog.this.currentLayout);
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.isVisible()) {
            this.requestFocus();
        } else {
            if (!this.initialized) {
                this.initialize();
                this.updateMakeDefaultBtn();
                this.setLocationRelativeTo(this.getOwner());
                this.pack();
            }
            this.setVisible(true);
            this.initialized = true;
        }
        this.setNetworkView(((CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class)).getCurrentNetworkView());
    }

    void addLayout(CyLayoutAlgorithm layout) {
        if (this.initialized) {
            this.initialize();
        }
    }

    void removeLayout(CyLayoutAlgorithm layout) {
        if (this.initialized) {
            if (this.currentLayout == layout) {
                this.getAlgorithmPnl().removeAll();
            }
            this.initialize();
        }
    }

    private void initComponents() {
        JPanel contentPane = new JPanel();
        GroupLayout layout = new GroupLayout(contentPane);
        contentPane.setLayout(layout);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(true);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, true).addComponent(this.getSettingsPnl(), -1, -1, Short.MAX_VALUE).addComponent(this.getButtonPnl(), -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.getSettingsPnl(), -1, -1, Short.MAX_VALUE).addComponent(this.getButtonPnl(), -2, -1, -2));
        this.setContentPane(contentPane);
        LookAndFeelUtil.setDefaultOkCancelKeyStrokes((JRootPane)this.getRootPane(), (Action)this.getApplyBtn().getAction(), (Action)this.getDoneBtn().getAction());
        this.getRootPane().setDefaultButton(this.getApplyBtn());
        this.pack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        this.initializing = true;
        try {
            final Collator collator = Collator.getInstance(Locale.getDefault());
            TreeSet<CyLayoutAlgorithm> allLayouts = new TreeSet<CyLayoutAlgorithm>(new Comparator<CyLayoutAlgorithm>(){

                @Override
                public int compare(CyLayoutAlgorithm o1, CyLayoutAlgorithm o2) {
                    return collator.compare(o1.toString(), o2.toString());
                }
            });
            CyLayoutAlgorithmManager layoutMgr = (CyLayoutAlgorithmManager)this.serviceRegistrar.getService(CyLayoutAlgorithmManager.class);
            allLayouts.addAll(layoutMgr.getAllLayouts());
            if (this.currentLayout == null) {
                this.currentLayout = layoutMgr.getDefaultLayout();
            }
            this.getAlgorithmCmb().removeAllItems();
            for (CyLayoutAlgorithm algo : allLayouts) {
                this.getAlgorithmCmb().addItem(algo);
            }
        }
        finally {
            this.initializing = false;
        }
        if (this.currentLayout != null) {
            this.getAlgorithmCmb().setSelectedItem(this.currentLayout);
        } else if (this.getAlgorithmCmb().getModel().getSize() > 0) {
            this.getAlgorithmCmb().setSelectedIndex(0);
        }
        this.updateMakeDefaultBtn();
        this.updateApplySelectedBtn();
    }

    private void updateMakeDefaultBtn() {
        CyLayoutAlgorithm defLayout = ((CyLayoutAlgorithmManager)this.serviceRegistrar.getService(CyLayoutAlgorithmManager.class)).getDefaultLayout();
        boolean enabled = defLayout != null && !defLayout.equals(this.getAlgorithmCmb().getSelectedItem());
        this.getMakeDefaultBtn().setEnabled(enabled);
    }

    private void updateApplySelectedBtn() {
        boolean enabled = false;
        if (this.currentLayout.getSupportsSelectedOnly()) {
            CyApplicationManager appMgr = (CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class);
            CyNetworkView view = appMgr.getCurrentNetworkView();
            enabled = LayoutSettingsDialog.hasSelectedNodes(view);
        }
        this.getApplySelectedBtn().setEnabled(enabled);
    }

    private JButton getMakeDefaultBtn() {
        if (this.makeDefaultBtn == null) {
            this.makeDefaultBtn = new JButton("Make Default");
            this.makeDefaultBtn.addActionListener(e -> {
                if (this.initializing) {
                    return;
                }
                CyLayoutAlgorithmManager layoutMgr = (CyLayoutAlgorithmManager)this.serviceRegistrar.getService(CyLayoutAlgorithmManager.class);
                CyLayoutAlgorithm layout = (CyLayoutAlgorithm)this.getAlgorithmCmb().getSelectedItem();
                if (layout != null && !layout.equals(layoutMgr.getDefaultLayout())) {
                    layoutMgr.setDefaultLayout(layout);
                }
                this.initialize();
            });
        }
        return this.makeDefaultBtn;
    }

    private JPanel getSettingsPnl() {
        if (this.settingsPnl == null) {
            this.settingsPnl = new JPanel();
            this.settingsPnl.setAutoscrolls(true);
            this.settingsPnl.setOpaque(!LookAndFeelUtil.isAquaLAF());
            JLabel algoLbl = new JLabel("Layout Algorithm:");
            GroupLayout layout = new GroupLayout(this.settingsPnl);
            this.settingsPnl.setLayout(layout);
            layout.setAutoCreateGaps(true);
            layout.setAutoCreateContainerGaps(true);
            layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addComponent(algoLbl).addGroup(layout.createSequentialGroup().addComponent(this.getAlgorithmCmb()).addComponent(this.getMakeDefaultBtn())).addComponent(this.getAlgorithmPnl(), -1, -1, Short.MAX_VALUE));
            layout.setVerticalGroup(layout.createSequentialGroup().addComponent(algoLbl).addGroup(layout.createParallelGroup().addComponent(this.getAlgorithmCmb(), -2, -1, -2).addComponent(this.getMakeDefaultBtn())).addComponent(this.getAlgorithmPnl(), -1, -1, Short.MAX_VALUE));
        }
        return this.settingsPnl;
    }

    private JPanel getAlgorithmPnl() {
        if (this.algorithmPnl == null) {
            this.algorithmPnl = new JPanel();
            this.algorithmPnl.setLayout(new BoxLayout(this.algorithmPnl, 3));
            this.algorithmPnl.setAutoscrolls(true);
            this.algorithmPnl.setBorder(LookAndFeelUtil.createPanelBorder());
            this.algorithmPnl.setOpaque(!LookAndFeelUtil.isAquaLAF());
        }
        return this.algorithmPnl;
    }

    public JPanel getButtonPnl() {
        if (this.buttonPnl == null) {
            this.buttonPnl = new JPanel();
            this.buttonPnl.setLayout(new BoxLayout(this.buttonPnl, 2));
            this.buttonPnl.setBorder(BorderFactory.createEmptyBorder(2, 2, 5, 2));
            this.buttonPnl.add(this.getResetBtn());
            this.buttonPnl.add(Box.createHorizontalGlue());
            this.buttonPnl.add(this.getApplySelectedBtn());
            this.buttonPnl.add(this.getApplyBtn());
            this.buttonPnl.add(this.getDoneBtn());
        }
        return this.buttonPnl;
    }

    private JButton getApplySelectedBtn() {
        if (this.applySelectedBtn == null) {
            this.applySelectedBtn = this.createApplyBtn(true, "Apply to Selected Nodes", "Apply layout to selected nodes only.");
        }
        return this.applySelectedBtn;
    }

    private JButton getApplyBtn() {
        if (this.applyBtn == null) {
            this.applyBtn = this.createApplyBtn(false, "Apply", "Apply layout to entire network.");
        }
        return this.applyBtn;
    }

    private JButton createApplyBtn(boolean selectedNodesOnly, String label, String tooltip) {
        JButton button = new JButton(label);
        button.setToolTipText(tooltip);
        button.addActionListener(evt -> {
            Object context = this.currentLayout.getDefaultLayoutContext();
            this.networkViewTaskFactory.setSelectedNodesOnly(selectedNodesOnly);
            if (this.taskMgr.validateAndApplyTunables(context)) {
                this.taskMgr.execute(this.currentAction.createTaskIterator());
            }
        });
        return button;
    }

    private JButton getResetBtn() {
        if (this.resetBtn == null) {
            this.resetBtn = new JButton(new AbstractAction("Reset Defaults"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Object context = LayoutSettingsDialog.this.currentLayout.createLayoutContext();
                    LayoutSettingsDialog.this.layoutSettingsMgr.saveLayoutContext(LayoutSettingsDialog.this.taskMgr, LayoutSettingsDialog.this.currentLayout, context);
                    LayoutSettingsDialog.this.layoutSettingsMgr.restoreLayoutContext(LayoutSettingsDialog.this.currentLayout);
                    TunableMutator tunableMutator = LayoutSettingsDialog.this.taskMgr.getTunableMutator();
                    if (tunableMutator instanceof TunableUIHelper) {
                        TunableUIHelper helper = (TunableUIHelper)tunableMutator;
                        helper.update(LayoutSettingsDialog.this.currentLayout.getDefaultLayoutContext());
                    }
                }
            });
        }
        return this.resetBtn;
    }

    public JButton getDoneBtn() {
        if (this.doneBtn == null) {
            this.doneBtn = new JButton(new AbstractAction("Done"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LayoutSettingsDialog.this.dispose();
                }
            });
        }
        return this.doneBtn;
    }

    private JComboBox<CyLayoutAlgorithm> getAlgorithmCmb() {
        if (this.algorithmCmb == null) {
            this.algorithmCmb = new JComboBox();
            this.algorithmCmb.setRenderer(new LayoutAlgorithmListCellRenderer("-- Select algorithm to view settings --"));
            this.algorithmCmb.addActionListener(e -> {
                if (this.initializing) {
                    return;
                }
                Object o = this.algorithmCmb.getSelectedItem();
                if (o instanceof CyLayoutAlgorithm) {
                    this.currentLayout = (CyLayoutAlgorithm)o;
                    CyApplicationManager appMgr = (CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class);
                    Object context = this.currentLayout.getDefaultLayoutContext();
                    this.tunablesToSave.add(this.currentLayout);
                    DynamicTaskFactoryProvisioner factoryProvisioner = (DynamicTaskFactoryProvisioner)this.serviceRegistrar.getService(DynamicTaskFactoryProvisioner.class);
                    this.networkViewTaskFactory = this.wrapWithContext(this.currentLayout, context);
                    TaskFactory provisioner = factoryProvisioner.createFor((NetworkViewTaskFactory)this.networkViewTaskFactory);
                    JPanel tunablePnl = (JPanel)this.taskMgr.getConfiguration(provisioner, context);
                    this.layoutAttrPnl = new JPanel();
                    this.layoutAttrPnl.setLayout(new BoxLayout(this.layoutAttrPnl, 3));
                    this.layoutAttrPnl.setOpaque(!LookAndFeelUtil.isAquaLAF());
                    CyNetworkView view = appMgr.getCurrentNetworkView();
                    this.setNetworkView(view);
                    this.getAlgorithmPnl().removeAll();
                    this.getAlgorithmPnl().add(this.layoutAttrPnl);
                    if (tunablePnl != null) {
                        tunablePnl.setAlignmentX(0.5f);
                        this.setPanelsTransparent(tunablePnl);
                        this.getAlgorithmPnl().add(tunablePnl);
                    }
                    this.updateApplySelectedBtn();
                    this.currentAction = provisioner;
                    this.pack();
                }
                this.updateMakeDefaultBtn();
            });
        }
        return this.algorithmCmb;
    }

    void setNetworkView(CyNetworkView view) {
        List<String> attributeList;
        this.getApplyBtn().setEnabled(view != null);
        this.updateApplySelectedBtn();
        if (this.layoutAttrPnl == null) {
            return;
        }
        boolean haveNodeAttribute = this.currentLayout.getSupportedNodeAttributeTypes() != null && this.currentLayout.getSupportedNodeAttributeTypes().size() > 0;
        boolean haveEdgeAttribute = this.currentLayout.getSupportedEdgeAttributeTypes() != null && this.currentLayout.getSupportedEdgeAttributeTypes().size() > 0;
        this.layoutAttrPnl.removeAll();
        if (view != null && !(attributeList = this.getAttributeList((CyNetwork)view.getModel(), this.currentLayout.getSupportedNodeAttributeTypes(), this.currentLayout.getSupportedEdgeAttributeTypes())).isEmpty()) {
            final CyLayoutAlgorithmManager layoutMgr = (CyLayoutAlgorithmManager)this.serviceRegistrar.getService(CyLayoutAlgorithmManager.class);
            String layoutAttribute = layoutMgr.getLayoutAttribute(this.currentLayout, view);
            String selectedAttribute = attributeList.contains(layoutAttribute) ? layoutAttribute : attributeList.get(0);
            Container panel = null;
            if (haveEdgeAttribute) {
                this.layoutNodeAttrTunable = null;
                this.layoutEdgeAttrTunable = new LayoutEdgeAttributeTunable();
                this.layoutEdgeAttrTunable.layoutAttribute = new ListSingleSelection(attributeList);
                this.layoutEdgeAttrTunable.layoutAttribute.setSelectedValue((Object)selectedAttribute);
                this.layoutEdgeAttrTunable.layoutAttribute.addListener((ListChangeListener)new ListChangeListener<String>(){

                    public void selectionChanged(ListSelection<String> source) {
                        layoutMgr.setLayoutAttribute(LayoutSettingsDialog.this.currentLayout, (String)((ListSingleSelection)source).getSelectedValue());
                    }
                });
                panel = (JPanel)this.taskMgr.getConfiguration(null, (Object)this.layoutEdgeAttrTunable);
            } else if (haveNodeAttribute) {
                this.layoutEdgeAttrTunable = null;
                this.layoutNodeAttrTunable = new LayoutNodeAttributeTunable();
                this.layoutNodeAttrTunable.layoutAttribute = new ListSingleSelection(attributeList);
                this.layoutNodeAttrTunable.layoutAttribute.setSelectedValue((Object)selectedAttribute);
                this.layoutNodeAttrTunable.layoutAttribute.addListener((ListChangeListener)new ListChangeListener<String>(){

                    public void selectionChanged(ListSelection<String> source) {
                        layoutMgr.setLayoutAttribute(LayoutSettingsDialog.this.currentLayout, (String)((ListSingleSelection)source).getSelectedValue());
                    }
                });
                panel = (JPanel)this.taskMgr.getConfiguration(null, (Object)this.layoutNodeAttrTunable);
            }
            this.setPanelsTransparent((JPanel)panel);
            this.layoutAttrPnl.add(panel);
            panel.invalidate();
        }
    }

    private static boolean hasSelectedNodes(CyNetworkView view) {
        if (view == null) {
            return false;
        }
        CyNetwork network = (CyNetwork)view.getModel();
        CyTable table = network.getDefaultNodeTable();
        return table.countMatchingRows("selected", (Object)Boolean.TRUE) > 0;
    }

    private List<String> getAttributeList(CyNetwork network, Set<Class<?>> allowedNodeAttributeTypes, Set<Class<?>> allowedEdgeAttributeTypes) {
        CyTable table;
        Set<Class<?>> allowedTypes;
        ArrayList<String> attributes = new ArrayList<String>();
        if (!allowedEdgeAttributeTypes.isEmpty()) {
            allowedTypes = allowedEdgeAttributeTypes;
            table = network.getDefaultEdgeTable();
        } else if (!allowedNodeAttributeTypes.isEmpty()) {
            allowedTypes = allowedNodeAttributeTypes;
            table = network.getDefaultNodeTable();
        } else {
            return attributes;
        }
        for (CyColumn column : table.getColumns()) {
            if (column.getName().equals("selected") || column.getName().equals("SUID") || !allowedTypes.contains(column.getType())) continue;
            attributes.add(column.getName());
        }
        Collections.sort(attributes);
        if (!attributes.isEmpty()) {
            attributes.add(0, UNWEIGHTED);
        }
        return attributes;
    }

    private String getLayoutAttribute() {
        if (this.layoutNodeAttrTunable != null) {
            if (this.layoutEdgeAttrTunable != null && this.layoutEdgeAttrTunable.layoutAttribute != null) {
                if (((String)this.layoutEdgeAttrTunable.layoutAttribute.getSelectedValue()).equals(UNWEIGHTED)) {
                    return null;
                }
                return (String)this.layoutEdgeAttrTunable.layoutAttribute.getSelectedValue();
            }
            if (this.layoutNodeAttrTunable != null && this.layoutNodeAttrTunable.layoutAttribute != null) {
                if (((String)this.layoutNodeAttrTunable.layoutAttribute.getSelectedValue()).equals(UNWEIGHTED)) {
                    return null;
                }
                return (String)this.layoutNodeAttrTunable.layoutAttribute.getSelectedValue();
            }
        }
        return null;
    }

    private static Set<View<CyNode>> getLayoutNodes(CyLayoutAlgorithm layout, CyNetworkView networkView, boolean selectedNodesOnly) {
        if (layout.getSupportsSelectedOnly() && selectedNodesOnly) {
            HashSet<View<CyNode>> nodeViews = new HashSet<View<CyNode>>();
            CyNetwork network = (CyNetwork)networkView.getModel();
            for (View view : networkView.getNodeViews()) {
                if (!((Boolean)network.getRow((CyIdentifiable)view.getModel()).get("selected", Boolean.class)).booleanValue() || !((Boolean)view.getVisualProperty(BasicVisualLexicon.NODE_VISIBLE)).booleanValue()) continue;
                nodeViews.add((View<CyNode>)view);
            }
            return nodeViews;
        }
        return CyLayoutAlgorithm.ALL_NODE_VIEWS;
    }

    private LocalNetworkViewTaskFactory wrapWithContext(CyLayoutAlgorithm layout, Object tunableContext) {
        return new LocalNetworkViewTaskFactory(layout, tunableContext);
    }

    private void setPanelsTransparent(JPanel panel) {
        if (LookAndFeelUtil.isAquaLAF()) {
            panel.setOpaque(false);
            for (int i = 0; i < panel.getComponentCount(); ++i) {
                Component c = panel.getComponent(i);
                if (!(c instanceof JPanel)) continue;
                this.setPanelsTransparent((JPanel)c);
            }
        }
    }

    private void saveLayoutContexts() {
        for (CyLayoutAlgorithm layout : this.tunablesToSave) {
            this.layoutSettingsMgr.saveLayoutContext(this.taskMgr, layout);
        }
        this.tunablesToSave.clear();
    }

    private class LayoutAlgorithmListCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1202339874266209L;
        private String defaultText;

        LayoutAlgorithmListCellRenderer(String defaultText) {
            this.defaultText = defaultText;
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            CyLayoutAlgorithm defaultLayout = ((CyLayoutAlgorithmManager)LayoutSettingsDialog.this.serviceRegistrar.getService(CyLayoutAlgorithmManager.class)).getDefaultLayout();
            if (value instanceof CyLayoutAlgorithm) {
                this.setHorizontalAlignment(2);
                if (value.equals(defaultLayout)) {
                    Color color = UIManager.getColor("List.selectionBackground");
                    if (color == null) {
                        color = Color.BLUE;
                    }
                    String htmlHex = String.format("%06X", 0xFFFFFF & color.getRGB());
                    this.setText(String.format("<html>%s <font color=%s><b>(default)</b></font></html>", value.toString(), htmlHex));
                } else {
                    this.setText(value.toString());
                }
            } else {
                this.setText(this.defaultText);
                this.setHorizontalAlignment(0);
            }
            return this;
        }
    }

    public static class LayoutNodeAttributeTunable {
        @Tunable(description="Node column to use:", gravity=1.0)
        public ListSingleSelection<String> layoutAttribute;
    }

    public static class LayoutEdgeAttributeTunable {
        @Tunable(description="Edge column that contains the weights:", gravity=1.0)
        public ListSingleSelection<String> layoutAttribute;
    }

    private class LocalNetworkViewTaskFactory
    implements NetworkViewTaskFactory {
        private final CyLayoutAlgorithm layout;
        private final Object tunableContext;
        private boolean selectedNodesOnly;

        public LocalNetworkViewTaskFactory(CyLayoutAlgorithm layout, Object tunableContext) {
            this.layout = layout;
            this.tunableContext = tunableContext;
        }

        public void setSelectedNodesOnly(boolean b) {
            this.selectedNodesOnly = b;
        }

        public boolean isReady(CyNetworkView networkView) {
            Set<View<CyNode>> nodes = LayoutSettingsDialog.getLayoutNodes(this.layout, networkView, this.selectedNodesOnly);
            return this.layout.isReady(networkView, this.tunableContext, nodes, LayoutSettingsDialog.this.getLayoutAttribute());
        }

        public TaskIterator createTaskIterator(CyNetworkView networkView) {
            Set<View<CyNode>> nodes = LayoutSettingsDialog.getLayoutNodes(this.layout, networkView, this.selectedNodesOnly);
            return this.layout.createTaskIterator(networkView, this.tunableContext, nodes, LayoutSettingsDialog.this.getLayoutAttribute());
        }
    }
}

