/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionIO {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T read(File file, Class<T> type) {
        Object obj = null;
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            JAXBContext jaxbContext = JAXBContext.newInstance((String)type.getPackage().getName(), (ClassLoader)this.getClass().getClassLoader());
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            obj = unmarshaller.unmarshal((InputStream)is);
        }
        catch (Exception e) {
            logger.error("Read error for " + type, (Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException iOException) {}
            }
        }
        return (T)obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void write(T obj, File file) {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            JAXBContext jc = JAXBContext.newInstance((String)obj.getClass().getPackage().getName(), (ClassLoader)this.getClass().getClassLoader());
            Marshaller m = jc.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            m.marshal(obj, (OutputStream)out);
        }
        catch (Exception e) {
            logger.error("Write error for " + obj, (Throwable)e);
        }
        finally {
            if (out != null) {
                try {
                    ((OutputStream)out).close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

