/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import org.cytoscape.event.CyEvent;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.internal.dialogs.PreferenceTableModel;
import org.cytoscape.internal.dialogs.PreferenceValueDialog;
import org.cytoscape.property.CyProperty;
import org.cytoscape.property.PropertyUpdatedEvent;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.util.swing.TextIcon;

public class PreferencesDialog
extends JDialog
implements ItemListener,
ActionListener,
ListSelectionListener {
    private Map<String, Properties> propMap = new HashMap<String, Properties>();
    private Map<String, CyProperty<?>> cyPropMap;
    private Map<String, Boolean> itemChangedMap = new HashMap<String, Boolean>();
    private JComboBox<String> cmbPropCategories = new JComboBox();
    private JScrollPane propsTablePane = new JScrollPane();
    private JTable prefsTable = new JTable();
    private JButton addPropBtn = new JButton("Add");
    private JButton deletePropBtn = new JButton("Delete");
    private JButton modifyPropBtn = new JButton("Modify");
    private JButton closeButton;
    private final CyServiceRegistrar serviceRegistrar;

    public PreferencesDialog(Window owner, Map<String, Properties> propMap, Map<String, CyProperty<?>> cyPropMap, CyServiceRegistrar serviceRegistrar) {
        super(owner, Dialog.ModalityType.APPLICATION_MODAL);
        this.propMap = propMap;
        this.cyPropMap = cyPropMap;
        this.serviceRegistrar = serviceRegistrar;
        for (String key : propMap.keySet()) {
            this.itemChangedMap.put(key, false);
        }
        try {
            this.init();
            this.addListeners();
            this.modifyPropBtn.setEnabled(false);
            this.deletePropBtn.setEnabled(false);
            this.initTable();
            this.initCMB();
            this.updateTable();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setTitle("Cytoscape Preferences Editor");
        this.setMinimumSize(new Dimension(520, 440));
        this.pack();
        this.setLocationRelativeTo(owner);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.updateTable();
    }

    private void initCMB() {
        Object[] keys = this.propMap.keySet().toArray(new String[this.propMap.keySet().size()]);
        Arrays.sort(keys);
        DefaultComboBoxModel<Object> cmbModel = new DefaultComboBoxModel<Object>(keys);
        this.cmbPropCategories.setModel(cmbModel);
        String key = "cytoscape 3";
        int index = 0;
        for (int i = 0; i < keys.length; ++i) {
            if (!((String)keys[i]).toString().equalsIgnoreCase(key)) continue;
            index = i;
            break;
        }
        this.cmbPropCategories.setSelectedIndex(index);
    }

    private void initTable() {
        DefaultTableColumnModel cm = new DefaultTableColumnModel();
        for (int i = 0; i < PreferenceTableModel.columnHeader.length; ++i) {
            DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
            renderer.setHorizontalAlignment(PreferenceTableModel.alignment[i]);
            TableColumn Column = new TableColumn(i, PreferenceTableModel.columnWidth[i], renderer, null);
            Column.setIdentifier(PreferenceTableModel.columnHeader[i]);
            cm.addColumn(Column);
        }
        this.prefsTable.setColumnModel(cm);
        this.prefsTable.getSelectionModel().setSelectionMode(0);
        this.prefsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && !e.isConsumed()) {
                    e.consume();
                    if (PreferencesDialog.this.prefsTable.getSelectedRow() >= 0 && PreferencesDialog.this.modifyPropBtn.isEnabled()) {
                        PreferencesDialog.this.modifyPropBtn.doClick();
                    }
                }
            }
        });
        final Color bg1 = UIManager.getColor("Table.background");
        Color altBg = UIManager.getColor("Table.alternateRowColor");
        final Color bg2 = altBg.getAlpha() != 0 ? altBg : new Color(altBg.getRed(), altBg.getGreen(), altBg.getBlue(), 255);
        this.prefsTable.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (!isSelected) {
                    this.setBackground(row % 2 == 0 ? bg1 : bg2);
                }
                return this;
            }
        });
    }

    private void updateTable() {
        if (this.cmbPropCategories.getSelectedItem() == null) {
            return;
        }
        String selectedPropertyName = this.cmbPropCategories.getSelectedItem().toString();
        Properties prop = this.propMap.get(selectedPropertyName);
        PreferenceTableModel m = new PreferenceTableModel(prop);
        this.prefsTable.setModel(m);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        String selectedPropertyName = this.cmbPropCategories.getSelectedItem().toString();
        if (obj instanceof JButton) {
            String value;
            String key;
            JButton btn = (JButton)obj;
            if (btn == this.deletePropBtn) {
                int[] selectedIndices = this.prefsTable.getSelectedRows();
                for (int i = selectedIndices.length - 1; i >= 0; --i) {
                    String name = new String((String)this.prefsTable.getModel().getValueAt(selectedIndices[i], 0));
                    PreferenceTableModel m = (PreferenceTableModel)this.prefsTable.getModel();
                    m.deleteProperty(name);
                    this.itemChangedMap.put(selectedPropertyName, true);
                }
            } else if (btn == this.modifyPropBtn) {
                int[] selectedIndices = this.prefsTable.getSelectedRows();
                for (int i = selectedIndices.length - 1; i >= 0; --i) {
                    String name = new String((String)this.prefsTable.getModel().getValueAt(selectedIndices[i], 0));
                    String value2 = new String((String)this.prefsTable.getModel().getValueAt(selectedIndices[i], 1));
                    PreferenceTableModel m = (PreferenceTableModel)this.prefsTable.getModel();
                    PreferenceValueDialog pd = new PreferenceValueDialog(this, name, value2, m, "Modify Property Value");
                    if (!pd.itemChanged) continue;
                    this.itemChangedMap.put(selectedPropertyName, true);
                }
            } else if (btn == this.addPropBtn && (key = JOptionPane.showInputDialog(this.addPropBtn, "Enter property name:", "Add Property", 3)) != null && (value = JOptionPane.showInputDialog(this.addPropBtn, "Enter value for property " + key + ":", "Add Property Value", 3)) != null) {
                String[] vals = new String[]{key, value};
                PreferenceTableModel m = (PreferenceTableModel)this.prefsTable.getModel();
                m.addProperty(vals);
                this.itemChangedMap.put(selectedPropertyName, true);
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (this.prefsTable.getSelectedRowCount() == 0) {
            this.modifyPropBtn.setEnabled(false);
            this.deletePropBtn.setEnabled(false);
        } else {
            this.modifyPropBtn.setEnabled(true);
            this.deletePropBtn.setEnabled(true);
        }
    }

    private void addListeners() {
        this.addPropBtn.addActionListener(this);
        this.modifyPropBtn.addActionListener(this);
        this.deletePropBtn.addActionListener(this);
        this.cmbPropCategories.addItemListener(this);
        this.prefsTable.getSelectionModel().addListSelectionListener(this);
    }

    private void init() throws Exception {
        Font iconFont = ((IconManager)this.serviceRegistrar.getService(IconManager.class)).getIconFont(16.0f);
        this.addPropBtn.setIcon((Icon)new TextIcon("\uf067", iconFont, 16, 16));
        this.deletePropBtn.setIcon((Icon)new TextIcon("\uf014", iconFont, 16, 16));
        this.closeButton = new JButton(new AbstractAction("Close"){

            @Override
            public void actionPerformed(ActionEvent e) {
                CyEventHelper eventHelper = (CyEventHelper)PreferencesDialog.this.serviceRegistrar.getService(CyEventHelper.class);
                for (String key : PreferencesDialog.this.itemChangedMap.keySet()) {
                    if (!PreferencesDialog.this.itemChangedMap.get(key).booleanValue()) continue;
                    PropertyUpdatedEvent event = new PropertyUpdatedEvent(PreferencesDialog.this.cyPropMap.get(key));
                    eventHelper.fireEvent((CyEvent)event);
                    PreferencesDialog.this.itemChangedMap.put(key, false);
                }
                PreferencesDialog.this.dispose();
            }
        });
        this.propsTablePane.getViewport().add((Component)this.prefsTable, null);
        this.prefsTable.setPreferredScrollableViewportSize(new Dimension(700, 500));
        JPanel propsTablePanel = new JPanel();
        propsTablePanel.setBorder(LookAndFeelUtil.createTitledBorder((String)"Properties"));
        GroupLayout layout = new GroupLayout(propsTablePanel);
        propsTablePanel.setLayout(layout);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(true);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addComponent(this.cmbPropCategories, -2, -1, 400).addComponent(this.propsTablePane, 400, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.CENTER, layout.createSequentialGroup().addComponent(this.addPropBtn).addComponent(this.modifyPropBtn).addComponent(this.deletePropBtn)));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.cmbPropCategories, -2, -1, -2).addComponent(this.propsTablePane, 200, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.addPropBtn).addComponent(this.modifyPropBtn).addComponent(this.deletePropBtn)));
        JPanel contentPane = new JPanel();
        GroupLayout layout2 = new GroupLayout(contentPane);
        contentPane.setLayout(layout2);
        layout2.setAutoCreateContainerGaps(true);
        layout2.setAutoCreateGaps(true);
        JPanel buttonPanel = LookAndFeelUtil.createOkCancelPanel(null, (JButton)this.closeButton, (String)"Linkout");
        layout2.setHorizontalGroup(layout2.createParallelGroup(GroupLayout.Alignment.TRAILING, true).addComponent(propsTablePanel, -1, -1, Short.MAX_VALUE).addComponent(buttonPanel, -1, -1, Short.MAX_VALUE));
        layout2.setVerticalGroup(layout2.createSequentialGroup().addComponent(propsTablePanel, -1, -1, Short.MAX_VALUE).addComponent(buttonPanel));
        LookAndFeelUtil.equalizeSize((JComponent[])new JComponent[]{this.addPropBtn, this.modifyPropBtn, this.deletePropBtn});
        this.setContentPane(contentPane);
        LookAndFeelUtil.setDefaultOkCancelKeyStrokes((JRootPane)this.getRootPane(), (Action)this.closeButton.getAction(), (Action)this.closeButton.getAction());
        this.getRootPane().setDefaultButton(this.closeButton);
    }
}

