/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal.dialogs;

import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import org.cytoscape.internal.dialogs.PreferenceTableModel;
import org.cytoscape.util.swing.LookAndFeelUtil;

public class PreferenceValueDialog
extends JDialog {
    private static final long serialVersionUID = 1202339873382923L;
    private String preferenceName;
    private String preferenceValue;
    private JLabel preferenceNameLbl;
    private JTextField valueTxt;
    private JButton okBtn;
    private JButton cancelBtn;
    private PreferenceTableModel tableModel;
    boolean itemChanged;

    public PreferenceValueDialog(JDialog owner, String name, String value, PreferenceTableModel tm, String title) {
        super((Window)owner, title, Dialog.ModalityType.APPLICATION_MODAL);
        this.tableModel = tm;
        this.preferenceName = name;
        this.preferenceValue = value;
        this.init();
        this.setResizable(false);
        this.setLocationRelativeTo(owner);
        this.setVisible(true);
    }

    protected void init() {
        this.preferenceNameLbl = new JLabel(this.preferenceName + ":");
        this.valueTxt = new JTextField(this.preferenceValue, 32);
        this.okBtn = new JButton(new AbstractAction("OK"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreferenceValueDialog.this.tableModel.setProperty(PreferenceValueDialog.this.preferenceName, PreferenceValueDialog.this.valueTxt.getText());
                PreferenceValueDialog.this.itemChanged = true;
                PreferenceValueDialog.this.dispose();
            }
        });
        this.cancelBtn = new JButton(new AbstractAction("Cancel"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreferenceValueDialog.this.dispose();
            }
        });
        JPanel buttonPnl = LookAndFeelUtil.createOkCancelPanel((JButton)this.okBtn, (JButton)this.cancelBtn);
        JPanel contentPane = new JPanel();
        GroupLayout layout = new GroupLayout(contentPane);
        contentPane.setLayout(layout);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(true);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, true).addGroup(layout.createSequentialGroup().addComponent(this.preferenceNameLbl).addComponent(this.valueTxt)).addComponent(buttonPnl));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.preferenceNameLbl).addComponent(this.valueTxt)).addComponent(buttonPnl));
        this.setContentPane(contentPane);
        LookAndFeelUtil.setDefaultOkCancelKeyStrokes((JRootPane)this.getRootPane(), (Action)this.okBtn.getAction(), (Action)this.cancelBtn.getAction());
        this.getRootPane().setDefaultButton(this.okBtn);
        this.pack();
    }
}

