/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal.dialogs;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import org.cytoscape.internal.dialogs.StringComparator;

public class PreferenceTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1202339873369342L;
    static int[] columnWidth = new int[]{150, 250};
    static int[] alignment = new int[]{2, 2};
    private Properties properties;
    Vector<String[]> propertiesList = new Vector();
    static String[] columnHeader = new String[]{"Property Name", "Value"};

    public PreferenceTableModel(Properties props) {
        this.properties = props;
        this.loadProperties();
    }

    public void loadProperties() {
        this.clearVector();
        Enumeration<?> names = this.properties.propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            this.addProperty(new String[]{name, this.properties.getProperty(name)});
        }
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public String getProperty(String key, String defaultValue) {
        return this.properties.getProperty(key, defaultValue);
    }

    public void setProperty(String key, String value) {
        this.properties.setProperty(key, value);
        for (String[] prop : this.propertiesList) {
            if (!prop[0].equals(key)) continue;
            prop[1] = value;
        }
        this.fireTableDataChanged();
    }

    public void deleteProperty(String key) {
        this.properties.remove(key);
        for (int i = this.propertiesList.size() - 1; i >= 0; --i) {
            String[] prop = this.propertiesList.get(i);
            if (!prop[0].equals(key)) continue;
            this.propertiesList.remove(prop);
        }
        this.fireTableDataChanged();
    }

    public void addProperty(String[] val) {
        if (val.length < 0 || val.length > columnHeader.length) {
            return;
        }
        boolean found = false;
        for (String[] prop : this.propertiesList) {
            if (!prop[0].equals(val[0])) continue;
            prop[1] = val[1];
            found = true;
        }
        if (!found) {
            this.propertiesList.add(val);
        }
        this.sort();
        this.properties.setProperty(val[0], val[1]);
        this.fireTableDataChanged();
    }

    @Override
    public String getColumnName(int col) {
        return columnHeader[col];
    }

    public void clearVector() {
        this.propertiesList.clear();
    }

    public void save(Properties saveToProps) {
        saveToProps.putAll((Map<?, ?>)this.properties);
    }

    public void restore(Properties restoreFromProps) {
        this.properties.clear();
        this.properties.putAll((Map<?, ?>)restoreFromProps);
        this.loadProperties();
    }

    @Override
    public int getColumnCount() {
        return columnHeader.length;
    }

    @Override
    public Object getValueAt(int row, int col) {
        String[] rowData = this.propertiesList.get(row);
        return rowData[col];
    }

    @Override
    public int getRowCount() {
        return this.propertiesList.size();
    }

    public void sort() {
        Collections.sort(this.propertiesList, new StringComparator());
    }
}

