/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal.dialogs;

import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import org.cytoscape.internal.dialogs.BookmarkDialog;
import org.cytoscape.internal.view.util.ViewUtil;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.session.events.SessionLoadedEvent;
import org.cytoscape.session.events.SessionLoadedListener;

public class BookmarkDialogFactory
implements SessionLoadedListener {
    private BookmarkDialog dialog;
    private final CyServiceRegistrar serviceRegistrar;

    public BookmarkDialogFactory(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
    }

    public BookmarkDialog getBookmarkDialog(Window owner) {
        if (this.dialog == null) {
            this.dialog = new BookmarkDialog(owner, this.serviceRegistrar);
            this.dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    BookmarkDialogFactory.this.dialog = null;
                }
            });
        }
        return this.dialog;
    }

    public void handleEvent(SessionLoadedEvent e) {
        ViewUtil.invokeOnEDT(() -> {
            if (this.dialog != null) {
                this.dialog.loadBookmarks();
            }
        });
    }

    public boolean isDialogVisible() {
        return this.dialog != null && this.dialog.isVisible();
    }
}

