/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal.command;

import javax.swing.JFrame;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.util.swing.MessageDialogs;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;

public class PauseCommandTask
extends AbstractTask {
    private final CySwingApplication swingApplication;
    @Tunable(description="Message to show user (will wait until user responds)", exampleStringValue="Press OK to continue")
    public String message = null;

    @ProvidesTitle
    public String getTitle() {
        return "Exiting Cytoscape";
    }

    public PauseCommandTask(CySwingApplication swingApplication) {
        this.swingApplication = swingApplication;
    }

    public void run(TaskMonitor taskMonitor) {
        if (this.message == null || this.message.isEmpty()) {
            this.message = "Press OK to continue";
        }
        JFrame parent = this.swingApplication.getJFrame();
        taskMonitor.showMessage(TaskMonitor.Level.INFO, "Paused...");
        MessageDialogs.showMessageDialog((JFrame)parent, (String)"Paused", (String)this.message);
        taskMonitor.showMessage(TaskMonitor.Level.INFO, "continuing");
    }
}

