/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal.command;

import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Element;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import org.cytoscape.internal.command.MessageHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JResultsPane
extends JTextPane
implements MessageHandler {
    private static final Logger logger = LoggerFactory.getLogger(JResultsPane.class);
    private String commandAttributes;
    private String messageAttributes;
    private String resultAttributes;
    private String errorAttributes;
    private String warningAttributes;
    private HTMLDocument currentDocument;
    private Element rootElement;
    private final JDialog parentDialog;
    private final JPanel dataPanel;
    private JScrollPane scrollPane = null;
    private static String BLUE = "color:blue";
    private static String RED = "color:red";
    private static String GREEN = "color:green";
    private static String ORANGE = "color:orange";
    private static String BLACK = "color:black";
    private static String BOLD = "font-weight:bold";
    private static String ITALICS = "font-style:italic";
    private static String DEFAULT_STYLE = "margin-top:0px;margin-bottom:0px";

    public JResultsPane(JDialog parentDialog, JPanel dataPanel) {
        this.parentDialog = parentDialog;
        this.dataPanel = dataPanel;
        DefaultCaret caret = (DefaultCaret)this.getCaret();
        caret.setUpdatePolicy(2);
        this.setContentType("text/html");
        this.currentDocument = (HTMLDocument)this.getDocument();
        this.rootElement = this.currentDocument.getDefaultRootElement();
        this.commandAttributes = BLUE + ";" + BOLD + ";" + ITALICS;
        this.messageAttributes = BLUE + ";margin-left:10px";
        this.errorAttributes = RED;
        this.warningAttributes = ORANGE;
        this.resultAttributes = GREEN + ";" + BOLD + ";" + ITALICS;
    }

    @Override
    public void appendCommand(String s) {
        this.updateString(this.commandAttributes, s);
    }

    @Override
    public void appendError(String s) {
        this.updateString(this.errorAttributes, s);
    }

    @Override
    public void appendResult(String s) {
        String[] splitString = s.split("\n");
        if (splitString.length > 1) {
            for (String splitS : splitString) {
                this.updateString(this.resultAttributes, "\u2192  " + splitS + "\n");
            }
        } else {
            this.updateString(this.resultAttributes, "\u2192  " + s + "\n");
        }
    }

    @Override
    public void appendWarning(String s) {
        this.updateString(this.warningAttributes, s);
    }

    @Override
    public void appendMessage(String s) {
        this.updateString(this.messageAttributes, s);
    }

    public void setScrollPane(JScrollPane scrollPane) {
        this.scrollPane = scrollPane;
    }

    public void clear() {
        this.currentDocument = (HTMLDocument)new HTMLEditorKit().createDefaultDocument();
        this.setStyledDocument(this.currentDocument);
        this.rootElement = this.currentDocument.getDefaultRootElement();
    }

    private void updateString(final String style, final String s) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JResultsPane.this.updateStringImmediate(style, s);
                }
            });
        } else {
            this.updateStringImmediate(style, s);
        }
    }

    private void updateStringImmediate(String style, String s) {
        try {
            String p = "<div style='" + DEFAULT_STYLE + ";" + style + "'>" + s + "</div>\n";
            this.currentDocument.insertBeforeEnd(this.rootElement, p);
            this.setCaretPosition(this.currentDocument.getLength());
            this.paintImmediately(this.getBounds());
            if (this.parentDialog != null) {
                this.parentDialog.revalidate();
            }
            this.dataPanel.paintImmediately(this.dataPanel.getBounds());
        }
        catch (Exception e) {
            logger.error("Unable to update command result in the dialog.", (Throwable)e);
        }
        JScrollBar verticalScrollBar = this.scrollPane.getVerticalScrollBar();
        verticalScrollBar.setValue(verticalScrollBar.getMaximum());
    }
}

