/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal.command;

import java.util.Arrays;
import org.cytoscape.command.AvailableCommands;
import org.cytoscape.command.CommandExecutorTaskFactory;
import org.cytoscape.internal.command.HelpGenerator;
import org.cytoscape.internal.command.MessageHandler;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.work.FinishStatus;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.TaskObserver;

public class CommandTaskRunner {
    private final CyServiceRegistrar serviceRegistrar;

    public CommandTaskRunner(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
    }

    public void runCommand(String command, MessageHandler messageHandler) {
        String[] tokens = command.split(" ");
        if (tokens.length >= 1 && tokens[0].equals("help")) {
            AvailableCommands availableCommands = (AvailableCommands)this.serviceRegistrar.getService(AvailableCommands.class);
            HelpGenerator helpGenerator = new HelpGenerator(availableCommands);
            helpGenerator.generateHelpHTML(command, messageHandler);
        } else {
            this.runTasks(command, messageHandler);
        }
    }

    private void runTasks(String command, final MessageHandler messageHandler) {
        CommandExecutorTaskFactory commandFactory = (CommandExecutorTaskFactory)this.serviceRegistrar.getService(CommandExecutorTaskFactory.class);
        TaskIterator taskIterator = commandFactory.createTaskIterator(Arrays.asList(command), new TaskObserver(){

            public void taskFinished(ObservableTask task) {
                Object result = task.getResults(String.class);
                if (result != null) {
                    messageHandler.appendResult(result.toString());
                }
            }

            public void allFinished(FinishStatus status) {
                messageHandler.appendCommand(status.getType().toString());
            }
        });
        while (taskIterator.hasNext()) {
            Task task = taskIterator.next();
            try {
                task.run(new TaskMonitor(){

                    public void showMessage(TaskMonitor.Level level, String message, int wait) {
                        this.showMessage(level, message);
                    }

                    public void showMessage(TaskMonitor.Level level, String message) {
                        switch (level) {
                            default: {
                                messageHandler.appendError(message);
                                break;
                            }
                            case INFO: {
                                messageHandler.appendMessage(message);
                                break;
                            }
                            case WARN: {
                                messageHandler.appendWarning(message);
                            }
                        }
                    }

                    public void setTitle(String title) {
                    }

                    public void setStatusMessage(String statusMessage) {
                    }

                    public void setProgress(double progress) {
                    }
                });
            }
            catch (Exception e) {
                messageHandler.appendError("Error handling command \"" + e.getMessage());
            }
        }
    }
}

