/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.Icon;
import javax.swing.event.MenuEvent;
import org.cytoscape.application.swing.AbstractCyAction;
import org.cytoscape.internal.view.CytoscapeDesktop;

public class StarterPanelAction
extends AbstractCyAction {
    private static String TITLE = "Show Starter Panel";
    private final CytoscapeDesktop desktop;

    public StarterPanelAction(float menuGravity, CytoscapeDesktop desktop) {
        super(TITLE);
        this.desktop = desktop;
        this.setPreferredMenu("View");
        this.setMenuGravity(menuGravity);
        this.insertSeparatorBefore = true;
        this.useCheckBoxMenuItem = true;
    }

    public StarterPanelAction(float toolbarGravity, Icon icon, CytoscapeDesktop desktop) {
        super(TITLE);
        this.desktop = desktop;
        this.putValue("SwingLargeIconKey", icon);
        this.putValue("ShortDescription", TITLE);
        this.setIsInToolBar(true);
        this.setToolbarGravity(toolbarGravity);
        this.useToggleButton = true;
        desktop.getStarterPanel().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                StarterPanelAction.this.updateEnableState();
            }

            @Override
            public void componentShown(ComponentEvent e) {
                StarterPanelAction.this.updateEnableState();
            }
        });
    }

    public void actionPerformed(ActionEvent evt) {
        if (this.desktop.isStarterPanelVisible()) {
            this.desktop.hideStarterPanel();
        } else {
            this.desktop.showStarterPanel();
        }
    }

    public void menuSelected(MenuEvent evt) {
        this.updateEnableState();
    }

    public void updateEnableState() {
        super.updateEnableState();
        this.putValue("SwingSelectedKey", this.desktop.isStarterPanelVisible());
    }
}

