/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.URI;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.swing.JOptionPane;
import org.cytoscape.application.events.CyShutdownEvent;
import org.cytoscape.application.events.CyShutdownListener;
import org.cytoscape.application.swing.AbstractCyAction;
import org.cytoscape.application.swing.CyAction;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.internal.view.util.ViewUtil;
import org.cytoscape.io.util.RecentlyOpenedTracker;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.CyTableManager;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.session.events.SessionLoadedEvent;
import org.cytoscape.session.events.SessionLoadedListener;
import org.cytoscape.task.read.OpenSessionTaskFactory;
import org.cytoscape.work.swing.DialogTaskManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecentSessionManager
implements SessionLoadedListener,
CyShutdownListener {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private static final String MENU_CATEGORY = "File.Open Recent Session[1.2]";
    private final Set<OpenRecentSessionAction> currentMenuItems;
    private final ClearMenuAction clearMenuAction;
    private final CyServiceRegistrar serviceRegistrar;

    public RecentSessionManager(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
        this.currentMenuItems = new HashSet<OpenRecentSessionAction>();
        this.clearMenuAction = new ClearMenuAction();
        serviceRegistrar.registerAllServices((Object)this.clearMenuAction, new Properties());
        ViewUtil.invokeOnEDT(() -> this.updateMenuItems());
    }

    private void updateMenuItems() {
        for (OpenRecentSessionAction currentItem : this.currentMenuItems) {
            this.serviceRegistrar.unregisterAllServices((Object)currentItem);
        }
        this.currentMenuItems.clear();
        RecentlyOpenedTracker tracker = (RecentlyOpenedTracker)this.serviceRegistrar.getService(RecentlyOpenedTracker.class);
        List urls = tracker.getRecentlyOpenedURLs();
        float gravity = 0.0f;
        for (URL url : urls) {
            File file = null;
            try {
                URI uri = url.toURI();
                file = new File(uri);
            }
            catch (Exception e) {
                logger.error("Invalid recent file URL.", (Throwable)e);
                continue;
            }
            float f = gravity;
            gravity = f + 1.0f;
            OpenRecentSessionAction action = new OpenRecentSessionAction(f / 6.0f, file);
            this.serviceRegistrar.registerService((Object)action, CyAction.class, new Properties());
            this.currentMenuItems.add(action);
        }
        this.clearMenuAction.updateEnableState();
    }

    public void handleEvent(SessionLoadedEvent e) {
        ViewUtil.invokeOnEDT(() -> this.updateMenuItems());
    }

    public void handleEvent(CyShutdownEvent e) {
        RecentlyOpenedTracker tracker = (RecentlyOpenedTracker)this.serviceRegistrar.getService(RecentlyOpenedTracker.class);
        try {
            tracker.writeOut();
        }
        catch (FileNotFoundException ex) {
            logger.error("Could not save recently opened session file list.", (Throwable)ex);
        }
    }

    private final class ClearMenuAction
    extends AbstractCyAction {
        public ClearMenuAction() {
            super("Clear Menu");
            this.setPreferredMenu(RecentSessionManager.MENU_CATEGORY);
            this.insertSeparatorBefore = true;
            this.setMenuGravity(10001.0f);
        }

        public boolean isEnabled() {
            return !RecentSessionManager.this.currentMenuItems.isEmpty();
        }

        public void actionPerformed(ActionEvent e) {
            RecentlyOpenedTracker tracker = (RecentlyOpenedTracker)RecentSessionManager.this.serviceRegistrar.getService(RecentlyOpenedTracker.class);
            tracker.clear();
            RecentSessionManager.this.updateMenuItems();
        }
    }

    private final class OpenRecentSessionAction
    extends AbstractCyAction {
        private final File file;

        public OpenRecentSessionAction(float gravity, File file) {
            super(file.getAbsolutePath());
            this.setPreferredMenu(RecentSessionManager.MENU_CATEGORY);
            this.setMenuGravity(gravity);
            this.file = file;
        }

        public void actionPerformed(ActionEvent e) {
            if (this.file.exists()) {
                CyNetworkManager netManager = (CyNetworkManager)RecentSessionManager.this.serviceRegistrar.getService(CyNetworkManager.class);
                CyTableManager tableManager = (CyTableManager)RecentSessionManager.this.serviceRegistrar.getService(CyTableManager.class);
                if (netManager.getNetworkSet().isEmpty() && tableManager.getAllTables(false).isEmpty()) {
                    this.openSession();
                } else {
                    this.openSessionWithWarning();
                }
            } else {
                CySwingApplication swingApp = (CySwingApplication)RecentSessionManager.this.serviceRegistrar.getService(CySwingApplication.class);
                JOptionPane.showMessageDialog(swingApp.getJFrame(), "Session file not found:\n" + this.file.getAbsolutePath(), "File not Found", 2);
                RecentlyOpenedTracker tracker = (RecentlyOpenedTracker)RecentSessionManager.this.serviceRegistrar.getService(RecentlyOpenedTracker.class);
                try {
                    tracker.remove(this.file.toURI().toURL());
                    RecentSessionManager.this.updateMenuItems();
                }
                catch (Exception ex) {
                    logger.error("Error removing session file from RecentlyOpenedTracker.", (Throwable)ex);
                }
            }
        }

        private void openSession() {
            OpenSessionTaskFactory taskFactory = (OpenSessionTaskFactory)RecentSessionManager.this.serviceRegistrar.getService(OpenSessionTaskFactory.class);
            DialogTaskManager taskManager = (DialogTaskManager)RecentSessionManager.this.serviceRegistrar.getService(DialogTaskManager.class);
            taskManager.execute(taskFactory.createTaskIterator(this.file));
        }

        private void openSessionWithWarning() {
            CySwingApplication swingApp = (CySwingApplication)RecentSessionManager.this.serviceRegistrar.getService(CySwingApplication.class);
            if (JOptionPane.showConfirmDialog(swingApp.getJFrame(), "Current session (all networks and tables) will be lost.\nDo you want to continue?", "Open Session", 2) == 0) {
                this.openSession();
            }
        }
    }
}

