/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal.actions;

import java.awt.event.ActionEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.swing.AbstractCyAction;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.create.NewNetworkSelectedNodesAndEdgesTaskFactory;
import org.cytoscape.task.create.NewNetworkSelectedNodesOnlyTaskFactory;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.work.swing.DialogTaskManager;

public class NewNetworkFromSelectionAction
extends AbstractCyAction {
    private static final String TITLE = "New Network from Selection";
    private static final String DESCRIPTION = "Creates a new network (and view) that will contain the selected nodes and edges.";
    private final CyServiceRegistrar serviceRegistrar;

    public NewNetworkFromSelectionAction(float toolbarGravity, Icon icon, CyServiceRegistrar serviceRegistrar) {
        super(TITLE, (CyApplicationManager)serviceRegistrar.getService(CyApplicationManager.class), "selectedNodesOrEdges", (CyNetworkViewManager)serviceRegistrar.getService(CyNetworkViewManager.class));
        this.serviceRegistrar = serviceRegistrar;
        this.inToolBar = true;
        this.toolbarGravity = toolbarGravity;
        this.putValue("ShortDescription", TITLE);
        this.putValue("LongDescription", DESCRIPTION);
        this.putValue("SwingLargeIconKey", icon);
    }

    public void actionPerformed(ActionEvent e) {
        JComponent comp = e.getSource() instanceof JComponent ? (JComponent)e.getSource() : ((CySwingApplication)this.serviceRegistrar.getService(CySwingApplication.class)).getJToolBar();
        this.showPopupMenu(comp);
    }

    public void updateEnableState() {
        super.updateEnableState();
        if (this.isEnabled()) {
            CyNetwork network = this.getCurrentNetwork();
            NewNetworkSelectedNodesOnlyTaskFactory allEdgesTaskFactory = (NewNetworkSelectedNodesOnlyTaskFactory)this.serviceRegistrar.getService(NewNetworkSelectedNodesOnlyTaskFactory.class);
            NewNetworkSelectedNodesAndEdgesTaskFactory selectedEdgesFactory = (NewNetworkSelectedNodesAndEdgesTaskFactory)this.serviceRegistrar.getService(NewNetworkSelectedNodesAndEdgesTaskFactory.class);
            this.setEnabled(allEdgesTaskFactory.isReady(network) || selectedEdgesFactory.isReady(network));
        }
    }

    private void showPopupMenu(JComponent comp) {
        JPopupMenu popup = new JPopupMenu();
        DialogTaskManager taskManager = (DialogTaskManager)this.serviceRegistrar.getService(DialogTaskManager.class);
        CyNetwork network = this.getCurrentNetwork();
        NewNetworkSelectedNodesOnlyTaskFactory factory = (NewNetworkSelectedNodesOnlyTaskFactory)this.serviceRegistrar.getService(NewNetworkSelectedNodesOnlyTaskFactory.class);
        JMenuItem mi = new JMenuItem("From Selected Nodes, All Edges");
        mi.addActionListener(evt -> taskManager.execute(factory.createTaskIterator(network)));
        mi.setEnabled(factory.isReady(network));
        popup.add(mi);
        factory = (NewNetworkSelectedNodesAndEdgesTaskFactory)this.serviceRegistrar.getService(NewNetworkSelectedNodesAndEdgesTaskFactory.class);
        mi = new JMenuItem("From Selected Nodes, Selected Edges");
        mi.addActionListener(arg_0 -> this.lambda$showPopupMenu$1(taskManager, (NewNetworkSelectedNodesAndEdgesTaskFactory)factory, arg_0));
        mi.setEnabled(factory.isReady(network));
        popup.add(mi);
        popup.show(comp, 0, comp.getSize().height);
    }

    private CyNetwork getCurrentNetwork() {
        return ((CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class)).getCurrentNetwork();
    }

    private /* synthetic */ void lambda$showPopupMenu$1(DialogTaskManager taskManager, NewNetworkSelectedNodesAndEdgesTaskFactory factory, ActionEvent evt) {
        taskManager.execute(factory.createTaskIterator(this.getCurrentNetwork()));
    }
}

