/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal.actions;

import java.awt.event.ActionEvent;
import java.util.Set;
import javax.swing.event.PopupMenuEvent;
import org.cytoscape.application.swing.AbstractCyAction;
import org.cytoscape.internal.view.NetworkMainPanel;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.destroy.DestroyNetworkTaskFactory;
import org.cytoscape.work.swing.DialogTaskManager;

public class DestroyNetworksAction
extends AbstractCyAction {
    private final NetworkMainPanel netPanel;
    private final CyServiceRegistrar serviceRegistrar;

    public DestroyNetworksAction(float menuGravity, NetworkMainPanel netPanel, CyServiceRegistrar serviceRegistrar) {
        super("Destroy Networks");
        this.netPanel = netPanel;
        this.serviceRegistrar = serviceRegistrar;
        this.setMenuGravity(menuGravity);
    }

    public void actionPerformed(ActionEvent e) {
        Set<CyNetwork> subNetworks = this.getSelectedSubNetworks();
        if (!subNetworks.isEmpty()) {
            DestroyNetworkTaskFactory factory = (DestroyNetworkTaskFactory)this.serviceRegistrar.getService(DestroyNetworkTaskFactory.class);
            DialogTaskManager taskManager = (DialogTaskManager)this.serviceRegistrar.getService(DialogTaskManager.class);
            taskManager.execute(factory.createTaskIterator(subNetworks));
        }
    }

    public void updateEnableState() {
        int colCount = this.netPanel.countSelectedRootNetworks();
        int netCount = this.netPanel.countSelectedSubNetworks(false);
        this.setEnabled(colCount > 0 || netCount > 0);
        this.setName("Destroy " + (colCount > 0 ? "Collection" : "") + (colCount > 1 ? "s" : "") + (colCount > 0 && netCount > 0 ? " and " : "") + (netCount > 0 ? "Network" : "") + (netCount > 1 ? "s" : ""));
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        this.updateEnableState();
    }

    private Set<CyNetwork> getSelectedSubNetworks() {
        return this.netPanel.getSelectedNetworks(true);
    }
}

