/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal.actions;

import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.List;
import javax.swing.event.PopupMenuEvent;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.swing.AbstractCyAction;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.destroy.DestroyNetworkViewTaskFactory;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.work.swing.DialogTaskManager;

public class DestroyNetworkViewsAction
extends AbstractCyAction {
    private final CyServiceRegistrar serviceRegistrar;

    public DestroyNetworkViewsAction(float menuGravity, CyServiceRegistrar serviceRegistrar) {
        super("Destroy Views");
        this.serviceRegistrar = serviceRegistrar;
        this.setMenuGravity(menuGravity);
    }

    public void actionPerformed(ActionEvent e) {
        List networks = ((CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class)).getSelectedNetworks();
        CyNetworkViewManager netViewManager = (CyNetworkViewManager)this.serviceRegistrar.getService(CyNetworkViewManager.class);
        HashSet views = new HashSet();
        for (CyNetwork n : networks) {
            views.addAll(netViewManager.getNetworkViews(n));
        }
        if (!views.isEmpty()) {
            DestroyNetworkViewTaskFactory factory = (DestroyNetworkViewTaskFactory)this.serviceRegistrar.getService(DestroyNetworkViewTaskFactory.class);
            DialogTaskManager taskManager = (DialogTaskManager)this.serviceRegistrar.getService(DialogTaskManager.class);
            taskManager.execute(factory.createTaskIterator(views));
        }
    }

    public void updateEnableState() {
        List networks = ((CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class)).getSelectedNetworks();
        CyNetworkViewManager netViewManager = (CyNetworkViewManager)this.serviceRegistrar.getService(CyNetworkViewManager.class);
        int count = 0;
        for (CyNetwork n : networks) {
            count += netViewManager.getNetworkViews(n).size();
        }
        if (count > 0) {
            this.setName("Destroy " + count + " View" + (count == 1 ? "" : "s"));
        } else {
            this.setName("Destroy Views");
        }
        this.setEnabled(count > 0);
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        this.updateEnableState();
    }
}

