/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal.actions;

import java.awt.Window;
import java.awt.event.ActionEvent;
import org.cytoscape.application.swing.AbstractCyAction;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.internal.dialogs.BookmarkDialog;
import org.cytoscape.internal.dialogs.BookmarkDialogFactory;
import org.cytoscape.internal.view.util.ViewUtil;

public class BookmarkAction
extends AbstractCyAction {
    private final CySwingApplication desktop;
    private final BookmarkDialogFactory dialogFactory;

    public BookmarkAction(CySwingApplication desktop, BookmarkDialogFactory dialogFactory) {
        super("Bookmarks...");
        this.dialogFactory = dialogFactory;
        this.setPreferredMenu("Edit.Preferences");
        this.setMenuGravity(2.0f);
        this.desktop = desktop;
    }

    public void actionPerformed(ActionEvent e) {
        Window owner = ViewUtil.getWindowAncestor(e, this.desktop);
        BookmarkDialog bookmarkDialog = this.dialogFactory.getBookmarkDialog(owner);
        bookmarkDialog.showDialog();
    }

    public boolean isEnabled() {
        return !this.dialogFactory.isDialogVisible();
    }
}

