/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.editor.internal;

import java.util.ArrayList;
import java.util.List;
import org.cytoscape.editor.internal.SIFInterpreterEdgeEdit;
import org.cytoscape.editor.internal.SIFInterpreterNodeEdit;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.AbstractNetworkViewTask;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.undo.AbstractCyEdit;
import org.cytoscape.work.undo.UndoSupport;

public class SIFInterpreterTask
extends AbstractNetworkViewTask {
    @Tunable(description="Type in a nodes/edges expression in SIF format (e.g. A inhibits B):")
    public String sifString;
    public static String interactionType;
    public static List<String> nodeNames;
    private final CyNetwork network;
    private final CyServiceRegistrar serviceRegistrar;
    private List<CyEdge> newEdges;
    private List<CyNode> newNodes;

    @ProvidesTitle
    public String getTitle() {
        return "SIF Interpreter";
    }

    public SIFInterpreterTask(CyNetworkView view, CyServiceRegistrar serviceRegistrar) {
        super(view);
        this.serviceRegistrar = serviceRegistrar;
        this.network = (CyNetwork)view.getModel();
    }

    public void run(TaskMonitor tm) {
        if (this.sifString == null) {
            throw new NullPointerException("SIF input string is null");
        }
        String[] terms = this.sifString.split("\\s");
        if (terms != null && terms.length > 0) {
            String name1 = terms[0].trim();
            if (!name1.equals(null)) {
                CyNode node1 = this.findNode(terms[0]);
                if (node1 == null) {
                    node1 = this.network.addNode();
                    this.network.getRow((CyIdentifiable)node1).set("name", (Object)terms[0]);
                    nodeNames.add(terms[0]);
                    this.newNodes = new ArrayList<CyNode>();
                    this.newNodes.add(node1);
                    UndoSupport undoSupport = (UndoSupport)this.serviceRegistrar.getService(UndoSupport.class);
                    undoSupport.postEdit((AbstractCyEdit)new SIFInterpreterNodeEdit(this.network, this.newNodes));
                }
                if (terms.length == 3) {
                    CyNode node2 = this.findNode(terms[2]);
                    interactionType = terms[1];
                    if (node2 == null) {
                        node2 = this.network.addNode();
                        this.network.getRow((CyIdentifiable)node2).set("name", (Object)terms[2]);
                        nodeNames.add(terms[2]);
                        this.newNodes = new ArrayList<CyNode>();
                        this.newNodes.add(node2);
                        UndoSupport undoSupport = (UndoSupport)this.serviceRegistrar.getService(UndoSupport.class);
                        undoSupport.postEdit((AbstractCyEdit)new SIFInterpreterNodeEdit(this.network, this.newNodes));
                    }
                    CyEdge edge = this.network.addEdge(node1, node2, true);
                    this.network.getRow((CyIdentifiable)edge).set("name", (Object)terms[1]);
                    this.newEdges = new ArrayList<CyEdge>();
                    this.newEdges.add(edge);
                    UndoSupport undoSupport = (UndoSupport)this.serviceRegistrar.getService(UndoSupport.class);
                    undoSupport.postEdit((AbstractCyEdit)new SIFInterpreterEdgeEdit(this.network, this.newEdges));
                } else if (terms.length > 3) {
                    ArrayList nodeViews = new ArrayList();
                    interactionType = terms[1];
                    for (int i = 2; i < terms.length; ++i) {
                        CyNode node2 = this.findNode(terms[i]);
                        if (node2 == null) {
                            node2 = this.network.addNode();
                            this.network.getRow((CyIdentifiable)node2).set("name", (Object)terms[i]);
                            nodeNames.add(terms[i]);
                            this.newNodes = new ArrayList<CyNode>();
                            this.newNodes.add(node2);
                            UndoSupport undoSupport = (UndoSupport)this.serviceRegistrar.getService(UndoSupport.class);
                            undoSupport.postEdit((AbstractCyEdit)new SIFInterpreterNodeEdit(this.network, this.newNodes));
                        }
                        CyEdge edge = this.network.addEdge(node1, node2, true);
                        this.network.getRow((CyIdentifiable)edge).set("name", (Object)terms[1]);
                        this.newEdges = new ArrayList<CyEdge>();
                        this.newEdges.add(edge);
                        UndoSupport undoSupport = (UndoSupport)this.serviceRegistrar.getService(UndoSupport.class);
                        undoSupport.postEdit((AbstractCyEdit)new SIFInterpreterEdgeEdit(this.network, this.newEdges));
                    }
                }
            }
            CyEventHelper eventHelper = (CyEventHelper)this.serviceRegistrar.getService(CyEventHelper.class);
            eventHelper.flushPayloadEvents();
            VisualMappingManager vmMgr = (VisualMappingManager)this.serviceRegistrar.getService(VisualMappingManager.class);
            VisualStyle vs = vmMgr.getVisualStyle(this.view);
            vs.apply(this.view);
            this.view.updateView();
        }
    }

    public void cancel() {
    }

    private void doCircleLayout(List<View<CyNode>> nodeViews, View<CyNode> nv1) {
    }

    private CyNode findNode(String name) {
        for (CyNode node : this.network.getNodeList()) {
            if (!((String)this.network.getRow((CyIdentifiable)node).get("name", String.class)).equals(name)) continue;
            return node;
        }
        return null;
    }

    static {
        nodeNames = new ArrayList<String>();
    }
}

