/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.editor.internal;

import java.util.ArrayList;
import java.util.List;
import org.cytoscape.editor.internal.SIFInterpreterTask;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.work.undo.AbstractCyEdit;

public class SIFInterpreterEdgeEdit
extends AbstractCyEdit {
    private CyNetwork network;
    private List<CyEdge> edges;

    public SIFInterpreterEdgeEdit(CyNetwork network, List<CyEdge> edges) {
        super("SIF Adding Edges");
        this.network = network;
        this.edges = edges;
    }

    public void redo() {
        ArrayList<CyEdge> newEdges = new ArrayList<CyEdge>(this.edges.size());
        for (CyEdge edge : this.edges) {
            CyNode source = edge.getSource();
            CyNode target = edge.getTarget();
            CyEdge newEdge = this.network.addEdge(source, target, false);
            this.network.getRow((CyIdentifiable)newEdge).set("name", (Object)((String)this.network.getRow((CyIdentifiable)source).get("name", String.class) + " (" + SIFInterpreterTask.interactionType + ") " + (String)this.network.getRow((CyIdentifiable)target).get("name", String.class)));
            this.network.getRow((CyIdentifiable)newEdge).set("interaction", (Object)SIFInterpreterTask.interactionType);
            newEdges.add(newEdge);
        }
        this.edges = newEdges;
    }

    public void undo() {
        this.network.removeEdges(this.edges);
    }
}

