/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.editor.internal;

import java.awt.geom.Point2D;
import java.util.Collection;
import org.cytoscape.editor.internal.ClipboardManagerImpl;
import org.cytoscape.editor.internal.PasteEdit;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.AbstractNetworkViewTask;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.undo.AbstractCyEdit;
import org.cytoscape.work.undo.UndoSupport;

public class PasteTask
extends AbstractNetworkViewTask {
    private final Point2D xformPt;
    private final ClipboardManagerImpl clipMgr;
    private final CyServiceRegistrar serviceRegistrar;

    public PasteTask(CyNetworkView view, Point2D xformPt, ClipboardManagerImpl clipMgr, CyServiceRegistrar serviceRegistrar) {
        super(view);
        this.xformPt = xformPt;
        this.clipMgr = clipMgr;
        this.serviceRegistrar = serviceRegistrar;
    }

    public void run(TaskMonitor tm) throws Exception {
        tm.setTitle("Paste Task");
        double x = this.xformPt == null ? 0.0 : this.xformPt.getX();
        double y = this.xformPt == null ? 0.0 : this.xformPt.getY();
        Collection<Object> pastedObjects = this.clipMgr.paste(this.view, x, y);
        if (pastedObjects == null) {
            tm.showMessage(TaskMonitor.Level.WARN, "Nothing to paste");
            return;
        }
        UndoSupport undoSupport = (UndoSupport)this.serviceRegistrar.getService(UndoSupport.class);
        undoSupport.postEdit((AbstractCyEdit)new PasteEdit(this.view, this.xformPt, this.clipMgr, pastedObjects, this.serviceRegistrar));
        VisualMappingManager vmMgr = (VisualMappingManager)this.serviceRegistrar.getService(VisualMappingManager.class);
        VisualStyle vs = vmMgr.getVisualStyle(this.view);
        for (Object element : pastedObjects) {
            View elementView;
            if (element instanceof CyNode) {
                CyNode node = (CyNode)element;
                elementView = this.view.getNodeView(node);
                vs.apply(((CyNetwork)this.view.getModel()).getRow((CyIdentifiable)node), elementView);
                continue;
            }
            if (!(element instanceof CyEdge)) continue;
            CyEdge edge = (CyEdge)element;
            elementView = this.view.getEdgeView(edge);
            vs.apply(((CyNetwork)this.view.getModel()).getRow((CyIdentifiable)edge), elementView);
        }
        this.view.updateView();
        tm.setStatusMessage("Pasted " + pastedObjects.size() + " nodes and/or edges");
    }
}

