/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.editor.internal;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import org.cytoscape.editor.internal.ClipboardImpl;
import org.cytoscape.editor.internal.ClipboardManagerImpl;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.presentation.annotations.Annotation;
import org.cytoscape.view.presentation.annotations.AnnotationManager;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.work.undo.AbstractCyEdit;

public class PasteEdit
extends AbstractCyEdit {
    private final CyNetworkView view;
    private final Point2D xformPt;
    private final ClipboardImpl clipboard;
    private final CyServiceRegistrar registrar;
    private Collection<Object> pastedObjects;

    public PasteEdit(CyNetworkView view, Point2D xformPt, ClipboardManagerImpl clipMgr, Collection<Object> pastedObjects, CyServiceRegistrar registrar) {
        super("Paste");
        this.view = view;
        this.xformPt = xformPt;
        this.clipboard = clipMgr.getCurrentClipboard();
        this.pastedObjects = pastedObjects;
        this.registrar = registrar;
    }

    public void undo() {
        ArrayList<CyNode> nodeList = new ArrayList<CyNode>();
        ArrayList<CyEdge> edgeList = new ArrayList<CyEdge>();
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        for (Object object : this.pastedObjects) {
            if (object instanceof CyEdge) {
                CyEdge edge = (CyEdge)object;
                edgeList.add(edge);
                continue;
            }
            if (object instanceof CyNode) {
                CyNode node = (CyNode)object;
                nodeList.add(node);
                continue;
            }
            if (!(object instanceof Annotation)) continue;
            Annotation ann = (Annotation)object;
            annotations.add(ann);
        }
        ((CyNetwork)this.view.getModel()).removeEdges(edgeList);
        ((CyNetwork)this.view.getModel()).removeNodes(nodeList);
        AnnotationManager annotatioManager = (AnnotationManager)this.registrar.getService(AnnotationManager.class);
        annotatioManager.removeAnnotations(annotations);
        this.view.updateView();
    }

    public void redo() {
        double x = this.xformPt == null ? 0.0 : this.xformPt.getX();
        double y = this.xformPt == null ? 0.0 : this.xformPt.getY();
        this.pastedObjects = this.clipboard.paste(this.view, x, y);
        VisualMappingManager vmMgr = (VisualMappingManager)this.registrar.getService(VisualMappingManager.class);
        AnnotationManager annotationManager = (AnnotationManager)this.registrar.getService(AnnotationManager.class);
        VisualStyle vs = vmMgr.getVisualStyle(this.view);
        for (Object element : this.pastedObjects) {
            View elementView;
            if (element instanceof CyNode) {
                CyNode node = (CyNode)element;
                elementView = this.view.getNodeView(node);
                vs.apply(((CyNetwork)this.view.getModel()).getRow((CyIdentifiable)node), elementView);
                continue;
            }
            if (element instanceof CyEdge) {
                CyEdge edge = (CyEdge)element;
                elementView = this.view.getEdgeView(edge);
                vs.apply(((CyNetwork)this.view.getModel()).getRow((CyIdentifiable)edge), elementView);
                continue;
            }
            if (!(element instanceof Annotation)) continue;
            Annotation ann = (Annotation)element;
            annotationManager.addAnnotation(ann);
        }
        this.view.updateView();
    }
}

