/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.editor.internal;

import java.util.List;
import org.cytoscape.editor.internal.ClipboardManagerImpl;
import org.cytoscape.editor.internal.CutTask;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyTableUtil;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.AbstractNetworkViewTaskFactory;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.presentation.annotations.AnnotationManager;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;

public class CutTaskFactory
extends AbstractNetworkViewTaskFactory {
    private final ClipboardManagerImpl clipMgr;
    private final CyServiceRegistrar serviceRegistrar;

    public CutTaskFactory(ClipboardManagerImpl clipboardMgr, CyServiceRegistrar serviceRegistrar) {
        this.clipMgr = clipboardMgr;
        this.serviceRegistrar = serviceRegistrar;
    }

    public TaskIterator createTaskIterator(CyNetworkView networkView) {
        return new TaskIterator(new Task[]{new CutTask(networkView, this.clipMgr, this.serviceRegistrar)});
    }

    public boolean isReady(CyNetworkView networkView) {
        if (!super.isReady(networkView)) {
            return false;
        }
        List nodes = CyTableUtil.getNodesInState((CyNetwork)((CyNetwork)networkView.getModel()), (String)"selected", (boolean)true);
        if (nodes != null && !nodes.isEmpty()) {
            return true;
        }
        List edges = CyTableUtil.getEdgesInState((CyNetwork)((CyNetwork)networkView.getModel()), (String)"selected", (boolean)true);
        if (edges != null && !edges.isEmpty()) {
            return true;
        }
        List annotations = ((AnnotationManager)this.serviceRegistrar.getService(AnnotationManager.class)).getSelectedAnnotations(networkView);
        return annotations != null && !annotations.isEmpty();
    }
}

