/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.editor.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cytoscape.editor.internal.ClipboardImpl;
import org.cytoscape.editor.internal.ClipboardManagerImpl;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTableUtil;
import org.cytoscape.model.subnetwork.CySubNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.VisualLexicon;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.presentation.annotations.AnnotationManager;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.undo.AbstractCyEdit;
import org.cytoscape.work.undo.UndoSupport;

public class CutTask
extends AbstractTask {
    private final CyNetworkView netView;
    private final ClipboardManagerImpl clipMgr;
    private final Set<CyNode> selNodes;
    private final Set<CyEdge> selEdges;
    private final Map<CyEdge, Map<VisualProperty<?>, Object>> deletedEdges;
    private final CyServiceRegistrar serviceRegistrar;

    public CutTask(CyNetworkView netView, ClipboardManagerImpl clipMgr, CyServiceRegistrar serviceRegistrar) {
        this.netView = netView;
        this.clipMgr = clipMgr;
        this.serviceRegistrar = serviceRegistrar;
        this.selNodes = new HashSet<CyNode>(CyTableUtil.getNodesInState((CyNetwork)((CyNetwork)netView.getModel()), (String)"selected", (boolean)true));
        this.selEdges = new HashSet<CyEdge>(CyTableUtil.getEdgesInState((CyNetwork)((CyNetwork)netView.getModel()), (String)"selected", (boolean)true));
        this.deletedEdges = new HashMap();
    }

    public CutTask(CyNetworkView netView, View<? extends CyIdentifiable> objView, ClipboardManagerImpl clipMgr, CyServiceRegistrar serviceRegistrar) {
        this(netView, clipMgr, serviceRegistrar);
        if (objView.getModel() instanceof CyNode) {
            this.selNodes.add((CyNode)objView.getModel());
        } else if (objView.getModel() instanceof CyEdge) {
            this.selEdges.add((CyEdge)objView.getModel());
        }
    }

    public void run(TaskMonitor tm) throws Exception {
        VisualMappingManager vmMgr = (VisualMappingManager)this.serviceRegistrar.getService(VisualMappingManager.class);
        VisualLexicon lexicon = (VisualLexicon)vmMgr.getAllVisualLexicon().iterator().next();
        Collection edgeProps = lexicon.getAllDescendants(BasicVisualLexicon.EDGE);
        tm.setTitle("Cut Task");
        for (CyNode node : this.selNodes) {
            List adjacentEdgeList = ((CyNetwork)this.netView.getModel()).getAdjacentEdgeList(node, CyEdge.Type.ANY);
            for (CyEdge edge : adjacentEdgeList) {
                if (this.selEdges.contains(edge)) continue;
                this.deletedEdges.put(edge, new HashMap());
                View edgeView = this.netView.getEdgeView(edge);
                if (edgeView == null) continue;
                ClipboardImpl.saveLockedValues(edgeView, edgeProps, this.deletedEdges);
            }
        }
        List selAnnotations = ((AnnotationManager)this.serviceRegistrar.getService(AnnotationManager.class)).getSelectedAnnotations(this.netView);
        this.clipMgr.cut(this.netView, this.selNodes, this.selEdges, selAnnotations);
        tm.setStatusMessage("Cut " + this.selNodes.size() + " nodes and " + this.selEdges.size() + " edges and copied them to the clipboard");
        UndoSupport undoSupport = (UndoSupport)this.serviceRegistrar.getService(UndoSupport.class);
        undoSupport.postEdit((AbstractCyEdit)new CutEdit());
    }

    private class CutEdit
    extends AbstractCyEdit {
        private final ClipboardImpl clipboard;

        public CutEdit() {
            super("Cut");
            this.clipboard = CutTask.this.clipMgr.getCurrentClipboard();
        }

        public void redo() {
            CutTask.this.clipMgr.cut(CutTask.this.netView, this.clipboard.getNodes(), this.clipboard.getEdges(), this.clipboard.getAnnotations());
            CutTask.this.netView.updateView();
        }

        public void undo() {
            CutTask.this.clipMgr.setCurrentClipboard(this.clipboard);
            HashSet<Object> objects = new HashSet<Object>(CutTask.this.clipMgr.paste(CutTask.this.netView, 0.0, 0.0));
            if (CutTask.this.netView.getModel() instanceof CySubNetwork) {
                CySubNetwork net = (CySubNetwork)CutTask.this.netView.getModel();
                for (CyEdge cyEdge : CutTask.this.deletedEdges.keySet()) {
                    if (net.containsEdge(cyEdge)) continue;
                    net.addEdge(cyEdge);
                    objects.add(cyEdge);
                }
            }
            CyEventHelper eventHelper = (CyEventHelper)CutTask.this.serviceRegistrar.getService(CyEventHelper.class);
            eventHelper.flushPayloadEvents();
            for (Map.Entry entry : CutTask.this.deletedEdges.entrySet()) {
                View edgeView = CutTask.this.netView.getEdgeView((CyEdge)entry.getKey());
                if (edgeView == null) continue;
                ClipboardImpl.setLockedValues(edgeView, (CyEdge)edgeView.getModel(), CutTask.this.deletedEdges);
            }
            VisualMappingManager vmMgr = (VisualMappingManager)CutTask.this.serviceRegistrar.getService(VisualMappingManager.class);
            VisualStyle visualStyle = vmMgr.getVisualStyle(CutTask.this.netView);
            for (Object element : objects) {
                View view = null;
                if (element instanceof CyNode) {
                    CyNode node = (CyNode)element;
                    view = CutTask.this.netView.getNodeView(node);
                } else if (element instanceof CyEdge) {
                    CyEdge edge = (CyEdge)element;
                    view = CutTask.this.netView.getEdgeView(edge);
                }
                if (view == null) continue;
                visualStyle.apply(((CyNetwork)CutTask.this.netView.getModel()).getRow((CyIdentifiable)element), view);
            }
            CutTask.this.netView.updateView();
        }
    }
}

