/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.editor.internal;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.cytoscape.editor.internal.ClipboardManagerImpl;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTableUtil;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.presentation.annotations.AnnotationManager;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;

public class CopyTask
extends AbstractTask {
    private final CyNetworkView netView;
    private final Set<CyNode> nodes;
    private final Set<CyEdge> edges;
    private final ClipboardManagerImpl clipMgr;
    private final CyServiceRegistrar serviceRegistrar;

    public CopyTask(CyNetworkView netView, ClipboardManagerImpl clipMgr, CyServiceRegistrar serviceRegistrar) {
        this.netView = netView;
        this.clipMgr = clipMgr;
        this.serviceRegistrar = serviceRegistrar;
        this.nodes = new HashSet<CyNode>(CyTableUtil.getNodesInState((CyNetwork)((CyNetwork)netView.getModel()), (String)"selected", (boolean)true));
        this.edges = new HashSet<CyEdge>(CyTableUtil.getEdgesInState((CyNetwork)((CyNetwork)netView.getModel()), (String)"selected", (boolean)true));
    }

    public CopyTask(CyNetworkView netView, View<? extends CyIdentifiable> objView, ClipboardManagerImpl clipMgr, CyServiceRegistrar serviceRegistrar) {
        this(netView, clipMgr, serviceRegistrar);
        if (objView.getModel() instanceof CyNode) {
            this.nodes.add((CyNode)objView.getModel());
        } else if (objView.getModel() instanceof CyEdge) {
            this.edges.add((CyEdge)objView.getModel());
        }
    }

    public void run(TaskMonitor tm) throws Exception {
        tm.setTitle("Copy Task");
        List annotations = ((AnnotationManager)this.serviceRegistrar.getService(AnnotationManager.class)).getSelectedAnnotations(this.netView);
        this.clipMgr.copy(this.netView, this.nodes, this.edges, annotations);
        tm.setStatusMessage("Copied " + this.nodes.size() + " node(s) and " + this.edges.size() + " edge(s) to the clipboard");
    }
}

