/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.editor.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.cytoscape.editor.internal.ClipboardImpl;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.VisualLexicon;
import org.cytoscape.view.presentation.annotations.Annotation;
import org.cytoscape.view.presentation.annotations.AnnotationFactory;
import org.cytoscape.view.presentation.annotations.AnnotationManager;
import org.cytoscape.view.vizmap.VisualMappingManager;

public final class ClipboardManagerImpl {
    private ClipboardImpl currentClipboard;
    private List<AnnotationFactory<? extends Annotation>> annotationFactories = new ArrayList<AnnotationFactory<? extends Annotation>>();
    private final CyServiceRegistrar serviceRegistrar;

    public ClipboardManagerImpl(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
    }

    public boolean clipboardHasData() {
        return this.currentClipboard == null ? false : this.currentClipboard.clipboardHasData();
    }

    public ClipboardImpl getCurrentClipboard() {
        return this.currentClipboard;
    }

    public void setCurrentClipboard(ClipboardImpl clip) {
        this.currentClipboard = clip;
    }

    public void copy(CyNetworkView networkView, Collection<CyNode> nodes, Collection<CyEdge> edges, Collection<Annotation> annotations) {
        this.copy(networkView, nodes, edges, annotations, false);
    }

    public void copy(CyNetworkView networkView, Collection<CyNode> nodes, Collection<CyEdge> edges, Collection<Annotation> annotations, boolean cut) {
        VisualMappingManager vmMgr = (VisualMappingManager)this.serviceRegistrar.getService(VisualMappingManager.class);
        VisualLexicon lexicon = (VisualLexicon)vmMgr.getAllVisualLexicon().iterator().next();
        this.currentClipboard = new ClipboardImpl(networkView, nodes, edges, annotations, cut, lexicon, this.annotationFactories, this.serviceRegistrar);
    }

    public void cut(CyNetworkView networkView, Collection<CyNode> nodes, Collection<CyEdge> edges, Collection<Annotation> annotations) {
        this.copy(networkView, nodes, edges, annotations, true);
        ((CyNetwork)networkView.getModel()).removeEdges(edges);
        ((CyNetwork)networkView.getModel()).removeNodes(nodes);
        ((AnnotationManager)this.serviceRegistrar.getService(AnnotationManager.class)).removeAnnotations(annotations);
        networkView.updateView();
    }

    public Collection<Object> paste(CyNetworkView targetView, double x, double y) {
        if (this.currentClipboard == null) {
            return null;
        }
        return this.currentClipboard.paste(targetView, x, y);
    }

    public void addAnnotationFactory(AnnotationFactory<?> factory, Map<?, ?> props) {
        if (factory != null) {
            this.annotationFactories.add(factory);
        }
    }

    public void removeAnnotationFactory(AnnotationFactory<?> factory, Map<?, ?> props) {
        if (factory != null) {
            this.annotationFactories.remove(factory);
        }
    }
}

