/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.editor.internal;

import java.awt.geom.Point2D;
import java.util.Collections;
import org.cytoscape.editor.internal.AddNodeTask;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.work.FinishStatus;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskObserver;
import org.cytoscape.work.swing.DialogTaskManager;
import org.cytoscape.work.undo.AbstractCyEdit;
import org.cytoscape.work.undo.UndoSupport;

public class AddNodeEdit
extends AbstractCyEdit {
    private final CyNetworkView view;
    private final Point2D xformPt;
    private final String nodeName;
    private final CyServiceRegistrar registrar;
    private CyNode node;

    public AddNodeEdit(CyNetworkView view, CyNode node, Point2D xformPt, String nodeName, CyServiceRegistrar registrar) {
        super("Add Node");
        this.view = view;
        this.node = node;
        this.xformPt = xformPt;
        this.nodeName = nodeName;
        this.registrar = registrar;
    }

    public void undo() {
        CyNetwork network = (CyNetwork)this.view.getModel();
        network.removeNodes(Collections.singleton(this.node));
    }

    public void redo() {
        AddNodeTask addNodeTask = new AddNodeTask(this.view, this.xformPt, this.nodeName, this.registrar);
        addNodeTask.setPostUndo(false);
        DialogTaskManager taskManager = (DialogTaskManager)this.registrar.getService(DialogTaskManager.class);
        taskManager.execute(new TaskIterator(new Task[]{addNodeTask}), new TaskObserver(){

            public void taskFinished(ObservableTask task) {
                if (task instanceof AddNodeTask) {
                    AddNodeEdit.this.node = ((AddNodeTask)task).getResults(CyNode.class);
                }
            }

            public void allFinished(FinishStatus finishStatus) {
            }
        });
    }

    public void post() {
        ((UndoSupport)this.registrar.getService(UndoSupport.class)).postEdit((AbstractCyEdit)this);
    }
}

