/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.work.util;

import org.cytoscape.work.util.AbstractBounded;

public final class BoundedFloat
extends AbstractBounded<Float> {
    public BoundedFloat(Float lower, Float initValue, Float upper, boolean lowerStrict, boolean upperStrict) {
        super(lower, initValue, upper, lowerStrict, upperStrict);
    }

    @Override
    public void setValue(String s) {
        this.setValue(Float.valueOf(s));
    }

    @Override
    public Float clamp(Float value) {
        if (value.floatValue() <= ((Float)this.getLowerBound()).floatValue()) {
            if (!this.isLowerBoundStrict()) {
                return (Float)this.getLowerBound();
            }
            return Float.valueOf(Math.nextAfter(value.floatValue(), Double.NEGATIVE_INFINITY));
        }
        if (value.floatValue() >= ((Float)this.getUpperBound()).floatValue()) {
            if (!this.isUpperBoundStrict()) {
                return (Float)this.getUpperBound();
            }
            return Float.valueOf(Math.nextAfter(value.floatValue(), Double.POSITIVE_INFINITY));
        }
        return value;
    }
}

