/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.work;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.Task;

public final class TaskIterator
implements Iterator<Task> {
    private final List<Task> tasks;
    private int currentIndex;
    private int numTasks;

    public TaskIterator(int expectedNumTasks, Task ... initialTasks) {
        this.tasks = new ArrayList<Task>(initialTasks.length);
        this.currentIndex = 0;
        this.numTasks = expectedNumTasks;
        for (Task initialTask : initialTasks) {
            this.tryToAddSelfReferenceToTask(initialTask);
            this.tasks.add(initialTask);
        }
    }

    public TaskIterator(Task ... initialTasks) {
        this(initialTasks.length, initialTasks);
    }

    public void insertTasksAfter(Task referenceTask, Task ... newTasks) throws IllegalStateException {
        int referenceIndex = this.tasks.indexOf(referenceTask);
        if (referenceIndex == -1) {
            throw new IllegalStateException("invalid reference task in call to insertTaskAfter().");
        }
        this.numTasks += newTasks.length;
        int offset = 0;
        for (Task newTask : newTasks) {
            this.tryToAddSelfReferenceToTask(newTask);
            this.tasks.add(referenceIndex + ++offset, newTask);
        }
    }

    public void insertTasksAfter(Task referenceTask, TaskIterator newTasks) throws IllegalStateException {
        int referenceIndex = this.tasks.indexOf(referenceTask);
        if (referenceIndex == -1) {
            throw new IllegalStateException("invalid reference task in call to insertTaskAfter().");
        }
        this.numTasks += newTasks.getNumTasks();
        int offset = 0;
        while (newTasks.hasNext()) {
            Task newTask = newTasks.next();
            this.tryToAddSelfReferenceToTask(newTask);
            this.tasks.add(referenceIndex + ++offset, newTask);
        }
    }

    @Override
    public boolean hasNext() {
        return this.currentIndex < this.tasks.size();
    }

    @Override
    public Task next() {
        if (this.currentIndex < this.tasks.size()) {
            ++this.currentIndex;
            return this.tasks.get(this.currentIndex - 1);
        }
        throw new NoSuchElementException("call to next() even though hasNext() is false.");
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("TaskIteratorImpl.remove() has not been implemented.");
    }

    private void tryToAddSelfReferenceToTask(Task newTask) {
        if (newTask instanceof AbstractTask) {
            try {
                ((AbstractTask)newTask).setTaskIterator(this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public int getNumTasks() {
        return this.numTasks;
    }

    public void append(Task task) {
        ++this.numTasks;
        this.tryToAddSelfReferenceToTask(task);
        this.tasks.add(task);
    }

    public void append(TaskIterator taskIterator) {
        this.numTasks += taskIterator.getNumTasks();
        while (taskIterator.hasNext()) {
            Task newTask = taskIterator.next();
            this.tryToAddSelfReferenceToTask(newTask);
            this.tasks.add(newTask);
        }
    }
}

